/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity;

import fathertoast.specialmobs.config.Config;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class MobHelper {
    public static final int AI_BIT_NONE = 0;
    public static final int AI_BIT_MOVEMENT = 1;
    public static final int AI_BIT_FACING = 2;
    public static final int AI_BIT_SWIMMING = 4;
    private static final PotionEffect[] POTIONS_PLAGUE = new PotionEffect[]{new PotionEffect(MobEffects.field_76421_d, 2, 0), new PotionEffect(MobEffects.field_76419_f, 2, 1), new PotionEffect(MobEffects.field_76440_q, 1, 0), new PotionEffect(MobEffects.field_76438_s, 2, 0), new PotionEffect(MobEffects.field_76437_t, 1, 0), new PotionEffect(MobEffects.field_76436_u, 1, 0), new PotionEffect(MobEffects.field_76431_k, 2, 0)};
    private static final PotionEffect[] POTIONS_WITCH = new PotionEffect[]{new PotionEffect(MobEffects.field_76421_d, 1, 1), new PotionEffect(MobEffects.field_76419_f, 2, 1), new PotionEffect(MobEffects.field_76429_m, 1, -3), new PotionEffect(MobEffects.field_76440_q, 1, 0), new PotionEffect(MobEffects.field_76438_s, 2, 0), new PotionEffect(MobEffects.field_76437_t, 1, 0), new PotionEffect(MobEffects.field_82731_v, 1, 0), new PotionEffect(MobEffects.field_188424_y, 1, 1), new PotionEffect(MobEffects.field_189112_A, 2, 1), new PotionEffect(MobEffects.field_76436_u, 1, 0)};

    public static boolean isDamageSourceIneffectiveAgainstVampires(DamageSource damageSource) {
        if (damageSource != null) {
            if (damageSource.func_76357_e()) {
                return false;
            }
            Entity attacker = damageSource.func_76346_g();
            if (attacker instanceof EntityLivingBase) {
                ItemStack weapon = ((EntityLivingBase)attacker).func_184614_ca();
                return !Item.ToolMaterial.WOOD.toString().equals(MobHelper.getToolMaterialName(weapon)) && EnchantmentHelper.func_152377_a((ItemStack)weapon, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEAD) <= 0.0f;
            }
        }
        return true;
    }

    private static String getToolMaterialName(ItemStack item) {
        if (!item.func_190926_b()) {
            if (item.func_77973_b() instanceof ItemSword) {
                return ((ItemSword)item.func_77973_b()).func_150932_j();
            }
            if (item.func_77973_b() instanceof ItemTool) {
                return ((ItemTool)item.func_77973_b()).func_77861_e();
            }
            if (item.func_77973_b() instanceof ItemHoe) {
                return ((ItemHoe)item.func_77973_b()).func_77842_f();
            }
        }
        return "";
    }

    public static boolean attackEntityAsMob(EntityLivingBase attacker, Entity target) {
        boolean success;
        float damage = (float)attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (target instanceof EntityLivingBase) {
            damage += EnchantmentHelper.func_152377_a((ItemStack)attacker.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)target).func_70668_bt());
            knockback += EnchantmentHelper.func_77501_a((EntityLivingBase)attacker);
        }
        if (success = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)attacker), damage)) {
            int fireAspect;
            if (knockback > 0) {
                ((EntityLivingBase)target).func_70653_a((Entity)attacker, (float)knockback * 0.5f, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)))));
                attacker.field_70159_w *= 0.6;
                attacker.field_70179_y *= 0.6;
            }
            if ((fireAspect = EnchantmentHelper.func_90036_a((EntityLivingBase)attacker)) > 0) {
                target.func_70015_d(fireAspect * 4);
            }
            if (target instanceof EntityPlayer) {
                ItemStack shield;
                ItemStack weapon = attacker.func_184614_ca();
                EntityPlayer entityplayer = (EntityPlayer)target;
                ItemStack itemStack = shield = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!weapon.func_190926_b() && !shield.func_190926_b() && weapon.func_77973_b().canDisableShield(weapon, shield, (EntityLivingBase)entityplayer, attacker) && shield.func_77973_b().isShield(shield, (EntityLivingBase)entityplayer)) {
                    float shieldDisableChance = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)attacker) * 0.05f;
                    if (attacker.func_70681_au().nextFloat() < shieldDisableChance) {
                        entityplayer.func_184811_cZ().func_185145_a(shield.func_77973_b(), 100);
                        attacker.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            if (target instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)target), (Entity)attacker);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)attacker, (Entity)target);
        }
        return success;
    }

    public static ItemStack stealRandomFood(EntityPlayer player) {
        ItemStack item;
        int i;
        int count = 0;
        for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            item = player.field_71071_by.func_70301_a(i);
            if (item.func_190926_b() || !(item.func_77973_b() instanceof ItemFood)) continue;
            ++count;
        }
        if (count > 0) {
            count = player.func_70681_au().nextInt(count);
            for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                item = player.field_71071_by.func_70301_a(i);
                if (item.func_190926_b() || !(item.func_77973_b() instanceof ItemFood) || --count >= 0) continue;
                return player.field_71071_by.func_70298_a(i, 1);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static void stealPotionEffect(EntityLivingBase attacker, EntityLivingBase target) {
        if (!attacker.field_70170_p.field_72995_K) {
            for (PotionEffect potion : target.func_70651_bq()) {
                if (potion == null || potion.func_188419_a().func_76398_f() || potion.func_76458_c() < 0) continue;
                target.func_184589_d(potion.func_188419_a());
                attacker.func_70690_d(new PotionEffect(potion.func_188419_a(), Math.max(potion.func_76459_b(), 200), potion.func_76458_c()));
                break;
            }
        }
    }

    public static int getDebuffDuration(EnumDifficulty difficulty) {
        switch (difficulty) {
            case PEACEFUL: 
            case EASY: {
                return 60;
            }
            case NORMAL: {
                return 140;
            }
        }
        return 300;
    }

    public static PotionEffect nextPlagueEffect(Random random, World world) {
        int duration = MobHelper.getDebuffDuration(world.func_175659_aa());
        PotionEffect potion = POTIONS_PLAGUE[random.nextInt(POTIONS_PLAGUE.length - (Config.get().GENERAL.DISABLE_NAUSEA ? 1 : 0))];
        return new PotionEffect(potion.func_188419_a(), duration * potion.func_76459_b(), potion.func_76458_c());
    }

    public static PotionEffect nextWitchSpiderEffect(Random random, World world, boolean includePoison) {
        int duration = MobHelper.getDebuffDuration(world.func_175659_aa());
        PotionEffect potion = POTIONS_WITCH[random.nextInt(POTIONS_WITCH.length - (includePoison ? 0 : 1))];
        return new PotionEffect(potion.func_188419_a(), duration * potion.func_76459_b(), potion.func_76458_c());
    }

    public static enum AttributeModOperation {
        ADDITION(0),
        MULTIPLY_BASE(1),
        MULTIPLY_TOTAL(2);

        public final int id;

        private AttributeModOperation(int key) {
            this.id = key;
        }
    }
}

