/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.blaze;

import fathertoast.specialmobs.ai.EntityAISpecialAttackBlaze;
import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.ISpecialMob;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class Entity_SpecialBlaze
extends EntityBlaze
implements ISpecialMob,
IRangedAttackMob {
    private static final String TAG_BURST_COUNT = "FireballBurstCount";
    private static final String TAG_BURST_DELAY = "FireballBurstDelay";
    private static final int AI_PRIORITY_ATTACK = 4;
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(Entity_SpecialBlaze.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/blaze.png")};
    private SpecialMobData specialData;
    public int fireballBurstCount;
    public int fireballBurstDelay;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(16775294);
        return info;
    }

    static String GET_TEXTURE_PATH(String type) {
        return "specialmobs:textures/entity/blaze/" + type + ".png";
    }

    static void ADD_BASE_LOOT(LootTableBuilder loot) {
        loot.addLootTable("main", "Base loot", LootTableList.field_186433_o);
    }

    public Entity_SpecialBlaze(World world) {
        super(world);
        this.getSpecialData().setImmuneToFire(true);
        this.getSpecialData().setDamagedByWater(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAISpecialAttackBlaze(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.setRangedAI(3, 6, 60, 100, 48.0f);
        this.initTypeAI();
    }

    protected void initTypeAI() {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.specialData = new SpecialMobData<Entity_SpecialBlaze>(this, SCALE);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        float prevMax = this.func_110138_aP();
        this.applyTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    protected void applyTypeAttributes() {
    }

    protected void disableRangedAI() {
        this.setRangedAI(0, 6, 60, 100, 0.0f);
    }

    protected void setRangedAI(int burstCount, int burstDelay, int chargeTime, int cooldownTime, float range) {
        this.fireballBurstCount = burstCount;
        this.fireballBurstDelay = burstDelay;
        SpecialMobData data = this.getSpecialData();
        data.rangedAttackCooldown = cooldownTime;
        data.rangedAttackMaxCooldown = cooldownTime + chargeTime;
        data.rangedAttackMaxRange = range;
    }

    @Override
    public final SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public final int getExperience() {
        return this.field_70728_aV;
    }

    @Override
    public final void setExperience(int xp) {
        this.field_70728_aV = xp;
    }

    @Override
    public final void setImmuneToFire(boolean immune) {
        this.field_70178_ae = immune;
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected void onTypeAttack(Entity target) {
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.field_70170_p.func_180498_a(null, 1018, new BlockPos((Entity)this), 0);
        double dX = target.field_70165_t - this.field_70165_t;
        double dY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double dZ = target.field_70161_v - this.field_70161_v;
        float accelVariance = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)this.func_70068_e((Entity)target))) * this.getSpecialData().rangedAttackSpread / 28.0f;
        EntitySmallFireball fireball = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, dX + this.func_70681_au().nextGaussian() * (double)accelVariance, dY, dZ + this.func_70681_au().nextGaussian() * (double)accelVariance);
        fireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
        this.field_70170_p.func_72838_d((Entity)fireball);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    public boolean func_70652_k(Entity target) {
        if (super.func_70652_k(target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    public float func_70047_e() {
        return super.func_70047_e();
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().writeToNBT(saveTag);
        saveTag.func_74774_a(TAG_BURST_COUNT, (byte)this.fireballBurstCount);
        saveTag.func_74774_a(TAG_BURST_DELAY, (byte)this.fireballBurstDelay);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().readFromNBT(saveTag);
        if (saveTag.func_150297_b(TAG_BURST_COUNT, 99)) {
            this.fireballBurstCount = saveTag.func_74771_c(TAG_BURST_COUNT);
        }
        if (saveTag.func_150297_b(TAG_BURST_DELAY, 99)) {
            this.fireballBurstDelay = saveTag.func_74771_c(TAG_BURST_DELAY);
        }
    }

    public void func_70015_d(int time) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.func_70015_d(time);
        }
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing();
    }

    public void func_70110_aj() {
        if (!this.getSpecialData().isImmuneToWebs()) {
            super.func_70110_aj();
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier());
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean func_70687_e(PotionEffect effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }
}

