/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.creeper;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.creeper.Entity_SpecialCreeper;
import fathertoast.specialmobs.loot.LootEntryItemBuilder;
import fathertoast.specialmobs.loot.LootPoolBuilder;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;

public class EntityDrowningCreeper
extends Entity_SpecialCreeper {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityDrowningCreeper.GET_TEXTURE_PATH("drowning")), new ResourceLocation(EntityDrowningCreeper.GET_TEXTURE_PATH("drowning_eyes"))};
    public static ResourceLocation LOOT_TABLE;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(2966004);
        info.weight = 50;
        info.weightExceptions = BestiaryInfo.DEFAULT_THEME_WATER;
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityDrowningCreeper.ADD_BASE_LOOT(loot);
        loot.addPool(new LootPoolBuilder("common").addEntry((LootEntry)new LootEntryItemBuilder("Fish", Items.field_151115_aP).setCount(0, 2).addLootingBonus(0.0f, 1.0f).smeltIfBurning().toLootEntry()).toLootPool());
        loot.addUncommonDrop("uncommon", "Undersea loot", Items.field_151074_bl, Items.field_179562_cC, Items.field_179563_cD);
    }

    public EntityDrowningCreeper(World world) {
        super(world);
        this.getSpecialData().setImmuneToBurning(true);
        this.getSpecialData().setCanBreatheInWater(true);
        this.getSpecialData().setIgnoreWaterPush(true);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void applyTypeAttributes() {
        this.field_70728_aV += 2;
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 10.0);
    }

    @Override
    public void explodeByType(boolean powered, boolean griefing) {
        float power = (float)this.field_82226_g * (powered ? 2.0f : 1.0f) + 3.0f;
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, griefing ? 1.0f : power, false);
        if (!griefing) {
            return;
        }
        IBlockState cobblestone = Blocks.field_150347_e.func_176223_P();
        IBlockState silverfish = Blocks.field_150418_aU.func_176223_P().func_177226_a((IProperty)BlockSilverfish.field_176378_a, (Comparable)BlockSilverfish.EnumType.COBBLESTONE);
        IBlockState water = Blocks.field_150355_j.func_176223_P();
        int radius = (int)Math.floor(power);
        int rMinusOneSq = (radius - 1) * (radius - 1);
        BlockPos center = new BlockPos((Entity)this);
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    int distSq = x * x + y * y + z * z;
                    if (distSq > radius * radius) continue;
                    BlockPos pos = center.func_177982_a(x, y, z);
                    if (distSq > rMinusOneSq) {
                        if (!cobblestone.func_177230_c().func_176196_c(this.field_70170_p, pos)) continue;
                        if (this.field_70146_Z.nextFloat() < 0.25f) {
                            this.field_70170_p.func_180501_a(pos, silverfish, 2);
                            continue;
                        }
                        this.field_70170_p.func_180501_a(pos, cobblestone, 2);
                        continue;
                    }
                    if (!water.func_177230_c().func_176196_c(this.field_70170_p, pos)) continue;
                    this.field_70170_p.func_180501_a(pos, water, 2);
                }
            }
        }
    }
}

