/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.enderman;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.config.EnvironmentListConfig;
import fathertoast.specialmobs.config.TargetEnvironment;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.entity.enderman.Entity_SpecialEnderman;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityMirageEnderman
extends Entity_SpecialEnderman {
    private static final String TAG_IS_FAKE = "IsFake";
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityMirageEnderman.GET_TEXTURE_PATH("mirage")), new ResourceLocation(EntityMirageEnderman.GET_TEXTURE_PATH("mirage_eyes"))};
    public static ResourceLocation LOOT_TABLE;
    public boolean isFake = false;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(12762244);
        info.weight = 50;
        info.weightExceptions = new EnvironmentListConfig(new TargetEnvironment.TargetBiomeGroup("desert", 200.0f), new TargetEnvironment.TargetBiomeGroup("savanna", 200.0f), new TargetEnvironment.TargetBiomeGroup("mesa", 200.0f), new TargetEnvironment.TargetBiome(Biomes.field_76787_r, 200.0f));
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityMirageEnderman.ADD_BASE_LOOT(loot);
        BlockSilverfish.EnumType[] blockDisguiseTypes = BlockSilverfish.EnumType.values();
        ItemStack[] infestedBlocks = new ItemStack[blockDisguiseTypes.length];
        for (int i = 0; i < infestedBlocks.length; ++i) {
            infestedBlocks[i] = new ItemStack(Blocks.field_150418_aU, 1, blockDisguiseTypes[i].func_176881_a());
        }
        loot.addUncommonDrop("uncommon", "Infested block", infestedBlocks);
    }

    public EntityMirageEnderman(World world) {
        super(world);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return this.isFake ? LootTableList.field_186419_a : LOOT_TABLE;
    }

    public void setFake() {
        this.isFake = true;
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        this.field_70728_aV = 0;
    }

    @Override
    protected void applyTypeAttributes() {
        this.field_70728_aV += 2;
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 20.0);
    }

    @Override
    public void onTypeAttack(Entity target) {
        block1: {
            if (this.isFake) break block1;
            int i = 64;
            while (i-- > 0 && !this.func_70820_n()) {
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.isFake && this.field_70173_aa > 200) {
            this.func_70106_y();
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (this.isFake) {
            this.func_70606_j(0.0f);
            return true;
        }
        return super.func_70097_a(damageSource, damage);
    }

    protected boolean func_70820_n() {
        if (this.isFake) {
            return false;
        }
        double xI = this.field_70165_t;
        double yI = this.field_70163_u;
        double zI = this.field_70161_v;
        if (super.func_70820_n()) {
            this.mirage(xI, yI, zI);
            return true;
        }
        return false;
    }

    protected boolean func_70816_c(Entity target) {
        if (this.isFake) {
            return false;
        }
        double xI = this.field_70165_t;
        double yI = this.field_70163_u;
        double zI = this.field_70161_v;
        if (super.func_70816_c(target)) {
            this.mirage(xI, yI, zI);
            return true;
        }
        return false;
    }

    private void mirage(double xI, double yI, double zI) {
        if (!this.isFake && this.func_70638_az() != null) {
            EntityMirageEnderman mirage = new EntityMirageEnderman(this.field_70170_p);
            mirage.setFake();
            mirage.func_82149_j((Entity)this);
            mirage.func_70624_b(this.func_70638_az());
            if (this.field_70146_Z.nextInt(4) == 0) {
                this.func_70107_b(xI, yI, zI);
            } else {
                mirage.func_70107_b(xI, yI, zI);
            }
            mirage.func_70606_j(this.func_110143_aJ());
            this.field_70170_p.func_72838_d((Entity)mirage);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74757_a(TAG_IS_FAKE, this.isFake);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_150297_b(TAG_IS_FAKE, 99)) {
            this.isFake = saveTag.func_74767_n(TAG_IS_FAKE);
        }
    }
}

