/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.skeleton;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.skeleton.Entity_SpecialSkeleton;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntitySpitfireSkeleton
extends Entity_SpecialSkeleton {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntitySpitfireSkeleton.GET_TEXTURE_PATH("fire"))};
    public static ResourceLocation LOOT_TABLE;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(14424576);
        info.weight = 50;
        info.weightExceptions = BestiaryInfo.DEFAULT_THEME_FIRE;
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntitySpitfireSkeleton.ADD_BASE_LOOT(loot);
        loot.addCommonDrop("common", "Fire charges", Items.field_151059_bz);
    }

    public EntitySpitfireSkeleton(World world) {
        super(world);
        this.field_70138_W = 1.0f;
        this.getSpecialData().setBaseScale(1.5f);
        this.getSpecialData().setImmuneToFire(true);
        this.getSpecialData().setDamagedByWater(true);
    }

    @Override
    protected void setCollisionSize(float multiplier) {
        this.func_70105_a(0.9f * multiplier, 2.7f * multiplier);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void applyTypeAttributes() {
        this.field_70728_aV += 2;
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 20.0);
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111264_e, 2.0);
    }

    @Override
    protected void initTypeAI() {
        this.getSpecialData().rangedAttackDamage += 2.0f;
        this.getSpecialData().rangedAttackSpread *= 0.5f;
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        if (!(this.func_184614_ca().func_77973_b() instanceof ItemBow)) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        }
    }

    @Override
    protected void onTypeAttack(Entity target) {
        target.func_70015_d(10);
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.field_70170_p.func_180498_a(null, 1018, new BlockPos((Entity)this), 0);
        double dX = target.field_70165_t - this.field_70165_t;
        double dY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double dZ = target.field_70161_v - this.field_70161_v;
        float accelVariance = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)this.func_70068_e((Entity)target))) * this.getSpecialData().rangedAttackSpread / 28.0f;
        for (int i = 0; i < 3; ++i) {
            EntitySmallFireball fireball = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, dX + this.func_70681_au().nextGaussian() * (double)accelVariance, dY, dZ + this.func_70681_au().nextGaussian() * (double)accelVariance);
            fireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
            this.field_70170_p.func_72838_d((Entity)fireball);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (damageSource.func_76364_f() instanceof EntitySnowball) {
            damage = Math.max(2.0f, damage);
        }
        return super.func_70097_a(damageSource, damage);
    }

    public boolean func_70027_ad() {
        return this.func_70089_S() && !this.func_70026_G();
    }

    @Override
    public boolean func_70631_g_() {
        return false;
    }

    @Override
    public void setChild(boolean child) {
    }
}

