/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.spider;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.MobHelper;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.entity.spider.Entity_SpecialSpider;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityHungrySpider
extends Entity_SpecialSpider {
    private static final String TAG_FEEDING_LEVEL = "FeedLevel";
    private static final String TAG_GAINED_HEALTH = "GrowCount";
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityHungrySpider.GET_TEXTURE_PATH("hungry")), new ResourceLocation(EntityHungrySpider.GET_TEXTURE_PATH("hungry_eyes"))};
    public static ResourceLocation LOOT_TABLE;
    private int feedingLevel;
    private int gainedHealth;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(7969893);
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityHungrySpider.ADD_BASE_LOOT(loot);
        loot.addCommonDrop("common", "Bones", Items.field_151103_aS);
        loot.addUncommonDrop("uncommon", "Food", Items.field_151034_e, Items.field_185164_cV, Items.field_151078_bh, Items.field_151076_bf, Items.field_179558_bo, Items.field_151106_aX);
    }

    public EntityHungrySpider(World world) {
        super(world);
        this.func_70105_a(1.9f, 1.3f);
        this.getSpecialData().setBaseScale(1.5f);
        this.getSpecialData().setRegenerationTime(40);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void applyTypeAttributes() {
        this.field_70728_aV += 2;
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 4.0);
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111264_e, -1.0);
    }

    @Override
    protected void initTypeAI() {
        this.getSpecialData().rangedAttackMaxRange = 0.0f;
    }

    @Override
    public void onTypeAttack(Entity target) {
        ItemStack food;
        if (target instanceof EntityPlayer && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) && !(food = MobHelper.stealRandomFood((EntityPlayer)target)).func_190926_b()) {
            if (this.gainedHealth < 32) {
                ++this.gainedHealth;
                float maxHealth = this.func_110138_aP();
                this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 2.0);
                this.func_70606_j(this.func_110143_aJ() + this.func_110138_aP() - maxHealth);
            }
            if (this.feedingLevel < 7) {
                ++this.feedingLevel;
                this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111264_e, 1.0);
            }
            this.func_70691_i(Math.max((float)((ItemFood)food.func_77973_b()).func_150905_g(food), 1.0f));
            this.func_184185_a(SoundEvents.field_187739_dZ, 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74774_a(TAG_FEEDING_LEVEL, (byte)this.feedingLevel);
        saveTag.func_74774_a(TAG_GAINED_HEALTH, (byte)this.gainedHealth);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_150297_b(TAG_FEEDING_LEVEL, 99)) {
            this.feedingLevel = saveTag.func_74771_c(TAG_FEEDING_LEVEL);
        }
        if (saveTag.func_150297_b(TAG_GAINED_HEALTH, 99)) {
            this.gainedHealth = saveTag.func_74771_c(TAG_GAINED_HEALTH);
        }
    }
}

