/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.witch;

import fathertoast.specialmobs.ObfuscationHelper;
import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.ISpecialMob;
import fathertoast.specialmobs.entity.MobHelper;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.loot.LootTableBuilder;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class Entity_SpecialWitch
extends EntityWitch
implements ISpecialMob {
    private static final String TAG_POTION_USE_TIME = "PotionUseTimer";
    private static final String TAG_SHEATHED_ITEM = "SheathedItem";
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(Entity_SpecialWitch.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final UUID DRINKING_POTION_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier DRINKING_POTION_MODIFIER = new AttributeModifier(DRINKING_POTION_UUID, "Drinking speed penalty", -0.25, MobHelper.AttributeModOperation.ADDITION.id).func_111168_a(false);
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/witch.png")};
    private boolean fakeDrinkingPotion;
    private SpecialMobData specialData;
    protected int potionDrinkTimer;
    protected int potionThrowTimer;
    public ItemStack sheathedItem;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(5349438);
        return info;
    }

    static String GET_TEXTURE_PATH(String type) {
        return "specialmobs:textures/entity/witch/" + type + ".png";
    }

    static void ADD_BASE_LOOT(LootTableBuilder loot) {
        loot.addLootTable("main", "Base loot", LootTableList.field_186432_n);
    }

    public Entity_SpecialWitch(World world) {
        super(world);
        ObfuscationHelper.EntityWitch_potionUseTimer.set(this, Integer.MAX_VALUE);
        this.sheathedItem = ItemStack.field_190927_a;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.initTypeAI();
    }

    protected void initTypeAI() {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.specialData = new SpecialMobData<Entity_SpecialWitch>(this, SCALE);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        float prevMax = this.func_110138_aP();
        this.applyTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    protected void applyTypeAttributes() {
    }

    @Override
    public final SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public final int getExperience() {
        return this.field_70728_aV;
    }

    @Override
    public final void setExperience(int xp) {
        this.field_70728_aV = xp;
    }

    @Override
    public final void setImmuneToFire(boolean immune) {
        this.field_70178_ae = immune;
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected void onTypeAttack(Entity target) {
    }

    public void drinkPotionUpdate() {
        --this.potionThrowTimer;
        if (this.func_184730_o()) {
            --this.potionDrinkTimer;
            if (this.potionDrinkTimer <= 0) {
                List list;
                ItemStack drinkingItem = this.func_184614_ca();
                this.usePotion(ItemStack.field_190927_a);
                if (drinkingItem.func_77973_b() == Items.field_151068_bn && !(list = PotionUtils.func_185189_a((ItemStack)drinkingItem)).isEmpty()) {
                    for (PotionEffect potioneffect : list) {
                        this.func_70690_d(new PotionEffect(potioneffect));
                    }
                }
            }
        } else {
            this.tryDrinkPotion();
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (!this.func_184730_o()) {
            double dX = target.field_70165_t + target.field_70159_w - this.field_70165_t;
            double dY = target.field_70163_u + (double)target.func_70047_e() - 1.1 - this.field_70163_u;
            double dZ = target.field_70161_v + target.field_70179_y - this.field_70161_v;
            float dH = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
            ItemStack potion = this.pickThrownPotion(target, distanceFactor, dH);
            if (!potion.func_190926_b()) {
                EntityPotion thrownPotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, potion);
                thrownPotion.field_70125_A += 20.0f;
                thrownPotion.func_70186_c(dX, dY + (double)(dH * 0.2f), dZ, 0.75f, 8.0f);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                this.field_70170_p.func_72838_d((Entity)thrownPotion);
            }
        }
    }

    private ItemStack pickThrownPotion(EntityLivingBase target, float distanceFactor, float distance) {
        ItemStack potion = target.func_70662_br() ? this.makeSplashPotion(PotionTypes.field_185250_v) : this.makeSplashPotion(PotionTypes.field_185252_x);
        if (distance >= 8.0f && !target.func_70644_a(MobEffects.field_76421_d)) {
            potion = this.makeSplashPotion(PotionTypes.field_185246_r);
        } else if (target.func_110143_aJ() >= 8.0f && !target.func_70644_a(MobEffects.field_76436_u)) {
            potion = this.makeSplashPotion(PotionTypes.field_185254_z);
        } else if (distance <= 3.0f && !target.func_70644_a(MobEffects.field_76437_t) && this.field_70146_Z.nextFloat() < 0.25f) {
            potion = this.makeSplashPotion(PotionTypes.field_185226_I);
        }
        return this.pickThrownPotionByType(potion, target, distanceFactor, distance);
    }

    protected ItemStack pickThrownPotionByType(ItemStack potion, EntityLivingBase target, float distanceFactor, float distance) {
        return potion;
    }

    public void tryDrinkPotion() {
        if (this.potionThrowTimer <= 0) {
            if (this.field_70146_Z.nextFloat() < 0.15f && (this.func_70027_ad() || this.func_189748_bU() != null && this.func_189748_bU().func_76347_k()) && !this.func_70644_a(MobEffects.field_76426_n)) {
                this.usePotion(this.makePotion(PotionTypes.field_185241_m));
            } else if (this.field_70146_Z.nextFloat() < 0.15f && this.func_70055_a(Material.field_151586_h) && !this.func_70644_a(MobEffects.field_76427_o)) {
                this.usePotion(this.makePotion(PotionTypes.field_185248_t));
            } else if (this.field_70146_Z.nextFloat() < 0.05f && this.func_110143_aJ() < this.func_110138_aP()) {
                this.usePotion(this.makePotion(PotionTypes.field_185250_v));
            } else if (this.field_70146_Z.nextFloat() < 0.5f && this.func_70638_az() != null && !this.func_70644_a(MobEffects.field_76424_c) && this.func_70638_az().func_70068_e((Entity)this) > 121.0) {
                this.usePotion(this.makeSplashPotion(PotionTypes.field_185243_o));
            } else {
                this.tryDrinkPotionByType();
            }
        }
    }

    protected void tryDrinkPotionByType() {
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            this.drinkPotionUpdate();
            this.fakeDrinkingPotion = true;
        }
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    public boolean func_70652_k(Entity target) {
        if (super.func_70652_k(target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    public float func_70047_e() {
        return super.func_70047_e() * this.getSpecialData().getBaseScaleForPreScaledValues();
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().writeToNBT(saveTag);
        saveTag.func_74774_a(TAG_POTION_USE_TIME, (byte)this.potionDrinkTimer);
        if (this.potionDrinkTimer > 0) {
            saveTag.func_74782_a(TAG_SHEATHED_ITEM, (NBTBase)this.sheathedItem.serializeNBT());
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().readFromNBT(saveTag);
        if (saveTag.func_150297_b(TAG_POTION_USE_TIME, 99)) {
            this.potionDrinkTimer = saveTag.func_74771_c(TAG_POTION_USE_TIME);
        }
        this.sheathedItem = this.potionDrinkTimer <= 0 || !saveTag.func_150297_b(TAG_SHEATHED_ITEM, (int)tag.func_74732_a()) ? ItemStack.field_190927_a : new ItemStack(saveTag.func_74775_l(TAG_SHEATHED_ITEM));
    }

    public void func_70015_d(int time) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.func_70015_d(time);
        }
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing();
    }

    public void func_70110_aj() {
        if (!this.getSpecialData().isImmuneToWebs()) {
            super.func_70110_aj();
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier());
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean func_70687_e(PotionEffect effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public boolean func_184730_o() {
        if (this.fakeDrinkingPotion) {
            this.fakeDrinkingPotion = false;
            return true;
        }
        return super.func_184730_o();
    }

    public ItemStack makePotion(PotionType type) {
        return PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)type);
    }

    public ItemStack makePotion(Collection<PotionEffect> effects) {
        return PotionUtils.func_185184_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), effects);
    }

    public ItemStack makeSplashPotion(PotionType type) {
        return PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)type);
    }

    public ItemStack makeSplashPotion(Collection<PotionEffect> effects) {
        return PotionUtils.func_185184_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), effects);
    }

    public ItemStack makeLingeringPotion(PotionType type) {
        return PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), (PotionType)type);
    }

    public ItemStack makeLingeringPotion(Collection<PotionEffect> effects) {
        return PotionUtils.func_185184_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), effects);
    }

    public void usePotion(ItemStack potion) {
        if (potion.func_190926_b()) {
            if (this.func_184730_o()) {
                this.potionDrinkTimer = 0;
                this.func_82197_f(false);
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.sheathedItem);
                this.sheathedItem = ItemStack.field_190927_a;
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(DRINKING_POTION_MODIFIER);
            }
        } else if (potion.func_77973_b() == Items.field_151068_bn) {
            this.sheathedItem = this.func_184614_ca();
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, potion);
            this.potionDrinkTimer = this.func_184614_ca().func_77988_m();
            this.func_82197_f(true);
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187922_gv, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            IAttributeInstance attribute = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            attribute.func_111124_b(DRINKING_POTION_MODIFIER);
            attribute.func_111121_a(DRINKING_POTION_MODIFIER);
        } else {
            this.potionThrowTimer = 40;
            SoundEvent sound = null;
            if (potion.func_77973_b() == Items.field_185155_bH) {
                sound = SoundEvents.field_187827_fP;
            } else if (potion.func_77973_b() == Items.field_185156_bI) {
                sound = SoundEvents.field_187756_df;
            }
            if (sound != null) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, sound, this.func_184176_by(), 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                EntityPotion thrownPotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, potion);
                thrownPotion.field_70125_A += 20.0f;
                thrownPotion.field_70179_y = 0.0;
                thrownPotion.field_70159_w = 0.0;
                thrownPotion.field_70181_x = -0.2;
                this.field_70170_p.func_72838_d((Entity)thrownPotion);
            }
        }
    }
}

