/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.blaze;

import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.MobHelper;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.blaze.Entity_SpecialBlaze;

public class EntityJoltBlaze
extends Entity_SpecialBlaze {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "blaze/jolt.png")};

    public EntityJoltBlaze(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        this.field_70728_aV += 2;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.field_70789_a != null && this.field_70146_Z.nextInt(10) == 0 && this.field_70789_a.func_70068_e((Entity)this) > 256.0) {
            this.teleportToEntity(this.field_70789_a);
            this.field_70724_aR = Math.max(20, this.field_70724_aR);
        }
        super.func_70636_d();
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        if (hit) {
            int i = this.field_70146_Z.nextInt(3 + looting);
            while (i-- > 0) {
                this.func_145779_a(Items.field_151137_ax, 1);
            }
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (!this.field_70170_p.field_72995_K && !DamageSource.field_76369_e.field_76373_n.equals(damageSource.field_76373_n)) {
            double xI = this.field_70165_t;
            double yI = this.field_70163_u;
            double zI = this.field_70161_v;
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                if (damageSource instanceof EntityDamageSourceIndirect) {
                    return true;
                }
                boolean hit = super.func_70097_a(damageSource, damage);
                if (this.func_110143_aJ() > 0.0f) {
                    MobHelper.lightningExplode((Entity)this, xI, yI, zI, 0);
                } else {
                    this.func_70107_b(xI, yI, zI);
                }
                return hit;
            }
        }
        return super.func_70097_a(damageSource, damage);
    }

    protected boolean teleportRandomly() {
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 16.0;
        double y = this.field_70163_u + (double)(this.field_70146_Z.nextInt(12) - 4);
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 16.0;
        return this.teleportTo(x, y, z, false);
    }

    protected boolean teleportToEntity(Entity entity) {
        double x = entity.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0;
        double y = entity.field_70163_u + (double)this.field_70146_Z.nextInt(8) - 2.0;
        double z = entity.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0;
        return this.teleportTo(x, y, z, true);
    }

    protected boolean teleportTo(double x, double y, double z, boolean strikeDestination) {
        double xI = this.field_70165_t;
        double yI = this.field_70163_u;
        double zI = this.field_70161_v;
        this.func_70107_b(x, y, z);
        if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() != 0 || this.field_70170_p.func_72953_d(this.field_70121_D)) {
            this.func_70107_b(xI, yI, zI);
            return false;
        }
        for (int i = 0; i < 128; ++i) {
            double posRelative = (double)i / 127.0;
            float vX = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float vY = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float vZ = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double dX = xI + (this.field_70165_t - xI) * posRelative + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double dY = yI + (this.field_70163_u - yI) * posRelative + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double dZ = zI + (this.field_70161_v - zI) * posRelative + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_72869_a("smoke", dX, dY, dZ, (double)vX, (double)vY, (double)vZ);
        }
        if (strikeDestination) {
            MobHelper.lightningExplode((Entity)this, 0);
        }
        return true;
    }
}

