/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.spider;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.spider.Entity_SpecialSpider;

public class EntityDesertSpider
extends Entity_SpecialSpider {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "spider/desert.png"), new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "spider/desert_eyes.png")};

    public EntityDesertSpider(World world) {
        super(world);
        this.func_70105_a(1.0f, 0.8f);
        this.getSpecialData().setTextures(TEXTURES);
        this.getSpecialData().resetRenderScale(0.8f);
        this.field_70728_aV += 2;
    }

    @Override
    public void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 4.0);
    }

    @Override
    public void onTypeAttack(Entity target) {
        if (target instanceof EntityLivingBase) {
            int time;
            switch (target.field_70170_p.field_73013_u) {
                case PEACEFUL: {
                    return;
                }
                case EASY: {
                    time = 3;
                    break;
                }
                case NORMAL: {
                    time = 7;
                    break;
                }
                default: {
                    time = 15;
                }
            }
            EffectHelper.stackEffect((EntityLivingBase)target, Potion.field_76431_k, time *= 20, 1, 5);
            EffectHelper.stackEffect((EntityLivingBase)target, Potion.field_76421_d, time, 1, 5);
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, time, 0));
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, time, -2));
        }
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        int i = this.field_70146_Z.nextInt(2 + looting);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151116_aA, 1);
        }
    }

    protected void func_70600_l(int superRare) {
        ItemStack itemStack = new ItemStack((Item)Items.field_151068_bn, 1, 16387);
        EffectHelper.setItemName(itemStack, "Splash Potion of Desert Venom", 15);
        EffectHelper.addPotionEffect(itemStack, Potion.field_76431_k, 900, 1);
        EffectHelper.addPotionEffect(itemStack, Potion.field_76421_d, 900, 1);
        EffectHelper.addPotionEffect(itemStack, Potion.field_76440_q, 900, 0);
        this.func_70099_a(itemStack, 0.0f);
    }
}

