/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.blocks;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import lucraft.mods.heroes.speedsterheroes.blocks.SHBlocks;
import lucraft.mods.heroes.speedsterheroes.proxies.SpeedsterHeroesProxy;
import lucraft.mods.heroes.speedsterheroes.tileentities.TileEntityParticleAccelerator;
import lucraft.mods.heroes.speedsterheroes.tileentities.TileEntityParticleAcceleratorPart;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.items.LCItems;
import lucraft.mods.lucraftcore.util.LCModelEntry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockParticleAccelerator
extends BlockContainer {
    public static final Vec3d minMultiblockSizeVec = new Vec3d(-1.0, 0.0, 0.0);
    public static final Vec3d maxMultiblockSizeVec = new Vec3d(1.0, 2.0, 4.0);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockParticleAccelerator() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c("particleAccelerator");
        this.setRegistryName("particleAccelerator");
        this.func_149647_a(SpeedsterHeroesProxy.tabSpeedster);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this), (ResourceLocation)new ResourceLocation("speedsterheroes", "particleAccelerator"));
        GameRegistry.registerTileEntity(TileEntityParticleAccelerator.class, (String)"particleAccelerator");
        LucraftCore.proxy.registerModel((Block)this, new LCModelEntry(0, "particleAccelerator"));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isVisuallyOpaque() {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (worldIn.field_72995_K) {
            return false;
        }
        if (te != null && te instanceof TileEntityParticleAccelerator) {
            TileEntityParticleAccelerator tileEntity = (TileEntityParticleAccelerator)te;
            if (this.isMultiBlockStructed((IBlockAccess)worldIn, pos)) {
                if (!tileEntity.isEnabled && playerIn.func_184614_ca() != null && playerIn.func_184614_ca().func_77973_b() == LCItems.hammer) {
                    tileEntity.setIsEnabledAndUpdate(true);
                    ArrayList<BlockPos> list = this.getMultiblockPosList((IBlockAccess)worldIn, (EnumFacing)state.func_177229_b((IProperty)FACING), pos);
                    for (int i = 0; i < list.size(); ++i) {
                        BlockPos p = (BlockPos)list.get(i);
                        if (worldIn.func_175623_d(p) || worldIn.func_175625_s(p) == null || !(worldIn.func_175625_s(p) instanceof TileEntityParticleAcceleratorPart)) continue;
                        ((TileEntityParticleAcceleratorPart)worldIn.func_175625_s(p)).setMasterBlock(pos, pos.func_177956_o() == p.func_177956_o());
                        worldIn.func_184138_a(pos, worldIn.func_180495_p(pos), worldIn.func_180495_p(pos), 3);
                    }
                    worldIn.func_184138_a(pos, worldIn.func_180495_p(pos), worldIn.func_180495_p(pos), 3);
                } else if (tileEntity.isEnabled) {
                    if (playerIn.func_184614_ca() != null && playerIn.func_184614_ca().func_77973_b() == Items.field_151131_as) {
                        if (tileEntity.addWater()) {
                            playerIn.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151133_ar));
                        }
                    } else {
                        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                        tileEntity.letPlayerSit(playerIn, facing);
                    }
                }
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public void updateConnections(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        if (!this.isMultiBlockStructed(world, pos)) {
            for (BlockPos p : this.getMultiblockPosList(world, facing, pos)) {
                if (p.equals((Object)pos) && world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityParticleAccelerator) {
                    ((TileEntityParticleAccelerator)world.func_175625_s(pos)).setIsEnabledAndUpdate(false);
                    ((TileEntityParticleAccelerator)world.func_175625_s(pos)).deleteSitableEntity();
                    continue;
                }
                if (world.func_175625_s(p) == null || !(world.func_175625_s(p) instanceof TileEntityParticleAcceleratorPart)) continue;
                ((TileEntityParticleAcceleratorPart)world.func_175625_s(p)).disconnectFromMaster();
            }
        }
    }

    public void updateConnections(IBlockAccess world, BlockPos pos) {
        this.updateConnections(world, pos, (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING));
    }

    public BlockPos getMinBoundingBox(World world, BlockPos masterBlockPos) {
        if (world.func_180495_p(masterBlockPos) != null && world.func_180495_p(masterBlockPos).func_177230_c().hasTileEntity(world.func_180495_p(masterBlockPos))) {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            for (int i = 0; i < this.getMultiblockPosList((IBlockAccess)world, (EnumFacing)world.func_180495_p(masterBlockPos).func_177229_b((IProperty)FACING), masterBlockPos).size(); ++i) {
                BlockPos pos = this.getMultiblockPosList((IBlockAccess)world, (EnumFacing)world.func_180495_p(masterBlockPos).func_177229_b((IProperty)FACING), masterBlockPos).get(i);
                if (i == 0) {
                    x = pos.func_177958_n();
                    y = pos.func_177956_o();
                    z = pos.func_177952_p();
                }
                if ((double)pos.func_177958_n() < x) {
                    x = pos.func_177958_n();
                }
                if ((double)pos.func_177956_o() < y) {
                    y = pos.func_177956_o();
                }
                if (!((double)pos.func_177952_p() < z)) continue;
                z = pos.func_177952_p();
            }
            return new BlockPos(x, y, z);
        }
        return null;
    }

    public BlockPos getMaxBoundingBox(World world, BlockPos masterBlockPos) {
        if (world.func_180495_p(masterBlockPos) != null && world.func_180495_p(masterBlockPos).func_177230_c().hasTileEntity(world.func_180495_p(masterBlockPos))) {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            for (int i = 0; i < this.getMultiblockPosList((IBlockAccess)world, (EnumFacing)world.func_180495_p(masterBlockPos).func_177229_b((IProperty)FACING), masterBlockPos).size(); ++i) {
                BlockPos pos = this.getMultiblockPosList((IBlockAccess)world, (EnumFacing)world.func_180495_p(masterBlockPos).func_177229_b((IProperty)FACING), masterBlockPos).get(i);
                if (i == 0) {
                    x = pos.func_177958_n();
                    y = pos.func_177956_o();
                    z = pos.func_177952_p();
                }
                if ((double)pos.func_177958_n() > x) {
                    x = pos.func_177958_n();
                }
                if ((double)pos.func_177956_o() > y) {
                    y = pos.func_177956_o();
                }
                if (!((double)pos.func_177952_p() > z)) continue;
                z = pos.func_177952_p();
            }
            return new BlockPos(x, y, z);
        }
        return null;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityParticleAccelerator();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            Block block = worldIn.func_180495_p(pos.func_177978_c()).func_177230_c();
            Block block1 = worldIn.func_180495_p(pos.func_177968_d()).func_177230_c();
            Block block2 = worldIn.func_180495_p(pos.func_177976_e()).func_177230_c();
            Block block3 = worldIn.func_180495_p(pos.func_177974_f()).func_177230_c();
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && block.func_149730_j(state) && !block1.func_149730_j(state)) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_149730_j(state) && !block.func_149730_j(state)) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_149730_j(state) && !block3.func_149730_j(state)) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_149730_j(state) && !block2.func_149730_j(state)) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public ArrayList<BlockPos> getMultiblockPosList(IBlockAccess world, EnumFacing facing, BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        float degrees = facing == EnumFacing.NORTH ? 0.0f : (facing == EnumFacing.EAST ? -90.0f : (facing == EnumFacing.WEST ? 90.0f : 180.0f));
        Vec3d v1 = minMultiblockSizeVec.func_178785_b(degrees * (float)Math.PI / 180.0f);
        Vec3d v2 = maxMultiblockSizeVec.func_178785_b(degrees * (float)Math.PI / 180.0f);
        v1 = new Vec3d((double)Math.round(v1.field_72450_a), (double)Math.round(v1.field_72448_b), (double)Math.round(v1.field_72449_c));
        v2 = new Vec3d((double)Math.round(v2.field_72450_a), (double)Math.round(v2.field_72448_b), (double)Math.round(v2.field_72449_c));
        int x = (int)Math.min(v1.field_72450_a, v2.field_72450_a);
        while ((double)x <= Math.max(v1.field_72450_a, v2.field_72450_a)) {
            int y = (int)Math.min(v1.field_72448_b, v2.field_72448_b);
            while ((double)y <= Math.max(v1.field_72448_b, v2.field_72448_b)) {
                int z = (int)Math.min(v1.field_72449_c, v2.field_72449_c);
                while ((double)z <= Math.max(v1.field_72449_c, v2.field_72449_c)) {
                    BlockPos bp = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    list.add(bp);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return list;
    }

    public boolean isMultiBlockStructed(IBlockAccess world, BlockPos pos) {
        for (BlockPos p : this.getMultiblockPosList(world, (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING), pos)) {
            if (p.equals((Object)pos) || world.func_180495_p(p).func_177230_c() == SHBlocks.particleAcceleratorPart) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getStateForEntityRender(IBlockState state) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }
}

