/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.client.render;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import lucraft.mods.heroes.speedsterheroes.SpeedsterHeroes;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityBlade;
import lucraft.mods.heroes.speedsterheroes.client.models.ModelTachyonPrototype;
import lucraft.mods.heroes.speedsterheroes.client.render.SpeedTrailRenderer;
import lucraft.mods.heroes.speedsterheroes.config.SHConfig;
import lucraft.mods.heroes.speedsterheroes.entity.EntityBlackFlash;
import lucraft.mods.heroes.speedsterheroes.entity.EntityDimensionBreach;
import lucraft.mods.heroes.speedsterheroes.entity.EntityParticleAcceleratorSit;
import lucraft.mods.heroes.speedsterheroes.entity.EntityRingDummy;
import lucraft.mods.heroes.speedsterheroes.entity.EntitySpeedMirage;
import lucraft.mods.heroes.speedsterheroes.entity.EntityTimeRemnant;
import lucraft.mods.heroes.speedsterheroes.entity.EntityTimeWraith;
import lucraft.mods.heroes.speedsterheroes.items.SHItems;
import lucraft.mods.heroes.speedsterheroes.proxies.SpeedsterHeroesProxy;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.heroes.speedsterheroes.superpower.SpeedforcePlayerHandler;
import lucraft.mods.heroes.speedsterheroes.trailtypes.TrailType;
import lucraft.mods.heroes.speedsterheroes.util.SpeedsterHeroesUtil;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.entity.EntityMountableBlock;
import lucraft.mods.lucraftcore.events.RenderModelEvent;
import lucraft.mods.lucraftcore.events.RenderOnPlayerHandEvent;
import lucraft.mods.lucraftcore.superpower.Superpower;
import lucraft.mods.lucraftcore.superpower.SuperpowerHandler;
import lucraft.mods.lucraftcore.util.IFakePlayerEntity;
import lucraft.mods.lucraftcore.util.IOpenableHelmet;
import lucraft.mods.lucraftcore.util.LucraftCoreClientUtil;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.lwjgl.opengl.GL11;

public class SHRenderer {
    public static final ResourceLocation ICON_TEX = new ResourceLocation("speedsterheroes", "textures/gui/icons.png");
    public static final ModelTachyonPrototype TACHYON_PROTOTYPE_MODEL = new ModelTachyonPrototype();
    public static final ResourceLocation TACHYON_PROTOTYPE_TEX = new ResourceLocation("speedsterheroes", "textures/models/tachyonPrototype.png");
    public static HashMap<EntityLivingBase, Float> traveledBlocksMap = new HashMap();
    public static HashMap<EntityLivingBase, Vec3d> lastPosMap = new HashMap();
    public static HashMap<EntityLivingBase, LinkedList<EntitySpeedMirage>> trailDataMap = new HashMap();

    public static void drawIcon(Minecraft mc, Gui gui, int x, int y, int row, int column) {
        mc.field_71446_o.func_110577_a(ICON_TEX);
        gui.func_73729_b(x, y, column * 16, row * 16, 16, 16);
    }

    public static void drawIcon(Minecraft mc, int x, int y, int row, int column) {
        SHRenderer.drawIcon(mc, (Gui)mc.field_71456_v, x, y, row, column);
    }

    @SubscribeEvent
    public void onLeave(PlayerEvent.PlayerLoggedOutEvent e) {
        if (SHRenderer.canHaveTrail((Entity)e.player)) {
            traveledBlocksMap.remove(e.player);
            lastPosMap.remove(e.player);
            trailDataMap.remove(e.player);
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (SHRenderer.canHaveTrail((Entity)e.player)) {
            traveledBlocksMap.put((EntityLivingBase)e.player, Float.valueOf(0.0f));
            lastPosMap.put((EntityLivingBase)e.player, e.player.func_174791_d());
            trailDataMap.put((EntityLivingBase)e.player, new LinkedList());
        }
    }

    @SubscribeEvent
    public void onLogin(EntityEvent.EntityConstructing e) {
        if (e.getEntity() instanceof EntityTimeRemnant) {
            traveledBlocksMap.put((EntityLivingBase)e.getEntity(), Float.valueOf(0.0f));
            lastPosMap.put((EntityLivingBase)e.getEntity(), e.getEntity().func_174791_d());
            trailDataMap.put((EntityLivingBase)e.getEntity(), new LinkedList());
        }
    }

    @SubscribeEvent
    public void onDimChange(PlayerEvent.PlayerChangedDimensionEvent e) {
        for (EntitySpeedMirage esm : trailDataMap.get(e.player)) {
            esm.func_70106_y();
        }
        trailDataMap.put((EntityLivingBase)e.player, new LinkedList());
    }

    @SubscribeEvent
    public void playerTick(LivingEvent.LivingUpdateEvent e) {
        if (SHConfig.trailRender && SHRenderer.canHaveTrail((Entity)e.getEntityLiving()) && e.getEntityLiving().field_70170_p.field_72995_K) {
            if (e.getEntity() instanceof EntityPlayer && !SHRenderer.canSeePlayer((EntityPlayer)e.getEntity(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                return;
            }
            if (SHRenderer.isInSpeed(e.getEntityLiving())) {
                if (SHRenderer.isPlayerMovingClientSide(e.getEntityLiving())) {
                    EntityLivingBase player = e.getEntityLiving();
                    if (!traveledBlocksMap.containsKey(player)) {
                        traveledBlocksMap.put(player, Float.valueOf(0.0f));
                    }
                    if (!lastPosMap.containsKey(player)) {
                        lastPosMap.put(player, player.func_174791_d());
                    }
                    if (!trailDataMap.containsKey(player)) {
                        trailDataMap.put(player, new LinkedList());
                    }
                    Vec3d lastPos = lastPosMap.get(player);
                    float distancedWalked = traveledBlocksMap.get(player).floatValue() + (float)player.func_70011_f(lastPos.field_72450_a, lastPos.field_72448_b, lastPos.field_72449_c);
                    if (distancedWalked >= player.field_70130_N + player.field_70130_N / 10.0f) {
                        EntitySpeedMirage esm = new EntitySpeedMirage(player.field_70170_p, player, player.func_174791_d(), false);
                        player.field_70170_p.func_72838_d((Entity)esm);
                        this.addSpeedMirageToList(player, esm);
                        distancedWalked = 0.0f;
                    }
                    traveledBlocksMap.put(player, Float.valueOf(distancedWalked));
                }
                lastPosMap.put(e.getEntityLiving(), e.getEntityLiving().func_174791_d());
            }
        }
    }

    public static boolean isPlayerMovingClientSide(EntityLivingBase entity) {
        return SHRenderer.areVec3dEqual(entity.func_174791_d(), lastPosMap.get(entity));
    }

    public static boolean areVec3dEqual(Vec3d vec1, Vec3d vec2) {
        if (vec1 == null || vec2 == null) {
            return false;
        }
        return vec1.field_72450_a != vec2.field_72450_a || vec1.field_72448_b != vec2.field_72448_b || vec1.field_72449_c != vec2.field_72449_c;
    }

    public void addSpeedMirageToList(EntityLivingBase player, EntitySpeedMirage e) {
        LinkedList<EntitySpeedMirage> list = trailDataMap.get(player);
        if (list.size() >= 10) {
            list.remove(0);
            list.add(e);
        } else {
            list.add(e);
        }
        trailDataMap.put(player, list);
    }

    public static LinkedList<EntitySpeedMirage> getSpeedMiragesFromPlayer(EntityLivingBase player) {
        if (trailDataMap.get(player) == null) {
            trailDataMap.put(player, new LinkedList());
        }
        return trailDataMap.get(player);
    }

    @SubscribeEvent
    public void renderModel(RenderModelEvent e) {
        Object entity;
        EntityPlayer player;
        if (e.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)e.getEntity()).func_184187_bx() != null && player.func_184187_bx() instanceof EntityParticleAcceleratorSit && ((EntityParticleAcceleratorSit)player.func_184187_bx()).info.equalsIgnoreCase("particleAccelerator")) {
            EntityParticleAcceleratorSit sit = (EntityParticleAcceleratorSit)player.func_184187_bx();
            float f = 0.0f;
            if (sit.facing == EnumFacing.EAST) {
                f = 90.0f;
            } else if (sit.facing == EnumFacing.NORTH) {
                f = 180.0f;
            } else if (sit.facing == EnumFacing.WEST) {
                f = -90.0f;
            }
            GlStateManager.func_179114_b((float)(-player.field_70761_aq - f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (SpeedsterHeroesUtil.isEntityAvailableForSpeedforce((Entity)e.getEntityLiving()) && SuperpowerHandler.getSpecificSuperpowerPlayerHandler((EntityPlayer)((EntityPlayer)e.getEntityLiving()), SpeedforcePlayerHandler.class) != null && ((SpeedforcePlayerHandler)SuperpowerHandler.getSpecificSuperpowerPlayerHandler((EntityPlayer)((EntityPlayer)e.getEntityLiving()), SpeedforcePlayerHandler.class)).isWallRunning) {
            GlStateManager.func_179109_b((float)0.0f, (float)(-e.getEntity().field_70131_O), (float)0.0f);
            GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (e.getEntity() instanceof EntityTimeWraith) {
            entity = (EntityTimeWraith)e.getEntityLiving();
            double d = Math.min(Math.sqrt((entity.field_70169_q - entity.field_70165_t) * (entity.field_70169_q - entity.field_70165_t) + (entity.field_70166_s - entity.field_70161_v) * (entity.field_70166_s - entity.field_70161_v)), 1.0) * (double)(entity.field_70701_bs == 0.0f ? 1.0f : entity.field_70701_bs);
            GL11.glRotated((double)(80.0 * d), (double)1.0, (double)0.0, (double)0.0);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(30.0 * d * 4.0 / 100.0));
            GlStateManager.func_179137_b((double)0.0, (double)(Math.cos(((float)entity.field_70173_aa + LucraftCoreClientUtil.renderTick) * 0.1f) / 10.0), (double)0.0);
            if (entity.getDespawnTimer() > 0) {
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glAlphaFunc((int)516, (float)0.003921569f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - ((float)entity.getDespawnTimer() + LucraftCoreClientUtil.renderTick) / 100.0f));
            }
        } else if (e.getEntity() instanceof EntityBlackFlash) {
            entity = (EntityBlackFlash)e.getEntityLiving();
            if (entity.getDespawnTimer() > 0) {
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glAlphaFunc((int)516, (float)0.003921569f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - ((float)entity.getDespawnTimer() + LucraftCoreClientUtil.renderTick) / 100.0f));
            }
        } else if (e.getEntity() instanceof EntityRingDummy) {
            entity = (EntityRingDummy)e.getEntity();
            double d = Math.min(Math.sqrt((entity.field_70169_q - entity.field_70165_t) * (entity.field_70169_q - entity.field_70165_t) + (entity.field_70166_s - entity.field_70161_v) * (entity.field_70166_s - entity.field_70161_v)), 1.0) * (double)(entity.field_70701_bs == 0.0f ? 1.0f : entity.field_70701_bs);
            float scale = MathHelper.func_76131_a((float)(((float)entity.field_70173_aa + LucraftCoreClientUtil.renderTick) / 20.0f), (float)0.0f, (float)0.9f);
            GL11.glRotated((double)(80.0 * d), (double)1.0, (double)0.0, (double)0.0);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179137_b((double)0.0, (double)((double)-0.2f + Math.cos(((float)entity.field_70173_aa + LucraftCoreClientUtil.renderTick) * 0.1f) / 10.0), (double)0.0);
        }
    }

    @SubscribeEvent
    public void setupModel(RenderModelEvent.SetRotationAngels e) {
        if (SpeedsterHeroesUtil.isEntityAvailableForSpeedforce(e.getEntity())) {
            EntityPlayer player = (EntityPlayer)e.getEntity();
            SpeedforcePlayerHandler data = (SpeedforcePlayerHandler)SuperpowerHandler.getSpecificSuperpowerPlayerHandler((EntityPlayer)player, SpeedforcePlayerHandler.class);
            if (data != null && data.isInSpeed && (e.getEntity().field_70122_E || player.field_70170_p.func_180495_p(player.func_180425_c().func_177982_a(0, -1, 0)).func_177230_c() instanceof BlockLiquid)) {
                e.limbSwing *= (float)data.speedLevel;
            }
            if (data != null && data.isWallRunning) {
                e.limbSwing = (float)player.field_70163_u;
                e.limbSwingAmount = MathHelper.func_76134_b((float)((float)player.field_70163_u * (float)data.speedLevel * 4.0f));
            }
            if (player.func_184187_bx() != null && player.func_184187_bx() instanceof EntityMountableBlock && ((EntityMountableBlock)player.func_184187_bx()).info.equalsIgnoreCase("particleAccelerator")) {
                e.setCanceled(true);
                ModelBiped model = e.model;
                model.field_178724_i.field_78808_h = -2.3f;
                model.field_178723_h.field_78808_h = 2.3f;
                if (model instanceof ModelPlayer) {
                    ModelPlayer playerModel = (ModelPlayer)model;
                    playerModel.field_178734_a.field_78808_h = -2.3f;
                    playerModel.field_178732_b.field_78808_h = 2.3f;
                }
            }
        } else if (e.getEntity() instanceof EntityTimeWraith) {
            e.limbSwing = 0.0f;
            e.limbSwingAmount = 0.0f;
        } else if (e.getEntity() instanceof EntityRingDummy) {
            e.setCanceled(true);
            EntityRingDummy entity = (EntityRingDummy)e.getEntity();
            float d = (float)(Math.min(Math.sqrt((entity.field_70169_q - entity.field_70165_t) * (entity.field_70169_q - entity.field_70165_t) + (entity.field_70166_s - entity.field_70161_v) * (entity.field_70166_s - entity.field_70161_v)), 1.0) * (double)(entity.field_70701_bs == 0.0f ? 1.0f : entity.field_70701_bs));
            e.model.field_178723_h.field_78795_f = 0.7f * d;
            e.model.field_178723_h.field_78808_h = 0.2f * d;
            e.model.field_178724_i.field_78795_f = 0.7f * d;
            e.model.field_178724_i.field_78808_h = -0.2f * d;
            e.model.field_178721_j.field_78795_f = 0.7f * d;
            e.model.field_178721_j.field_78808_h = 0.2f * d;
            e.model.field_178722_k.field_78795_f = 0.7f * d;
            e.model.field_178722_k.field_78808_h = -0.2f * d;
        }
    }

    @SubscribeEvent
    public void renderEntityPre(RenderLivingEvent.Pre<EntityLivingBase> e) {
        if (e.getEntity() instanceof EntityPlayer) {
            if (!SHRenderer.canSeePlayer((EntityPlayer)e.getEntity(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                e.setCanceled(true);
            }
            if (e.getEntity().func_184187_bx() instanceof EntityDimensionBreach) {
                EntityDimensionBreach breach = (EntityDimensionBreach)e.getEntity().func_184187_bx();
                if (breach.type == EntityDimensionBreach.BreachActionTypes.PORTAL) {
                    e.setCanceled(true);
                }
            }
        }
        if (e.getEntity() instanceof EntitySpeedMirage) {
            EntitySpeedMirage entity = (EntitySpeedMirage)e.getEntity();
            SpeedTrailRenderer renderer = entity.trail.getSpeedTrailRenderer();
            if (!renderer.shouldRenderSpeedMirage(entity, entity.trail)) {
                e.setCanceled(true);
                return;
            }
            renderer.preRenderSpeedMirage(entity, entity.trail);
        }
        if (e.getEntity().func_70644_a(SpeedsterHeroesProxy.speedShock)) {
            TrailType.renderer_lightnings.renderFlickering(e.getEntity(), TrailType.lightnings_orange);
        }
    }

    @SubscribeEvent
    public void renderEntityPost(RenderLivingEvent.Post<EntityLivingBase> e) {
        if (SHRenderer.canHaveTrail((Entity)e.getEntity()) && SHRenderer.isInSpeed(e.getEntity())) {
            EntityLivingBase player = e.getEntity();
            SpeedsterType type = SpeedsterHeroesUtil.getSpeedsterType(player);
            TrailType trail = null;
            trail = type == null ? (SpeedsterHeroesUtil.isVelocity9Active(player) ? TrailType.lightnings_orange : (player instanceof EntityPlayer ? (SuperpowerHandler.hasSuperpower((EntityPlayer)((EntityPlayer)player)) ? ((SpeedforcePlayerHandler)SuperpowerHandler.getSpecificSuperpowerPlayerHandler((EntityPlayer)((EntityPlayer)player), SpeedforcePlayerHandler.class)).customTrailType : TrailType.normal) : TrailType.normal)) : (type.getTrailType() != null ? type.getTrailType() : (player instanceof EntityPlayer && SuperpowerHandler.hasSuperpower((EntityPlayer)((EntityPlayer)player)) ? ((SpeedforcePlayerHandler)SuperpowerHandler.getSpecificSuperpowerPlayerHandler((EntityPlayer)((EntityPlayer)player), SpeedforcePlayerHandler.class)).customTrailType : TrailType.normal));
            trail.getSpeedTrailRenderer().renderTrail(player, trail);
            if (SHConfig.flickerRender) {
                if (SHRenderer.isPlayerMovingClientSide(player) && (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0 || player != Minecraft.func_71410_x().field_71439_g)) {
                    trail.getSpeedTrailRenderer().renderFlickering(player, trail);
                }
                if ((type != null && type.doesFlicker() || SpeedsterHeroesUtil.isVelocity9Active(player)) && (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0 || player != Minecraft.func_71410_x().field_71439_g)) {
                    trail.getSpeedTrailRenderer().renderFlickering(player, trail);
                }
            }
        }
    }

    @SubscribeEvent
    public void renderNameTag(RenderLivingEvent.Specials.Pre e) {
        EntityLivingBase player;
        SpeedsterType type;
        if (SHRenderer.canHaveTrail((Entity)e.getEntity()) && (type = SpeedsterHeroesUtil.getSpeedsterType(player = e.getEntity())) != null && SpeedsterHeroesUtil.hasHelmetOn(player)) {
            boolean maskOpen;
            boolean bl = maskOpen = player.func_184582_a(EntityEquipmentSlot.HEAD) != null && player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof IOpenableHelmet && ((IOpenableHelmet)player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b()).isHelmetOpen((Entity)player, player.func_184582_a(EntityEquipmentSlot.HEAD));
            if (player.func_184582_a(EntityEquipmentSlot.HEAD).func_77942_o() && type.shouldHideNameTag(player, maskOpen)) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRenderOnHand(RenderOnPlayerHandEvent e) {
        AbilityBlade blade = (AbilityBlade)Ability.getAbilityFromClass((List)Ability.getCurrentPlayerAbilities((EntityPlayer)e.getEntityPlayer()), AbilityBlade.class);
        if (blade != null && blade.isUnlocked() && blade.isEnabled()) {
            GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            boolean flag = e.getSide() == EnumHandSide.LEFT;
            ItemCameraTransforms.TransformType transform = flag ? ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND : ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            GlStateManager.func_179109_b((float)((float)(flag ? -1 : 1) / 16.0f), (float)0.125f, (float)-0.625f);
            Minecraft.func_71410_x().func_175597_ag().func_187462_a(e.getEntityLiving(), new ItemStack(SHItems.savitarBlade), transform, flag);
        }
    }

    public static boolean canHaveTrail(Entity entity) {
        return entity != null && entity instanceof EntityLivingBase && (entity instanceof EntityPlayer || entity instanceof EntityTimeRemnant || entity instanceof EntityBlackFlash) && !(entity instanceof IFakePlayerEntity);
    }

    public static boolean isInSpeed(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return entity.func_70644_a(SpeedsterHeroesProxy.velocity9) ? true : SuperpowerHandler.hasSuperpower((EntityPlayer)((EntityPlayer)entity), (Superpower)SpeedsterHeroes.speedforce) && ((SpeedforcePlayerHandler)SuperpowerHandler.getSpecificSuperpowerPlayerHandler((EntityPlayer)((EntityPlayer)entity), SpeedforcePlayerHandler.class)).isInSpeed;
        }
        return entity instanceof EntityTimeRemnant || entity instanceof EntityBlackFlash;
    }

    public static boolean canSeePlayer(EntityPlayer seenPlayer, EntityPlayer seeingPlayer) {
        return true;
    }
}

