/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.items;

import java.util.List;
import lucraft.mods.heroes.speedsterheroes.entity.EntityRingDummy;
import lucraft.mods.heroes.speedsterheroes.items.ItemSpeedsterArmor;
import lucraft.mods.heroes.speedsterheroes.proxies.SpeedsterHeroesProxy;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.heroes.speedsterheroes.util.SHAchievements;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.extendedinventory.IItemExtendedInventory;
import lucraft.mods.lucraftcore.extendedinventory.IPlayerExtendedInventory;
import lucraft.mods.lucraftcore.items.ItemBase;
import lucraft.mods.lucraftcore.util.LCModelEntry;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemRing
extends ItemBase
implements IItemExtendedInventory {
    public ItemRing() {
        super("ring");
        LucraftCore.proxy.registerModel((Item)this, new LCModelEntry(0, this.name));
        this.func_77637_a(SpeedsterHeroesProxy.tabSpeedster);
        this.func_77625_d(1);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        stack.func_77982_d(new NBTTagCompound());
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return this.spawnSuitEntity(playerIn, itemStackIn);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        SpeedsterType type = SpeedsterType.getSpeedsterTypeFromName(stack.func_77978_p().func_74779_i("SpeedsterType"));
        if (type != null) {
            tooltip.add(TextFormatting.BOLD + type.getDisplayName());
            if (type.hasExtraDescription(stack, playerIn)) {
                tooltip.addAll(type.getExtraDescription(stack, playerIn));
            }
        }
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (SpeedsterType type : SpeedsterType.speedsterTypes) {
            if (!type.showInCreativeTab()) continue;
            subItems.add(ItemRing.setArmorIn(new ItemStack(itemIn), new ItemStack(type.getHelmet()), new ItemStack(type.getChestplate()), new ItemStack(type.getLegs()), new ItemStack(type.getBoots())));
        }
    }

    public static ItemStack setArmorIn(ItemStack ring, ItemStack helmet, ItemStack chestplate, ItemStack legs, ItemStack boots) {
        if (!ring.func_77942_o()) {
            ring.func_77982_d(new NBTTagCompound());
        }
        ItemStack[] armor = new ItemStack[]{helmet, chestplate, legs, boots};
        NBTTagList nbtList = new NBTTagList();
        SpeedsterType type = null;
        for (int i = 0; i < 4; ++i) {
            ItemStack s = armor[i];
            if (s == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("Slot", i);
            s.func_77955_b(nbt);
            nbtList.func_74742_a((NBTBase)nbt);
            if (!(s.func_77973_b() instanceof ItemSpeedsterArmor)) continue;
            type = ((ItemSpeedsterArmor)s.func_77973_b()).getSpeedsterType();
        }
        ring.func_77978_p().func_74782_a("ItemInventory", (NBTBase)nbtList);
        ring.func_77978_p().func_74778_a("SpeedsterType", type.getUnlocalizedName());
        return ring;
    }

    public static ItemStack[] getArmorInRing(ItemStack ring) {
        if (!ring.func_77942_o()) {
            ring.func_77982_d(new NBTTagCompound());
        }
        NBTTagList items = ring.func_77978_p().func_150295_c("ItemInventory", 10);
        ItemStack[] armor = new ItemStack[4];
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot < 0 || slot >= 4) continue;
            armor[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        return armor;
    }

    public IItemExtendedInventory.ExtendedInventoryItemType getEIItemType(ItemStack stack) {
        return IItemExtendedInventory.ExtendedInventoryItemType.WRIST;
    }

    public void onPressedButton(ItemStack itemstack, EntityPlayer player) {
        this.spawnSuitEntity(player, itemstack);
        if (itemstack.field_77994_a == 0) {
            ((IPlayerExtendedInventory)player.getCapability(LucraftCore.EXTENDED_INVENTORY, null)).getInventory().func_70299_a(2, null);
        }
    }

    public ActionResult<ItemStack> spawnSuitEntity(EntityPlayer playerIn, ItemStack stack) {
        World worldIn = playerIn.field_70170_p;
        ItemStack[] armor = ItemRing.getArmorInRing(stack);
        boolean hasStuffInIt = false;
        for (ItemStack stacks : armor) {
            if (stacks == null) continue;
            hasStuffInIt = true;
        }
        if (hasStuffInIt) {
            EntityRingDummy dummy = new EntityRingDummy(worldIn);
            Vec3d look = playerIn.func_70040_Z();
            dummy.func_70107_b(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v);
            dummy.dirX = (float)look.field_72450_a;
            dummy.dirZ = (float)look.field_72449_c;
            dummy.field_70125_A = playerIn.field_70125_A;
            dummy.field_70177_z = playerIn.field_70177_z;
            dummy.func_184201_a(EntityEquipmentSlot.HEAD, armor[0]);
            dummy.func_184201_a(EntityEquipmentSlot.CHEST, armor[1]);
            dummy.func_184201_a(EntityEquipmentSlot.LEGS, armor[2]);
            dummy.func_184201_a(EntityEquipmentSlot.FEET, armor[3]);
            if (!worldIn.field_72995_K) {
                worldIn.func_72838_d((Entity)dummy);
            }
            --stack.field_77994_a;
            playerIn.func_71029_a((StatBase)SHAchievements.suitRing);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }
}

