/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.items;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.IAutoSpeedsterRecipe;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.IAutoSpeedsterRecipeAdvanced;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.lucraftcore.suitset.ItemSuitSetArmor;
import lucraft.mods.lucraftcore.suitset.SuitSet;
import lucraft.mods.lucraftcore.util.IUpgradableArmor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemSpeedsterArmor
extends ItemSuitSetArmor
implements ISpecialArmor,
IUpgradableArmor {
    public static ArrayList<ItemSpeedsterArmor> armorToCraft = new ArrayList();

    public ItemSpeedsterArmor(SpeedsterType type, EntityEquipmentSlot armorSlot) {
        super((SuitSet)type, armorSlot);
        if (type instanceof IAutoSpeedsterRecipe || type instanceof IAutoSpeedsterRecipeAdvanced) {
            armorToCraft.add(this);
        }
        if (armorSlot == EntityEquipmentSlot.HEAD) {
            type.helmet = new ItemStack((Item)this);
        } else if (armorSlot == EntityEquipmentSlot.CHEST) {
            type.chestplate = new ItemStack((Item)this);
        } else if (armorSlot == EntityEquipmentSlot.LEGS) {
            type.legs = new ItemStack((Item)this);
        } else if (armorSlot == EntityEquipmentSlot.FEET) {
            type.boots = new ItemStack((Item)this);
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return this.getSpeedsterType().getAttributeModifiers(slot, stack, (Multimap<String, AttributeModifier>)super.getAttributeModifiers(slot, stack));
    }

    public String func_77653_i(ItemStack stack) {
        return ("" + I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name"))).trim();
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public SpeedsterType getSpeedsterType() {
        return (SpeedsterType)this.getSuitSet();
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        EntityEquipmentSlot s = slot == 0 ? EntityEquipmentSlot.HEAD : (slot == 1 ? EntityEquipmentSlot.CHEST : (slot == 2 ? EntityEquipmentSlot.LEGS : EntityEquipmentSlot.FEET));
        float reduceAmount = ItemArmor.ArmorMaterial.CHAIN.func_78044_b(s) + (armor.func_77942_o() ? armor.func_77978_p().func_74762_e("plateAmount") * 2 : 0);
        return new ISpecialArmor.ArmorProperties(0, (double)reduceAmount / 25.0, Integer.MAX_VALUE);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)(this.getProperties((EntityLivingBase)player, (ItemStack)armor, null, (double)0.0, (int)slot).AbsorbRatio * 25.0);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        slot = 3 - slot;
        float d = (float)damage / 4.0f;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((d /= (float)(stack.func_77978_p().func_74762_e("plateAmount") + 1)) < 1.0f) {
            d = 1.0f;
        }
        stack.func_77972_a((int)d, entity);
        if (stack.field_77994_a == 0) {
            stack = null;
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.getSpeedsterType().getIsRepairable(toRepair, repair);
    }
}

