/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.speedstertypes;

import java.util.Arrays;
import java.util.List;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityDimensionBreach;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityLightningThrowing;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityPhasing;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilitySpeedforceVision;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.heroes.speedsterheroes.trailtypes.TrailType;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.items.LCItems;
import lucraft.mods.lucraftcore.util.LucraftKeys;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;

public class SpeedsterTypeBlackFlash
extends SpeedsterType {
    protected SpeedsterTypeBlackFlash() {
        super("blackFlash", TrailType.lightnings_red);
        this.setSpeedLevelRenderData(9, 21);
    }

    public List<String> getExtraDescription(ItemStack stack, EntityPlayer player) {
        return Arrays.asList("CW Version");
    }

    @Override
    public int getExtraSpeedLevel(SpeedsterType type, EntityPlayer player) {
        return 10;
    }

    @Override
    public ItemStack getRepairItem(ItemStack toRepair) {
        return LCItems.getColoredTriPolymer((EnumDyeColor)EnumDyeColor.BLACK, (int)1);
    }

    public boolean showInCreativeTab() {
        return true;
    }

    @Override
    public boolean hasSymbol() {
        return false;
    }

    @Override
    public List<Ability> addDefaultAbilities(EntityPlayer player, List<Ability> list) {
        list.add(new AbilityPhasing(player).setUnlocked(true).setRequiredLevel(15));
        list.add(new AbilityLightningThrowing(player).setUnlocked(true).setRequiredLevel(20));
        list.add(new AbilityDimensionBreach(player).setUnlocked(true).setRequiredLevel(25));
        list.add(new AbilitySpeedforceVision(player).setUnlocked(true));
        return super.addDefaultAbilities(player, list);
    }

    @Override
    public Ability getSuitAbilityForKey(LucraftKeys key, List<Ability> list) {
        if (key == LucraftKeys.ARMOR_1) {
            return Ability.getAbilityFromClass(list, AbilityPhasing.class);
        }
        if (key == LucraftKeys.ARMOR_2) {
            return Ability.getAbilityFromClass(list, AbilitySpeedforceVision.class);
        }
        if (key == LucraftKeys.ARMOR_3) {
            return Ability.getAbilityFromClass(list, AbilityDimensionBreach.class);
        }
        return super.getSuitAbilityForKey(key, list);
    }
}

