/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.speedstertypes;

import java.util.Arrays;
import java.util.List;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityDimensionBreach;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityLightningThrowing;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityPhasing;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilitySpeedforceJump;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityTimeRemnant;
import lucraft.mods.heroes.speedsterheroes.items.SHItems;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.IAutoSpeedsterRecipe;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.heroes.speedsterheroes.trailtypes.TrailType;
import lucraft.mods.heroes.speedsterheroes.util.SpeedsterHeroesUtil;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.items.LCItems;
import lucraft.mods.lucraftcore.util.LucraftKeys;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;

public class SpeedsterTypeFlay
extends SpeedsterType
implements IAutoSpeedsterRecipe {
    protected SpeedsterTypeFlay() {
        super("flay", TrailType.lightnings_orange);
    }

    public List<String> getExtraDescription(ItemStack stack, EntityPlayer player) {
        return Arrays.asList("Custom Character");
    }

    @Override
    public int getExtraSpeedLevel(SpeedsterType type, EntityPlayer player) {
        return 6;
    }

    public boolean hasArmorOn(EntityLivingBase player) {
        return player.func_184582_a(EntityEquipmentSlot.CHEST) != null && player.func_184582_a(EntityEquipmentSlot.LEGS) != null && player.func_184582_a(EntityEquipmentSlot.FEET) != null && player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == SHItems.flayChestplate && player.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == SHItems.flayLegs && player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == SHItems.flayBoots;
    }

    public boolean showInCreativeTab() {
        return false;
    }

    @Override
    public boolean shouldHideNameTag(EntityLivingBase player, boolean hasMaskOpen) {
        return false;
    }

    @Override
    public boolean canBeCraftedDescription(ItemStack stack) {
        return false;
    }

    @Override
    public ItemStack getFirstItemStack(ItemStack armor, EntityEquipmentSlot armorSlot) {
        return SHItems.getSymbolFromSpeedsterType(this, 1);
    }

    @Override
    public ItemStack getSecondItemStack(ItemStack armor, EntityEquipmentSlot armorSlot) {
        return LCItems.getColoredTriPolymer((EnumDyeColor)EnumDyeColor.RED, (int)SpeedsterHeroesUtil.getRecommendedAmountForArmorSlotWithAddition(armorSlot, this));
    }

    @Override
    public ItemStack getThirdItemStack(ItemStack armor, EntityEquipmentSlot armorSlot) {
        return LCItems.getColoredTriPolymer((EnumDyeColor)EnumDyeColor.BLACK, (int)SpeedsterHeroesUtil.getRecommendedAmountForArmorSlotWithAddition(armorSlot, this));
    }

    @Override
    public ItemStack getRepairItem(ItemStack toRepair) {
        if (toRepair.func_77973_b() == this.getLegs()) {
            return LCItems.getColoredTriPolymer((EnumDyeColor)EnumDyeColor.BLACK, (int)1);
        }
        return LCItems.getColoredTriPolymer((EnumDyeColor)EnumDyeColor.RED, (int)1);
    }

    @Override
    public List<Ability> addDefaultAbilities(EntityPlayer player, List<Ability> list) {
        list.add(new AbilityPhasing(player).setUnlocked(true).setRequiredLevel(15));
        list.add(new AbilityLightningThrowing(player).setUnlocked(true).setRequiredLevel(20));
        list.add(new AbilityTimeRemnant(player).setUnlocked(true).setRequiredLevel(25));
        list.add(new AbilityDimensionBreach(player).setUnlocked(true).setRequiredLevel(25));
        list.add(new AbilitySpeedforceJump(player).setUnlocked(true));
        return super.addDefaultAbilities(player, list);
    }

    @Override
    public Ability getSuitAbilityForKey(LucraftKeys key, List<Ability> list) {
        if (key == LucraftKeys.ARMOR_1) {
            return Ability.getAbilityFromClass(list, AbilityPhasing.class);
        }
        if (key == LucraftKeys.ARMOR_2) {
            return Ability.getAbilityFromClass(list, AbilityTimeRemnant.class);
        }
        if (key == LucraftKeys.ARMOR_3) {
            return Ability.getAbilityFromClass(list, AbilityDimensionBreach.class);
        }
        return super.getSuitAbilityForKey(key, list);
    }
}

