/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.superpower;

import java.util.ArrayList;
import java.util.List;
import lucraft.mods.heroes.speedsterheroes.SpeedsterHeroes;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityAccelerate;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityDecelerate;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilitySlowMotion;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilitySuperSpeed;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityWallRunning;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityWaterRunning;
import lucraft.mods.heroes.speedsterheroes.config.SHConfig;
import lucraft.mods.heroes.speedsterheroes.items.SHItems;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.heroes.speedsterheroes.trailtypes.TrailTypeCustom;
import lucraft.mods.heroes.speedsterheroes.util.SHAchievements;
import lucraft.mods.heroes.speedsterheroes.util.SpeedsterAttributeModifiers;
import lucraft.mods.heroes.speedsterheroes.util.SpeedsterHeroesUtil;
import lucraft.mods.heroes.speedsterheroes.util.TeleportDestination;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.attributes.LCAttributes;
import lucraft.mods.lucraftcore.superpower.SuperpowerPlayerHandler;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import lucraft.mods.lucraftcore.util.LucraftKeys;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SpeedforcePlayerHandler
extends SuperpowerPlayerHandler {
    public boolean isInSpeed;
    public int speedLevel;
    public int extraSpeedLevels;
    public boolean isWallRunning;
    public TrailTypeCustom customTrailType;
    public List<TeleportDestination> waypoints = new ArrayList<TeleportDestination>();
    public int chosenWaypointIndex = -1;
    public boolean isMoving = false;

    public SpeedforcePlayerHandler(EntityPlayer player) {
        super(player, SpeedsterHeroes.speedforce);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound compound = super.writeToNBT(nbt);
        compound.func_74757_a("isInSpeed", this.isInSpeed);
        compound.func_74768_a("speedLevel", this.speedLevel);
        compound.func_74768_a("extraSpeedLevels", this.extraSpeedLevels);
        compound.func_74757_a("isWallRunning", this.isWallRunning);
        compound.func_74768_a("ChosenWaypointIndex", this.chosenWaypointIndex);
        NBTTagCompound trailNBT = new NBTTagCompound();
        compound.func_74782_a("customTrailType", (NBTBase)trailNBT);
        NBTTagList tagList = new NBTTagList();
        for (TeleportDestination teleports : this.waypoints) {
            tagList.func_74742_a((NBTBase)teleports.serializeNBT());
        }
        compound.func_74782_a("Waypoints", (NBTBase)tagList);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.isInSpeed = compound.func_74767_n("isInSpeed");
        this.speedLevel = compound.func_74762_e("speedLevel");
        this.extraSpeedLevels = compound.func_74762_e("extraSpeedLevels");
        this.isWallRunning = compound.func_74767_n("isWallRunning");
        this.chosenWaypointIndex = compound.func_74762_e("ChosenWaypointIndex");
        this.customTrailType = new TrailTypeCustom(this.getStyleNBTTag(), this.player);
        this.waypoints = new ArrayList<TeleportDestination>();
        NBTTagList tagList = compound.func_150295_c("Waypoints", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            TeleportDestination teleports = new TeleportDestination("", BlockPos.field_177992_a, 0);
            teleports.deserializeNBT(tagList.func_150305_b(i));
            this.waypoints.add(teleports);
        }
    }

    public void onApplyPower() {
        this.player.func_71029_a((StatBase)SHAchievements.becomeSpeedster);
    }

    public void onRemovePower() {
        this.resetSpeed();
    }

    public void setStyleNBTTag(NBTTagCompound tag) {
        super.setStyleNBTTag(tag);
        this.customTrailType = new TrailTypeCustom(this.getStyleNBTTag(), this.player);
    }

    public void onUpdate(TickEvent.Phase phase) {
        super.onUpdate(phase);
        if (phase == TickEvent.Phase.END) {
            return;
        }
        if (this.isInSpeed) {
            int maxSpeedLevels;
            boolean isMoving;
            SpeedsterType type = SpeedsterHeroesUtil.getSpeedsterType((EntityLivingBase)this.player);
            this.isMoving = isMoving = SpeedsterHeroesUtil.isMoving((EntityLivingBase)this.player);
            boolean isSprinting = this.player.func_70051_ag();
            float walkedDifference = this.player.field_70140_Q / 0.6f - this.player.field_70141_P / 0.6f;
            this.addXP((int)(type == SpeedsterType.starLabsTraining ? 2.0f * walkedDifference : walkedDifference), false);
            if (isMoving) {
                int progress;
                NBTTagCompound nbt;
                ItemStack stack;
                if (this.player.func_184586_b(EnumHand.MAIN_HAND) != null && this.player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == SHItems.tachyonCharge) {
                    stack = this.player.func_184586_b(EnumHand.MAIN_HAND);
                    nbt = stack.func_77978_p();
                    progress = nbt.func_74762_e("progress");
                    nbt.func_74768_a("progress", (progress = (int)((float)progress + walkedDifference)) > 5000 ? 5000 : progress);
                    stack.func_77982_d(nbt);
                }
                if (this.player.func_184586_b(EnumHand.OFF_HAND) != null && this.player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() == SHItems.tachyonCharge) {
                    stack = this.player.func_184586_b(EnumHand.OFF_HAND);
                    nbt = stack.func_77978_p();
                    progress = nbt.func_74762_e("progress");
                    nbt.func_74768_a("progress", (progress = (int)((float)progress + walkedDifference)) > 5000 ? 5000 : progress);
                    stack.func_77982_d(nbt);
                }
            }
            if (((AbilityWallRunning)Ability.getAbilityFromClass((List)this.getAbilities(), AbilityWallRunning.class)).isUnlocked()) {
                if (this.player.field_70123_F && !this.player.field_70124_G) {
                    this.player.field_70181_x = MathHelper.func_76131_a((float)((float)this.speedLevel / 6.0f), (float)0.5f, (float)2.0f);
                    this.isWallRunning = true;
                } else if (this.isWallRunning) {
                    this.isWallRunning = false;
                    this.player.field_70181_x = 0.2f;
                }
            }
            if (isMoving && ((AbilityWaterRunning)Ability.getAbilityFromClass((List)this.getAbilities(), AbilityWaterRunning.class)).isUnlocked() && this.speedLevel >= 5 && this.player.field_70170_p.func_180495_p(this.player.func_180425_c().func_177982_a(0, -1, 0)).func_177230_c() instanceof BlockLiquid && isSprinting) {
                this.player.field_70163_u -= this.player.field_70181_x;
                this.player.field_70181_x = 0.0;
                this.player.field_70143_R = 0.0f;
                this.player.field_70122_E = true;
            }
            if (SHConfig.frictionBurn && this.player.field_70122_E && this.speedLevel > 3 && walkedDifference > 1.6f && type == null && !this.player.field_71075_bZ.field_75098_d) {
                this.player.func_70015_d(10);
                this.player.func_71029_a((StatBase)SHAchievements.frictionBurn);
            }
            if (this.speedLevel > (maxSpeedLevels = SpeedsterHeroesUtil.getSpeedLevels(this.player))) {
                this.setSpeedLevel(maxSpeedLevels);
                LucraftCoreUtil.sendSuperpowerUpdatePacket((EntityPlayer)this.player);
            }
        } else if (this.isWallRunning) {
            this.isWallRunning = false;
        }
    }

    public Ability getAbilityForKey(LucraftKeys key) {
        if (key == LucraftKeys.SUPERPOWER_2) {
            return Ability.getAbilityFromClass((List)this.getAbilities(), AbilityAccelerate.class);
        }
        if (key == LucraftKeys.SUPERPOWER_3) {
            return Ability.getAbilityFromClass((List)this.getAbilities(), AbilityDecelerate.class);
        }
        if (key == LucraftKeys.SUPERPOWER_4) {
            return Ability.getAbilityFromClass((List)this.getAbilities(), AbilitySuperSpeed.class);
        }
        if (key == LucraftKeys.SUPERPOWER_5) {
            return Ability.getAbilityFromClass((List)this.getAbilities(), AbilitySlowMotion.class);
        }
        return super.getAbilityForKey(key);
    }

    public void onWorldJoin() {
        this.resetSpeed();
        LucraftCoreUtil.sendSuperpowerUpdatePacket((EntityPlayer)this.player);
    }

    public void onRespawn() {
        this.resetSpeed();
        LucraftCoreUtil.sendSuperpowerUpdatePacket((EntityPlayer)this.player);
    }

    public void onLevelUp(int newLevel) {
        if ((newLevel == 10 || newLevel == 15 || newLevel == 20 || newLevel == 25 || newLevel == 30) && this.extraSpeedLevels < 5) {
            ++this.extraSpeedLevels;
            LucraftCoreUtil.sendSuperpowerUpdatePacket((EntityPlayer)this.player);
        }
    }

    public void setSpeedLevel(int i) {
        this.speedLevel = i;
        if (i <= 0) {
            this.speedLevel = 1;
        }
        this.resetSpeed();
        this.player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(SpeedsterAttributeModifiers.getSpeedsterAttributeModifier(i));
        this.player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111121_a(SpeedsterAttributeModifiers.getSpeedsterAttributeModifier(i));
        int stepheight = (int)MathHelper.func_76131_a((float)this.speedLevel, (float)0.0f, (float)5.0f);
        this.player.func_110148_a(LCAttributes.STEP_HEIGHT).func_111121_a(SpeedsterAttributeModifiers.getSpeedsterAttributeModifier(stepheight));
        this.isInSpeed = true;
        LucraftCoreUtil.sendSuperpowerUpdatePacket((EntityPlayer)this.player);
    }

    public void increaseDecreaseSpeedLevel(boolean faster) {
        if (this.isInSpeed) {
            int newPoints = this.speedLevel + (faster ? 1 : -1);
            if (newPoints > SpeedsterHeroesUtil.getSpeedLevels(this.player) || newPoints < 1) {
                return;
            }
            this.setSpeedLevel(newPoints);
        }
    }

    public void toggleSpeed() {
        if (this.isInSpeed) {
            this.resetSpeed();
        } else {
            this.setSpeedLevel(1);
        }
        LucraftCoreUtil.sendSuperpowerUpdatePacketToAllPlayers((EntityPlayer)this.player);
    }

    public void resetSpeed() {
        for (int i = 0; i < 35; ++i) {
            this.player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(SpeedsterAttributeModifiers.getSpeedsterAttributeModifier(i + 1));
            this.player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111124_b(SpeedsterAttributeModifiers.getSpeedsterAttributeModifier(i + 1));
            this.player.func_110148_a(LCAttributes.STEP_HEIGHT).func_111124_b(SpeedsterAttributeModifiers.getSpeedsterAttributeModifier(i + 1));
        }
        this.isInSpeed = false;
    }
}

