/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.superpower;

import java.util.List;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityAccelerate;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityDecelerate;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilitySlowMotion;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilitySuperSpeed;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityWallRunning;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityWaterRunning;
import lucraft.mods.heroes.speedsterheroes.client.gui.GuiTrailCustomizer;
import lucraft.mods.heroes.speedsterheroes.superpower.SpeedforcePlayerHandler;
import lucraft.mods.heroes.speedsterheroes.superpower.SpeedforcePlayerRenderer;
import lucraft.mods.heroes.speedsterheroes.trailtypes.TrailType;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.abilities.AbilityHealing;
import lucraft.mods.lucraftcore.client.gui.GuiCustomizer;
import lucraft.mods.lucraftcore.superpower.ISuperpowerPlayerRenderer;
import lucraft.mods.lucraftcore.superpower.Superpower;
import lucraft.mods.lucraftcore.superpower.SuperpowerPlayerHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SuperpowerSpeedforce
extends Superpower {
    private static final ResourceLocation TEX = new ResourceLocation("speedsterheroes:textures/gui/superpowerSpeedforce.png");

    public SuperpowerSpeedforce() {
        super("speedforce");
    }

    public SuperpowerPlayerHandler getNewSuperpowerHandler(EntityPlayer player) {
        return new SpeedforcePlayerHandler(player);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderIcon(Minecraft mc, int x, int y) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(TEX);
        mc.field_71462_r.func_73729_b(x, y, 0, 0, 32, 32);
    }

    public boolean canLevelUp() {
        return true;
    }

    public int getMaxLevel() {
        return 30;
    }

    public ISuperpowerPlayerRenderer getPlayerRenderer() {
        return new SpeedforcePlayerRenderer();
    }

    public List<Ability> addDefaultAbilities(EntityPlayer player, List<Ability> list) {
        list.add(new AbilitySuperSpeed(player).setUnlocked(true));
        list.add(new AbilityAccelerate(player).setUnlocked(true));
        list.add(new AbilityDecelerate(player).setUnlocked(true));
        list.add(new AbilityHealing(player, 10, 2.0f, true).setUnlocked(true));
        list.add(new AbilityWallRunning(player).setUnlocked(true).setRequiredLevel(5));
        list.add(new AbilityWaterRunning(player).setUnlocked(true).setRequiredLevel(10));
        list.add(new AbilitySlowMotion(player).setUnlocked(true).setRequiredLevel(30));
        return super.addDefaultAbilities(player, list);
    }

    public boolean canCustomize() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiCustomizer getCustomizerGui(EntityPlayer player) {
        return new GuiTrailCustomizer();
    }

    public NBTTagCompound getDefaultStyleTag() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("TrailType", TrailType.EnumTrailType.PARTICLES.toString());
        nbt.func_74776_a("PrimaryRed", 1.0f);
        nbt.func_74776_a("PrimaryGreen", 1.0f);
        nbt.func_74776_a("PrimaryBlue", 1.0f);
        nbt.func_74776_a("SecondaryRed", 1.0f);
        nbt.func_74776_a("SecondaryGreen", 1.0f);
        nbt.func_74776_a("SecondaryBlue", 1.0f);
        return nbt;
    }

    public int getRequiredLevelForCustomization() {
        return 5;
    }
}

