/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes;

import java.util.ArrayList;
import java.util.List;
import lucraft.mods.heroes.speedsterheroes.abilities.SpeedsterAbility;
import lucraft.mods.heroes.speedsterheroes.entity.SpeedsterPlayerData;
import lucraft.mods.lucraftcore.superpower.Superpower;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SuperpowerSpeedforce
extends Superpower {
    private static final ResourceLocation TEX = new ResourceLocation("SpeedsterHeroes:textures/gui/superpowerSpeedforce.png");

    public SuperpowerSpeedforce() {
        super("speedforce");
    }

    public void applyPower(EntityPlayer player) {
        SpeedsterPlayerData.get(player).toggleSpeedForce(true);
    }

    public void removePower(EntityPlayer player) {
        SpeedsterPlayerData.get(player).toggleSpeedForce(false);
    }

    public boolean hasPower(EntityPlayer player) {
        return SpeedsterPlayerData.get((EntityPlayer)player).hasSpeedforce;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderIcon(Minecraft mc, int x, int y) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(TEX);
        mc.field_71462_r.func_73729_b(x, y, 0, 0, 32, 32);
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getAbilitiesNames() {
        ArrayList<String> list = new ArrayList<String>();
        Minecraft mc = Minecraft.func_71410_x();
        SpeedsterPlayerData data = SpeedsterPlayerData.get((EntityPlayer)mc.field_71439_g);
        for (SpeedsterAbility ab : SpeedsterAbility.abilities) {
            if (ab.getRequiredLevel((EntityPlayer)mc.field_71439_g) <= data.level) {
                list.add(ab.getDisplayName());
                continue;
            }
            list.add("???");
        }
        return list;
    }

    public String getSuperpowerKeyBindingInfo(int i) {
        switch (i) {
            case 1: {
                return StatCollector.func_74838_a((String)"speedsterheroes.keybinding.keyLeveling");
            }
            case 2: {
                return StatCollector.func_74838_a((String)"speedsterheroes.keybinding.keyFaster");
            }
            case 3: {
                return StatCollector.func_74838_a((String)"speedsterheroes.keybinding.keySlower");
            }
            case 4: {
                return StatCollector.func_74838_a((String)"speedsterheroes.keybinding.keySpeed");
            }
            case 5: {
                return StatCollector.func_74838_a((String)"speedsterheroes.keybinding.keyTrail");
            }
        }
        return "/";
    }
}

