/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.abilities;

import java.util.ArrayList;
import lucraft.mods.heroes.speedsterheroes.SpeedsterHeroes;
import lucraft.mods.heroes.speedsterheroes.abilities.SpeedsterAbilitySmart;
import lucraft.mods.heroes.speedsterheroes.items.SHItems;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.heroes.speedsterheroes.util.SHAchievements;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.StatCollector;

public abstract class SpeedsterAbility {
    public static SpeedsterAbility wallRunning;
    public static SpeedsterAbility waterRunning;
    public static SpeedsterAbility lightningThrowing;
    public static SpeedsterAbility phasing;
    public static SpeedsterAbility timeRemnant;
    public static SpeedsterAbility dimensionBreach;
    public static SpeedsterAbility slowmo;
    public static SpeedsterAbility speedforceJump;
    public static ArrayList<SpeedsterAbility> abilities;
    private String unlocalizedName;
    private ItemStack icon;
    private Achievement achievement;

    public static void preInit() {
        wallRunning = new SpeedsterAbilitySmart("wallRunning", new ItemStack(SHItems.iconItem, 1, 3), -3, -2, 5, 20, true);
        waterRunning = new SpeedsterAbilitySmart("waterRunning", new ItemStack(SHItems.iconItem, 1, 4), 5, -4, 10, 20, true);
        lightningThrowing = new SpeedsterAbilitySmart("lightningThrowing", new ItemStack(SHItems.iconItem, 1, 1), -1, -6, 15, 20, false);
        phasing = new SpeedsterAbilitySmart("phasing", new ItemStack(SHItems.iconItem, 1, 5), 3, -2, 15, 25, false);
        timeRemnant = new SpeedsterAbilitySmart("timeRemnant", new ItemStack(SHItems.iconItem, 1, 8), -3, -4, 20, 25, false);
        speedforceJump = new SpeedsterAbilitySmart("speedforceJump", new ItemStack(SHItems.iconItem, 1, 10), -7, 3, 20, 30, false);
        slowmo = new SpeedsterAbilitySmart("slowmo", new ItemStack(SHItems.iconItem, 1, 7), 5, 5, 30, 30, false);
        SpeedsterAbility.registerAbility(wallRunning);
        SpeedsterAbility.registerAbility(waterRunning);
        SpeedsterAbility.registerAbility(lightningThrowing);
        SpeedsterAbility.registerAbility(phasing);
        SpeedsterAbility.registerAbility(timeRemnant);
        SpeedsterAbility.registerAbility(speedforceJump);
        SpeedsterAbility.registerAbility(slowmo);
    }

    public static void registerAbility(SpeedsterAbility ability) {
        if (!abilities.contains(ability)) {
            abilities.add(ability);
        }
    }

    public SpeedsterAbility(String name) {
        this.unlocalizedName = name;
    }

    public void initAbility() {
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String getTranslationName() {
        return "speedsterheroes.abilities." + this.getUnlocalizedName() + ".name";
    }

    public String getDisplayName() {
        return StatCollector.func_74838_a((String)this.getTranslationName());
    }

    public String getDescription() {
        return StatCollector.func_74838_a((String)("speedsterheroes.abilities." + this.getUnlocalizedName() + ".desc"));
    }

    public ItemStack getIconStack() {
        return this.icon;
    }

    public SpeedsterAbility setIconStack(ItemStack stack) {
        this.icon = stack;
        return this;
    }

    public SpeedsterAbility getDependendAbility() {
        return null;
    }

    public boolean isBaseAbility() {
        return false;
    }

    public Achievement getAchievement() {
        return this.achievement;
    }

    public abstract int getRequiredLevel(EntityPlayer var1);

    public abstract int getRequiredSpeedsterPoints(EntityPlayer var1);

    public void createAchievement(int colomn, int row, Achievement parent) {
        this.achievement = new Achievement("achievement." + this.getUnlocalizedName(), this.getUnlocalizedName(), colomn, row, this.getIconStack(), parent).func_75971_g();
        SHAchievements.registerAchievement(this.achievement);
    }

    public boolean canBeUsed(EntityPlayer player, SpeedsterType type, int level) {
        boolean hasAchievement = SpeedsterHeroes.proxy.hasAchievement(player, this.getAchievement());
        if (this.isBaseAbility()) {
            return hasAchievement;
        }
        return hasAchievement && type != null && type.hasAbility(this);
    }

    static {
        abilities = new ArrayList();
    }
}

