/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.client.render;

import java.util.ArrayList;
import java.util.List;
import lucraft.mods.heroes.speedsterheroes.abilities.SpeedsterAbility;
import lucraft.mods.heroes.speedsterheroes.entity.SpeedsterPlayerData;
import lucraft.mods.heroes.speedsterheroes.proxies.SpeedsterHeroesProxy;
import lucraft.mods.heroes.speedsterheroes.render.speedlevelbars.SpeedLevelBar;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.heroes.speedsterheroes.util.SpeedsterHeroesUtil;
import lucraft.mods.lucraftcore.access.LucraftTickrateHooks;
import lucraft.mods.lucraftcore.util.LCRenderHelper;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class SpeedHUDRenderer {
    Minecraft mc = Minecraft.func_71410_x();
    public static ResourceLocation hudTex = new ResourceLocation("SpeedsterHeroes:textures/gui/speedHud.png");

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent e) {
        if (e.isCancelable() || e.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        if (this.mc.field_71439_g != null && this.mc.field_71462_r == null && !this.mc.field_71474_y.field_74319_N && !this.mc.field_71474_y.field_74330_P && SpeedsterPlayerData.get((EntityPlayer)this.mc.field_71439_g).isInSpeed) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GL11.glBlendFunc((int)770, (int)771);
            List<SpeedLevelBar> list = SpeedsterHeroesUtil.getSpeedLevelList((EntityPlayer)this.mc.field_71439_g);
            SpeedsterPlayerData data = SpeedsterPlayerData.get((EntityPlayer)this.mc.field_71439_g);
            int speedPoints = list.size();
            int selectedPoint = data.speedLevel;
            SpeedsterType type = SpeedsterHeroesUtil.getSpeedsterType((EntityLivingBase)this.mc.field_71439_g);
            int barWidth = speedPoints * 15 - (speedPoints - 1) * 3;
            int x = e.resolution.func_78326_a() / 2 - barWidth / 2;
            int y = (int)((float)e.resolution.func_78328_b() / 1.4f);
            for (int i = 0; i < speedPoints; ++i) {
                SpeedLevelBar speedLevelType = list.get(i);
                this.mc.field_71446_o.func_110577_a(type == null ? hudTex : new ResourceLocation(type.getSpeedLevelTextureLocation()));
                this.mc.field_71456_v.func_73729_b(x + i * 12, y, 0, 0, 15, 21);
                speedLevelType.drawIcon(this.mc, x + i * 12 + 3, y + 3, type);
                this.mc.field_71446_o.func_110577_a(hudTex);
                if (i != selectedPoint - 1) continue;
                this.mc.field_71456_v.func_73729_b(x + i * 12 + 4, y + 18, 15, 17, 7, 4);
            }
            double d = SpeedHUDRenderer.round(this.mc.field_71439_g.func_70011_f(this.mc.field_71439_g.field_70169_q, this.mc.field_71439_g.field_70167_r, this.mc.field_71439_g.field_70166_s) * 20.0 * 3.6, 2);
            String detail = StatCollector.func_74838_a((String)"speedsterheroes.info.speedlevel") + ": " + selectedPoint + " - " + (d < 1.0 ? 0.0 : d) + " km/h";
            int stringLength = this.mc.field_71466_p.func_78256_a(detail);
            LCRenderHelper.drawStringWithOutline((String)detail, (int)(e.resolution.func_78326_a() / 2 - stringLength / 2), (int)(y - 10), (int)0xFFFFFF, (int)0);
            if (SpeedsterHeroesUtil.isVelocity9Active((EntityLivingBase)this.mc.field_71439_g) && this.mc.field_71439_g.func_70660_b(SpeedsterHeroesProxy.velocity9) != null) {
                String v9Timer = StatCollector.func_74838_a((String)"item.velocity9.name") + ": " + LucraftCoreUtil.intToTime((int)(this.mc.field_71439_g.func_70660_b(SpeedsterHeroesProxy.velocity9).func_76459_b() / 20));
                int timerStringLength = this.mc.field_71466_p.func_78256_a(v9Timer);
                LCRenderHelper.drawStringWithOutline((String)v9Timer, (int)(e.resolution.func_78326_a() / 2 - timerStringLength / 2), (int)(y + 25), (int)0xFFFFFF, (int)0);
            }
            ArrayList<ItemStack> activeAbilities = new ArrayList<ItemStack>();
            if (data.phasingActive) {
                activeAbilities.add(SpeedsterAbility.phasing.getIconStack());
            }
            if (!LucraftTickrateHooks.isNormalTickrate()) {
                activeAbilities.add(SpeedsterAbility.slowmo.getIconStack());
            }
            for (int i = 0; i < activeAbilities.size(); ++i) {
                this.mc.field_71446_o.func_110577_a(hudTex);
                this.mc.field_71456_v.func_73729_b(e.resolution.func_78326_a() - 24, 24 * i, 0, 60, 24, 24);
                this.mc.func_175599_af().func_175042_a((ItemStack)activeAbilities.get(i), e.resolution.func_78326_a() - 20, i * 24 + 4);
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }
}

