/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.client.render;

import java.util.HashMap;
import java.util.LinkedList;
import lucraft.mods.heroes.speedsterheroes.SHConfig;
import lucraft.mods.heroes.speedsterheroes.client.render.SpeedTrailRenderer;
import lucraft.mods.heroes.speedsterheroes.entity.EntityDimensionBreach;
import lucraft.mods.heroes.speedsterheroes.entity.EntityParticleAcceleratorSit;
import lucraft.mods.heroes.speedsterheroes.entity.EntityRingDummy;
import lucraft.mods.heroes.speedsterheroes.entity.EntitySpeedMirage;
import lucraft.mods.heroes.speedsterheroes.entity.EntityTimeRemnant;
import lucraft.mods.heroes.speedsterheroes.entity.EntityTimeWraith;
import lucraft.mods.heroes.speedsterheroes.entity.SpeedsterPlayerData;
import lucraft.mods.heroes.speedsterheroes.proxies.SpeedsterHeroesProxy;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.heroes.speedsterheroes.trailtypes.TrailType;
import lucraft.mods.heroes.speedsterheroes.util.SpeedsterHeroesUtil;
import lucraft.mods.lucraftcore.entity.EntityMountableBlock;
import lucraft.mods.lucraftcore.events.RenderModelEvent;
import lucraft.mods.lucraftcore.events.SetupModelBipedEvent;
import lucraft.mods.lucraftcore.util.IFakePlayerEntity;
import lucraft.mods.lucraftcore.util.LucraftCoreClientUtil;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.lwjgl.opengl.GL11;

public class TrailRenderHandler {
    public static HashMap<EntityLivingBase, Float> traveledBlocksMap = new HashMap();
    public static HashMap<EntityLivingBase, Vec3> lastPosMap = new HashMap();
    public static HashMap<EntityLivingBase, LinkedList<EntitySpeedMirage>> trailDataMap = new HashMap();

    @SubscribeEvent
    public void onLeave(PlayerEvent.PlayerLoggedOutEvent e) {
        if (TrailRenderHandler.canHaveTrail((Entity)e.player)) {
            traveledBlocksMap.remove(e.player);
            lastPosMap.remove(e.player);
            trailDataMap.remove(e.player);
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (TrailRenderHandler.canHaveTrail((Entity)e.player)) {
            traveledBlocksMap.put((EntityLivingBase)e.player, Float.valueOf(0.0f));
            lastPosMap.put((EntityLivingBase)e.player, e.player.func_174791_d());
            trailDataMap.put((EntityLivingBase)e.player, new LinkedList());
        }
    }

    @SubscribeEvent
    public void onLogin(EntityEvent.EntityConstructing e) {
        if (e.entity instanceof EntityTimeRemnant) {
            traveledBlocksMap.put((EntityLivingBase)e.entity, Float.valueOf(0.0f));
            lastPosMap.put((EntityLivingBase)e.entity, e.entity.func_174791_d());
            trailDataMap.put((EntityLivingBase)e.entity, new LinkedList());
        }
    }

    @SubscribeEvent
    public void onDimChange(PlayerEvent.PlayerChangedDimensionEvent e) {
        for (EntitySpeedMirage esm : trailDataMap.get(e.player)) {
            esm.func_70106_y();
        }
        trailDataMap.put((EntityLivingBase)e.player, new LinkedList());
    }

    @SubscribeEvent
    public void playerTick(LivingEvent.LivingUpdateEvent e) {
        if (SHConfig.trailRender && TrailRenderHandler.canHaveTrail((Entity)e.entityLiving) && e.entityLiving.field_70170_p.field_72995_K && TrailRenderHandler.isInSpeed(e.entityLiving)) {
            if (TrailRenderHandler.isPlayerMovingClientSide(e.entityLiving)) {
                EntityLivingBase player = e.entityLiving;
                if (!traveledBlocksMap.containsKey(player)) {
                    traveledBlocksMap.put(player, Float.valueOf(0.0f));
                }
                if (!lastPosMap.containsKey(player)) {
                    lastPosMap.put(player, player.func_174791_d());
                }
                if (!trailDataMap.containsKey(player)) {
                    trailDataMap.put(player, new LinkedList());
                }
                Vec3 lastPos = lastPosMap.get(player);
                float distancedWalked = traveledBlocksMap.get(player).floatValue() + (float)player.func_70011_f(lastPos.field_72450_a, lastPos.field_72448_b, lastPos.field_72449_c);
                if (distancedWalked >= player.field_70130_N + player.field_70130_N / 10.0f) {
                    EntitySpeedMirage esm = new EntitySpeedMirage(player.field_70170_p, player, player.func_174791_d(), false);
                    player.field_70170_p.func_72838_d((Entity)esm);
                    this.addSpeedMirageToList(player, esm);
                    distancedWalked = 0.0f;
                }
                traveledBlocksMap.put(player, Float.valueOf(distancedWalked));
            }
            lastPosMap.put(e.entityLiving, e.entityLiving.func_174791_d());
        }
    }

    public static boolean isPlayerMovingClientSide(EntityLivingBase entity) {
        return TrailRenderHandler.areVec3Equal(entity.func_174791_d(), lastPosMap.get(entity));
    }

    public static boolean areVec3Equal(Vec3 vec1, Vec3 vec2) {
        if (vec1 == null || vec2 == null) {
            return false;
        }
        return vec1.field_72450_a != vec2.field_72450_a || vec1.field_72448_b != vec2.field_72448_b || vec1.field_72449_c != vec2.field_72449_c;
    }

    public void addSpeedMirageToList(EntityLivingBase player, EntitySpeedMirage e) {
        LinkedList<EntitySpeedMirage> list = trailDataMap.get(player);
        if (list.size() >= 10) {
            list.remove(0);
            list.add(e);
        } else {
            list.add(e);
        }
        trailDataMap.put(player, list);
    }

    public static LinkedList<EntitySpeedMirage> getSpeedMiragesFromPlayer(EntityLivingBase player) {
        if (trailDataMap.get(player) == null) {
            trailDataMap.put(player, new LinkedList());
        }
        return trailDataMap.get(player);
    }

    @SubscribeEvent
    public void renderModel(RenderModelEvent e) {
        Object entity;
        if (e.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.entity;
            if (player.field_70154_o != null && player.field_70154_o instanceof EntityParticleAcceleratorSit && ((EntityParticleAcceleratorSit)player.field_70154_o).info.equalsIgnoreCase("particleAccelerator")) {
                EntityParticleAcceleratorSit sit = (EntityParticleAcceleratorSit)player.field_70154_o;
                float f = 0.0f;
                if (sit.facing == EnumFacing.EAST) {
                    f = 90.0f;
                } else if (sit.facing == EnumFacing.NORTH) {
                    f = 180.0f;
                } else if (sit.facing == EnumFacing.WEST) {
                    f = -90.0f;
                }
                GlStateManager.func_179114_b((float)(-player.field_70761_aq - f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        if (SpeedsterHeroesUtil.isEntityAvailableForSpeedforce((Entity)e.entityLiving) && SpeedsterPlayerData.get((EntityPlayer)((EntityPlayer)e.entityLiving)).isWallRunning) {
            GlStateManager.func_179109_b((float)0.0f, (float)(-e.entity.field_70131_O), (float)0.0f);
            GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (e.entity instanceof EntityTimeWraith) {
            entity = (EntityTimeWraith)e.entityLiving;
            double d = Math.min(Math.sqrt((((EntityTimeWraith)((Object)entity)).field_70169_q - ((EntityTimeWraith)((Object)entity)).field_70165_t) * (((EntityTimeWraith)((Object)entity)).field_70169_q - ((EntityTimeWraith)((Object)entity)).field_70165_t) + (((EntityTimeWraith)((Object)entity)).field_70166_s - ((EntityTimeWraith)((Object)entity)).field_70161_v) * (((EntityTimeWraith)((Object)entity)).field_70166_s - ((EntityTimeWraith)((Object)entity)).field_70161_v)), 1.0) * (double)(((EntityTimeWraith)((Object)entity)).field_70701_bs == 0.0f ? 1.0f : ((EntityTimeWraith)((Object)entity)).field_70701_bs);
            GL11.glRotated((double)(80.0 * d), (double)1.0, (double)0.0, (double)0.0);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(30.0 * d * 4.0 / 100.0));
            GlStateManager.func_179137_b((double)0.0, (double)(Math.cos(((float)((EntityTimeWraith)((Object)entity)).field_70173_aa + LucraftCoreClientUtil.renderTick) * 0.1f) / 10.0), (double)0.0);
            if (((EntityTimeWraith)((Object)entity)).getDespawnTimer() > 0) {
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glAlphaFunc((int)516, (float)0.003921569f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - ((float)((EntityTimeWraith)((Object)entity)).getDespawnTimer() + LucraftCoreClientUtil.renderTick) / 100.0f));
            }
        } else if (e.entity instanceof EntityRingDummy) {
            entity = (EntityRingDummy)e.entity;
            double d = Math.min(Math.sqrt((((EntityRingDummy)((Object)entity)).field_70169_q - ((EntityRingDummy)((Object)entity)).field_70165_t) * (((EntityRingDummy)((Object)entity)).field_70169_q - ((EntityRingDummy)((Object)entity)).field_70165_t) + (((EntityRingDummy)((Object)entity)).field_70166_s - ((EntityRingDummy)((Object)entity)).field_70161_v) * (((EntityRingDummy)((Object)entity)).field_70166_s - ((EntityRingDummy)((Object)entity)).field_70161_v)), 1.0) * (double)(((EntityRingDummy)((Object)entity)).field_70701_bs == 0.0f ? 1.0f : ((EntityRingDummy)((Object)entity)).field_70701_bs);
            float scale = MathHelper.func_76131_a((float)(((float)((EntityRingDummy)((Object)entity)).field_70173_aa + LucraftCoreClientUtil.renderTick) / 20.0f), (float)0.0f, (float)0.9f);
            GL11.glRotated((double)(80.0 * d), (double)1.0, (double)0.0, (double)0.0);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179137_b((double)0.0, (double)((double)-0.2f + Math.cos(((float)((EntityRingDummy)((Object)entity)).field_70173_aa + LucraftCoreClientUtil.renderTick) * 0.1f) / 10.0), (double)0.0);
        }
    }

    @SubscribeEvent
    public void setupModel(SetupModelBipedEvent e) {
        if (SpeedsterHeroesUtil.isEntityAvailableForSpeedforce(e.entity)) {
            EntityPlayer player = (EntityPlayer)e.entity;
            SpeedsterPlayerData data = SpeedsterPlayerData.get(player);
            if (data.isInSpeed && (e.entity.field_70122_E || player.field_70170_p.func_180495_p(player.func_180425_c().func_177982_a(0, -1, 0)).func_177230_c() instanceof BlockLiquid)) {
                e.f *= (float)data.speedLevel;
            }
            if (SpeedsterPlayerData.get((EntityPlayer)player).isWallRunning) {
                e.f = (float)player.field_70163_u;
                e.f1 = MathHelper.func_76134_b((float)((float)player.field_70163_u * (float)data.speedLevel * 4.0f));
            }
            if (player.field_70154_o != null && player.field_70154_o instanceof EntityMountableBlock && ((EntityMountableBlock)player.field_70154_o).info.equalsIgnoreCase("particleAccelerator")) {
                e.setCanceled(true);
                ModelBiped model = e.model;
                model.field_178724_i.field_78808_h = -2.3f;
                model.field_178723_h.field_78808_h = 2.3f;
                if (model instanceof ModelPlayer) {
                    ModelPlayer playerModel = (ModelPlayer)model;
                    playerModel.field_178734_a.field_78808_h = -2.3f;
                    playerModel.field_178732_b.field_78808_h = 2.3f;
                }
            }
        } else if (e.entity instanceof EntityTimeWraith) {
            e.f = 0.0f;
            e.f1 = 0.0f;
        } else if (e.entity instanceof EntityRingDummy) {
            e.setCanceled(true);
            EntityRingDummy entity = (EntityRingDummy)e.entity;
            float d = (float)(Math.min(Math.sqrt((entity.field_70169_q - entity.field_70165_t) * (entity.field_70169_q - entity.field_70165_t) + (entity.field_70166_s - entity.field_70161_v) * (entity.field_70166_s - entity.field_70161_v)), 1.0) * (double)(entity.field_70701_bs == 0.0f ? 1.0f : entity.field_70701_bs));
            e.model.field_178723_h.field_78795_f = 0.7f * d;
            e.model.field_178723_h.field_78808_h = 0.2f * d;
            e.model.field_178724_i.field_78795_f = 0.7f * d;
            e.model.field_178724_i.field_78808_h = -0.2f * d;
            e.model.field_178721_j.field_78795_f = 0.7f * d;
            e.model.field_178721_j.field_78808_h = 0.2f * d;
            e.model.field_178722_k.field_78795_f = 0.7f * d;
            e.model.field_178722_k.field_78808_h = -0.2f * d;
        }
    }

    @SubscribeEvent
    public void renderEntityPre(RenderLivingEvent.Pre<EntityLivingBase> e) {
        if (e.entity instanceof EntityPlayer && e.entity.field_70154_o instanceof EntityDimensionBreach) {
            EntityDimensionBreach breach = (EntityDimensionBreach)e.entity.field_70154_o;
            if (breach.type == EntityDimensionBreach.BreachActionTypes.PORTAL) {
                e.setCanceled(true);
            }
        }
        if (e.entity instanceof EntitySpeedMirage) {
            EntitySpeedMirage entity = (EntitySpeedMirage)e.entity;
            SpeedTrailRenderer renderer = entity.trail.getSpeedTrailRenderer();
            if (!renderer.shouldRenderSpeedMirage(entity, entity.trail)) {
                e.setCanceled(true);
                return;
            }
            renderer.preRenderSpeedMirage(entity, entity.trail);
        }
        if (e.entity.func_70644_a(SpeedsterHeroesProxy.speedShock)) {
            TrailType.renderer_lightnings.renderFlickering(e.entity, TrailType.lightnings_orange);
        }
    }

    @SubscribeEvent
    public void renderEntityPost(RenderLivingEvent.Post<EntityLivingBase> e) {
        if (TrailRenderHandler.canHaveTrail((Entity)e.entity) && TrailRenderHandler.isInSpeed(e.entity)) {
            EntityLivingBase player = e.entity;
            SpeedsterType type = SpeedsterHeroesUtil.getSpeedsterType(player);
            TrailType trail = type == null ? (SpeedsterHeroesUtil.isVelocity9Active(player) ? TrailType.lightnings_orange : (player instanceof EntityPlayer ? SpeedsterPlayerData.get((EntityPlayer)((EntityPlayer)player)).customTrailType : TrailType.normal)) : type.getTrailType();
            trail.getSpeedTrailRenderer().renderTrail(player, trail);
            if (SHConfig.flickerRender && (type != null && type.doesFlicker() || SpeedsterHeroesUtil.isVelocity9Active(player)) && (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0 || player != Minecraft.func_71410_x().field_71439_g)) {
                trail.getSpeedTrailRenderer().renderFlickering(player, trail);
            }
        }
    }

    @SubscribeEvent
    public void renderNameTag(RenderLivingEvent.Specials.Pre e) {
        EntityLivingBase player;
        SpeedsterType type;
        if (TrailRenderHandler.canHaveTrail((Entity)e.entity) && (type = SpeedsterHeroesUtil.getSpeedsterType(player = e.entity)) != null && SpeedsterHeroesUtil.hasHelmetOn(player) && type.shouldHideNameTag(player, player.func_71124_b(4).func_77978_p().func_74767_n("helmetOpen"))) {
            e.setCanceled(true);
        }
    }

    public static boolean canHaveTrail(Entity entity) {
        return entity != null && entity instanceof EntityLivingBase && (entity instanceof EntityPlayer || entity instanceof EntityTimeRemnant) && !(entity instanceof IFakePlayerEntity);
    }

    public static boolean isInSpeed(EntityLivingBase entity) {
        return entity instanceof EntityPlayer ? SpeedsterPlayerData.get((EntityPlayer)((EntityPlayer)entity)).isInSpeed : entity instanceof EntityTimeRemnant;
    }
}

