/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.entity;

import io.netty.buffer.ByteBuf;
import lucraft.mods.heroes.speedsterheroes.network.MessageSendInfoToClient;
import lucraft.mods.heroes.speedsterheroes.network.PacketDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityDimensionBreach
extends Entity
implements IEntityAdditionalSpawnData {
    public BreachActionTypes type;
    public int progress = 20;
    public boolean starting;
    public boolean despawn;
    public Entity entityToSpawn;

    public EntityDimensionBreach(World world) {
        super(world);
        this.func_70105_a(3.0f, 3.0f);
    }

    public EntityDimensionBreach(World worldIn, double x, double y, double z, BreachActionTypes type) {
        super(worldIn);
        this.func_70107_b(x, y, z);
        this.type = type;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70173_aa < 20 && !this.despawn) {
            --this.progress;
            this.starting = true;
        }
        if (this.despawn) {
            ++this.progress;
            this.starting = false;
            if (this.progress == 20) {
                this.func_70106_y();
            }
        }
        if (this.type == BreachActionTypes.SPAWN_ENTITY) {
            if (this.field_70173_aa > 80) {
                this.startDespawn();
            }
            if (this.field_70173_aa == 25 && !this.func_130014_f_().field_72995_K && this.entityToSpawn != null) {
                this.entityToSpawn.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.func_130014_f_().func_72838_d(this.entityToSpawn);
            }
        }
        if (this.type == BreachActionTypes.PORTAL && this.field_70153_n == null && this.field_70173_aa > 50) {
            this.startDespawn();
        }
    }

    public void startDespawn() {
        this.despawn = true;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tagCompund) {
        this.progress = tagCompund.func_74762_e("progress");
        if (tagCompund.func_74762_e("type") != -1) {
            this.type = BreachActionTypes.getTypeFromId(tagCompund.func_74762_e("type"));
        }
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("progress", this.progress);
        tagCompound.func_74768_a("type", this.type == null ? -1 : this.type.ordinal());
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        super.func_70100_b_(entityIn);
        if (this.field_70153_n == null && this.type == BreachActionTypes.PORTAL && entityIn instanceof EntityPlayerMP && !this.despawn) {
            entityIn.func_70078_a((Entity)this);
            PacketDispatcher.sendTo(new MessageSendInfoToClient(MessageSendInfoToClient.InfoType.DIMENSION_BREACH), (EntityPlayerMP)entityIn);
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.type == null ? -1 : this.type.ordinal());
    }

    public void readSpawnData(ByteBuf additionalData) {
        int id = additionalData.readInt();
        if (id != -1) {
            this.type = BreachActionTypes.getTypeFromId(id);
        }
    }

    public static enum BreachActionTypes {
        NONE,
        SPAWN_ENTITY,
        PORTAL;


        public static BreachActionTypes getTypeFromId(int id) {
            for (BreachActionTypes types : BreachActionTypes.values()) {
                if (types.ordinal() != id) continue;
                return types;
            }
            return null;
        }
    }
}

