/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.entity;

import java.util.HashMap;
import lucraft.mods.heroes.speedsterheroes.SHConfig;
import lucraft.mods.heroes.speedsterheroes.SpeedsterHeroes;
import lucraft.mods.heroes.speedsterheroes.abilities.SpeedsterAbility;
import lucraft.mods.heroes.speedsterheroes.entity.EntityLightning;
import lucraft.mods.heroes.speedsterheroes.entity.EntityTimeRemnant;
import lucraft.mods.heroes.speedsterheroes.entity.EntityTimeWraith;
import lucraft.mods.heroes.speedsterheroes.entity.SpeedsterPlayerData;
import lucraft.mods.heroes.speedsterheroes.items.SHItems;
import lucraft.mods.heroes.speedsterheroes.proxies.SpeedsterHeroesProxy;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.heroes.speedsterheroes.util.SpeedsterHeroesUtil;
import lucraft.mods.lucraftcore.entity.SuperpowerPlayerData;
import lucraft.mods.lucraftcore.events.GetArmSwingMultiplierEvent;
import lucraft.mods.lucraftcore.events.PlayerLeftClickEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SHEntityEvents {
    public static HashMap<EntityPlayer, Float> lastSavedStepHeight = new HashMap();

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        NBTTagCompound compound = new NBTTagCompound();
        SpeedsterPlayerData.get(event.original).saveNBTData(compound);
        SpeedsterPlayerData.get(event.entityPlayer).loadNBTData(compound);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (SpeedsterHeroesUtil.isEntityAvailableForSpeedforce(event.entity) && SpeedsterPlayerData.get((EntityPlayer)event.entity) == null) {
            SpeedsterPlayerData.register((EntityPlayer)event.entity);
        }
        if (SpeedsterHeroesUtil.isEntityAvailableForSpeedforce(event.entity) && event.entity.getExtendedProperties("SpeedsterHeroes") == null) {
            event.entity.registerExtendedProperties("SpeedsterHeroes", (IExtendedEntityProperties)new SpeedsterPlayerData((EntityPlayer)event.entity));
        }
    }

    @SubscribeEvent
    public void onUpdate(TickEvent.PlayerTickEvent e) {
        if (SpeedsterHeroesUtil.isEntityAvailableForSpeedforce((Entity)e.player)) {
            SpeedsterPlayerData.get(e.player).onUpdate(e.phase);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent e) {
        if (SpeedsterHeroesUtil.isEntityAvailableForSpeedforce(e.entity)) {
            EntityPlayer player = (EntityPlayer)e.entityLiving;
            if (SpeedsterPlayerData.get((EntityPlayer)player).phasingActive) {
                player.field_70145_X = true;
                player.field_70181_x = 0.0;
                player.field_70122_E = true;
            }
        }
        if (e.entityLiving.func_70644_a(SpeedsterHeroesProxy.speedShock) && e.entityLiving.func_70660_b(SpeedsterHeroesProxy.speedShock).func_76459_b() == 0) {
            e.entityLiving.func_82170_o(SpeedsterHeroesProxy.speedShock.field_76415_H);
        }
        if (e.entityLiving.func_70644_a(SpeedsterHeroesProxy.velocity9) && e.entityLiving.func_70660_b(SpeedsterHeroesProxy.velocity9).func_76459_b() == 0) {
            e.entityLiving.func_82170_o(SpeedsterHeroesProxy.velocity9.field_76415_H);
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && SpeedsterHeroesUtil.isEntityAvailableForSpeedforce((Entity)event.player)) {
            SpeedsterPlayerData.get((EntityPlayer)event.player).isInSpeed = false;
            if (SpeedsterPlayerData.get((EntityPlayer)event.player).hasSpeedforce && !SuperpowerPlayerData.get((EntityPlayer)event.player).hasSuperpower()) {
                SuperpowerPlayerData.get((EntityPlayer)event.player).setSuperpower(SpeedsterHeroes.speedforce);
            }
        }
    }

    @SubscribeEvent
    public void onUse(PlayerInteractEvent e) {
        if (e.entityPlayer.func_70694_bm() == null || e.entityPlayer.func_70694_bm().func_77973_b() == SHItems.ring) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent e) {
        EntityLivingBase entity = e.entityLiving;
        if (SpeedsterHeroesUtil.isEntityAvailableForSpeedforce((Entity)e.entityLiving) && SpeedsterPlayerData.get((EntityPlayer)((EntityPlayer)entity)).isInSpeed) {
            float speedLevel = SpeedsterPlayerData.get((EntityPlayer)((EntityPlayer)entity)).speedLevel;
            float x = MathHelper.func_76131_a((float)((float)(entity.field_70159_w * (double)speedLevel)), (float)-3.0f, (float)3.0f);
            float y = speedLevel / 30.0f;
            float z = MathHelper.func_76131_a((float)((float)(entity.field_70179_y * (double)speedLevel)), (float)-3.0f, (float)3.0f);
            entity.func_70024_g((double)x, (double)y, (double)z);
        }
    }

    @SubscribeEvent
    public void onDamage(LivingFallEvent e) {
        if (SpeedsterHeroesUtil.isEntityAvailableForSpeedforce(e.entity)) {
            SpeedsterPlayerData data = SpeedsterPlayerData.get((EntityPlayer)e.entityLiving);
            if (data.isInSpeed) {
                e.distance /= (float)data.speedLevel;
                if (e.entityLiving.func_70093_af() && SpeedsterAbility.speedforceJump.canBeUsed((EntityPlayer)e.entityLiving, SpeedsterHeroesUtil.getSpeedsterType(e.entityLiving), data.level)) {
                    AxisAlignedBB a = new AxisAlignedBB(new BlockPos(e.entity.func_180425_c().func_177958_n() - 2, e.entity.func_180425_c().func_177956_o(), e.entity.func_180425_c().func_177952_p() - 2), new BlockPos(e.entity.func_180425_c().func_177958_n() + 3, e.entity.func_180425_c().func_177956_o() + 1, e.entity.func_180425_c().func_177952_p() + 3));
                    for (EntityLivingBase entity : e.entity.field_70170_p.func_72872_a(EntityLivingBase.class, a)) {
                        if (entity != e.entityLiving) {
                            entity.func_70690_d(new PotionEffect(SpeedsterHeroesProxy.speedShock.field_76415_H, 200));
                            e.entity.field_70170_p.func_72885_a((Entity)entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.1f, false, true);
                        }
                        int amount = 10;
                        for (int x = 0; x < amount; ++x) {
                            for (int z = 0; z < amount; ++z) {
                                float x_ = (float)((double)((float)x / (float)amount * 6.0f - 3.0f) + e.entity.field_70170_p.field_73012_v.nextDouble() / 2.0);
                                float z_ = (float)((double)((float)z / (float)amount * 6.0f - 3.0f) + e.entity.field_70170_p.field_73012_v.nextDouble() / 2.0);
                                e.entity.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, e.entity.field_70165_t + (double)x_, e.entity.field_70163_u, e.entity.field_70161_v + (double)z_, 0.0, 0.0, 0.0, new int[0]);
                            }
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed e) {
        SpeedsterPlayerData data = SpeedsterPlayerData.get(e.entityPlayer);
        if (data.isInSpeed) {
            e.newSpeed = e.originalSpeed * MathHelper.func_76131_a((float)((float)data.speedLevel / 4.0f), (float)1.0f, (float)5.0f);
        }
    }

    @SubscribeEvent
    public void onDamage(LivingHurtEvent e) {
        if (e.source instanceof EntityDamageSource && ((EntityDamageSource)e.source).func_76364_f() != null && SpeedsterHeroesUtil.isEntityAvailableForSpeedforce(((EntityDamageSource)e.source).func_76364_f())) {
            EntityPlayer player = (EntityPlayer)((EntityDamageSource)e.source).func_76364_f();
            SpeedsterPlayerData data = SpeedsterPlayerData.get(player);
            if (data.isMoving && data.isInSpeed) {
                e.ammount += MathHelper.func_76131_a((float)((float)data.speedLevel / 3.0f), (float)0.0f, (float)3.0f);
            }
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent e) {
        if ((e.entityLiving instanceof EntityTimeRemnant || e.entityLiving instanceof EntityPlayer) && e.source.func_76364_f() != null && e.source.func_76364_f() instanceof EntityTimeWraith) {
            ((EntityTimeWraith)e.source.func_76364_f()).setDespawnTimer(1);
        }
    }

    @SubscribeEvent
    public void armSwing(GetArmSwingMultiplierEvent e) {
        if (e.entity instanceof EntityPlayer && SpeedsterPlayerData.get((EntityPlayer)((EntityPlayer)e.entity)).isInSpeed) {
            e.multiplier = 2;
        }
    }

    @SubscribeEvent
    public void onLeftClick(PlayerLeftClickEvent e) {
        EntityPlayer player = e.entityPlayer;
        SpeedsterPlayerData data = SpeedsterPlayerData.get(player);
        if (SHConfig.abilities.get(SpeedsterAbility.lightningThrowing).booleanValue() && data.isInSpeed) {
            boolean isMoving = data.isMoving;
            SpeedsterType type = SpeedsterHeroesUtil.getSpeedsterType((EntityLivingBase)player);
            if (!player.field_70170_p.field_72995_K && isMoving && !player.field_70122_E && SpeedsterAbility.lightningThrowing.canBeUsed(player, type, data.level) && player.func_70694_bm() == null) {
                Vec3 v1 = new Vec3((double)-10.6f, 0.0, 0.0);
                Vec3 v2 = v1.func_178785_b(-player.field_70177_z * (float)Math.PI / 180.0f);
                for (int i = 0; i < 3; ++i) {
                    player.field_70170_p.func_72838_d((Entity)new EntityLightning(player.field_70170_p, (EntityLivingBase)player, type, player.field_70165_t + v2.field_72450_a, player.field_70163_u + (double)(player.field_70131_O / 1.8f * 0.8f), player.field_70161_v + v2.field_72449_c));
                }
            }
        }
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent e) {
        if (SpeedsterHeroesUtil.isEntityAvailableForSpeedforce((Entity)e.player)) {
            SpeedsterPlayerData.get(e.player).sendDataToPlayer();
        }
    }
}

