/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.entity;

import lucraft.mods.heroes.speedsterheroes.SHConfig;
import lucraft.mods.heroes.speedsterheroes.abilities.SpeedsterAbility;
import lucraft.mods.heroes.speedsterheroes.entity.EntityDimensionBreach;
import lucraft.mods.heroes.speedsterheroes.entity.EntityTimeRemnant;
import lucraft.mods.heroes.speedsterheroes.network.MessageSyncPlayerData;
import lucraft.mods.heroes.speedsterheroes.network.PacketDispatcher;
import lucraft.mods.heroes.speedsterheroes.proxies.SpeedsterHeroesProxy;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.heroes.speedsterheroes.trailtypes.TrailTypeCustom;
import lucraft.mods.heroes.speedsterheroes.util.SHAchievements;
import lucraft.mods.heroes.speedsterheroes.util.SpeedsterAttributeModifiers;
import lucraft.mods.heroes.speedsterheroes.util.SpeedsterHeroesUtil;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SpeedsterPlayerData
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "SpeedsterHeroes";
    public final EntityPlayer player;
    public boolean hasSpeedforce;
    public boolean isInSpeed;
    public int speedLevel;
    public int level;
    public float traveledBlocks;
    public int speedsterPoints;
    public int extraSpeedLevels;
    public boolean isWallRunning;
    public boolean phasingActive;
    public int v9Duration;
    public int v9Timer;
    public TrailTypeCustom customTrailType;
    public float prevStepHeight;
    public int updateCooldown = 20;
    public boolean isMoving = false;

    public SpeedsterPlayerData(EntityPlayer player) {
        this.player = player;
        this.hasSpeedforce = false;
        this.isInSpeed = false;
        this.speedLevel = 1;
        this.level = 1;
        this.customTrailType = new TrailTypeCustom("");
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new SpeedsterPlayerData(player));
    }

    public static final SpeedsterPlayerData get(EntityPlayer player) {
        return (SpeedsterPlayerData)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74757_a("hasSpeedforce", this.hasSpeedforce);
        properties.func_74757_a("isInSpeed", this.isInSpeed);
        properties.func_74768_a("velocityPoints", this.speedLevel);
        properties.func_74776_a("traveledBlocks", this.traveledBlocks);
        properties.func_74768_a("speedsterLevel", this.level);
        properties.func_74768_a("speedsterPoints", this.speedsterPoints);
        properties.func_74768_a("extraSpeedLevels", this.extraSpeedLevels);
        properties.func_74768_a("extrv9DurationaSpeedLevels", this.v9Duration);
        properties.func_74768_a("v9Timer", this.v9Timer);
        properties.func_74757_a("phasingActive", this.phasingActive);
        this.customTrailType.saveToNBT(properties);
        compound.func_74782_a(EXT_PROP_NAME, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(EXT_PROP_NAME);
        this.hasSpeedforce = properties.func_74767_n("hasSpeedforce");
        this.isInSpeed = properties.func_74767_n("isInSpeed");
        this.speedLevel = properties.func_74762_e("velocityPoints");
        this.traveledBlocks = properties.func_74760_g("traveledBlocks");
        this.level = properties.func_74762_e("speedsterLevel");
        this.speedsterPoints = properties.func_74762_e("speedsterPoints");
        this.extraSpeedLevels = properties.func_74762_e("extraSpeedLevels");
        this.v9Duration = properties.func_74762_e("extrv9DurationaSpeedLevels");
        this.v9Timer = properties.func_74762_e("v9Timer");
        this.phasingActive = properties.func_74767_n("phasingActive");
        this.customTrailType.loadFromNBT(properties);
        if (this.level == 0) {
            this.level = 1;
        }
    }

    public void sendDataToPlayer() {
        this.sendDataToPlayer(this.player);
    }

    public void sendDataToPlayer(EntityPlayer toPlayer) {
        if (toPlayer instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new MessageSyncPlayerData(this.player), (EntityPlayerMP)toPlayer);
        }
    }

    public void sendDataToAllPlayers() {
        PacketDispatcher.sendToAllAround(new MessageSyncPlayerData(this.player), this.player, 100.0);
    }

    public void init(Entity entity, World world) {
    }

    public void setSpeedLevel(int i) {
        this.speedLevel = i;
        if (i <= 0) {
            this.speedLevel = 1;
        }
        this.sendDataToPlayer();
    }

    public void increaseDecreaseSpeedLevel(boolean faster) {
        if (this.isInSpeed) {
            int newPoints = this.speedLevel + (faster ? 1 : -1);
            if (newPoints > SpeedsterHeroesUtil.getSpeedLevels(this.player) || newPoints < 1) {
                return;
            }
            this.setSpeedLevel(newPoints);
            this.applySpeedLevel(this.speedLevel);
        }
    }

    public void toggleSpeedForce(boolean hasSpeedforce) {
        this.hasSpeedforce = hasSpeedforce;
        if (!hasSpeedforce) {
            this.isInSpeed = false;
            this.resetSpeed();
        } else {
            this.player.func_71029_a((StatBase)SHAchievements.becomeSpeedster);
        }
        this.sendDataToAllPlayers();
    }

    public void toggleSpeedForce() {
        this.toggleSpeedForce(!this.hasSpeedforce);
    }

    public void applySpeedLevel(int i) {
        this.resetSpeed();
        this.player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(SpeedsterAttributeModifiers.getSpeedsterAttributeModifier(i));
        this.isInSpeed = true;
    }

    public void toggleSpeed(int i) {
        if (this.isAbleForSpeed()) {
            if (this.isInSpeed) {
                this.resetSpeed();
            } else {
                this.setSpeedLevel(i);
                this.applySpeedLevel(this.speedLevel);
            }
            this.sendDataToAllPlayers();
        }
    }

    public void setPhasingActive(boolean active) {
        this.phasingActive = active;
        this.sendDataToAllPlayers();
    }

    public void startVelocity9(int seconds) {
        this.v9Duration = seconds;
        this.v9Timer = 20;
        this.sendDataToAllPlayers();
    }

    public void spawnSpeedMirage() {
        EntityTimeRemnant remnant = new EntityTimeRemnant(this.player.field_70170_p, this.player);
        remnant.func_152115_b(this.player.func_110124_au().toString());
        remnant.func_70903_f(true);
        BlockPos pos = SpeedsterHeroesUtil.getRandomPositionInNear(this.player.field_70170_p, new BlockPos((Entity)this.player), 10);
        EntityDimensionBreach breach = new EntityDimensionBreach(this.player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), EntityDimensionBreach.BreachActionTypes.SPAWN_ENTITY);
        breach.entityToSpawn = remnant;
        if (!this.player.field_70170_p.field_72995_K) {
            this.player.field_70170_p.func_72838_d((Entity)breach);
        }
    }

    public void spawnDimensionBreach() {
        double x = this.player.func_70040_Z().field_72450_a * 30.0;
        double z = this.player.func_70040_Z().field_72449_c * 30.0;
        BlockPos pos = new BlockPos(this.player.field_70165_t + (double)(this.player.field_70130_N / 2.0f) + x, this.player.field_70163_u, this.player.field_70161_v + (double)(this.player.field_70130_N / 2.0f) + z);
        if (!this.player.field_70170_p.func_175623_d(pos)) {
            return;
        }
        EntityDimensionBreach breach = new EntityDimensionBreach(this.player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), EntityDimensionBreach.BreachActionTypes.PORTAL);
        if (!this.player.field_70170_p.field_72995_K) {
            this.player.field_70170_p.func_72838_d((Entity)breach);
        }
    }

    public void resetSpeed() {
        for (int i = 0; i < 30; ++i) {
            this.player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(SpeedsterAttributeModifiers.getSpeedsterAttributeModifier(i + 1));
        }
        this.isInSpeed = false;
    }

    public boolean isAbleForSpeed() {
        return this.hasSpeedforce || SpeedsterHeroesUtil.isVelocity9Active((EntityLivingBase)this.player);
    }

    public void onUpdate(TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.END) {
            this.player.field_70138_W = this.prevStepHeight;
            return;
        }
        this.prevStepHeight = this.player.field_70138_W;
        if (this.v9Duration > 0) {
            this.player.func_70690_d(new PotionEffect(SpeedsterHeroesProxy.velocity9.field_76415_H, this.v9Duration * 20));
            if (!this.hasSpeedforce) {
                this.isInSpeed = true;
                int maxSpeedLevels = SpeedsterHeroesUtil.getSpeedLevels(this.player);
                if (this.speedLevel != maxSpeedLevels) {
                    this.setSpeedLevel(maxSpeedLevels);
                    this.applySpeedLevel(this.speedLevel);
                }
            }
            if (this.v9Timer <= 0) {
                int remaining = SpeedsterHeroesUtil.getRemainingVelocity9Duration((EntityLivingBase)this.player);
                if (SHConfig.velocity9Poison) {
                    if (remaining < 40) {
                        this.player.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 1200, 2));
                    } else if (remaining == 1200 || remaining == 600 || remaining == 200 || remaining == 3600) {
                        this.player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 40, 0));
                    }
                }
                --this.v9Duration;
                this.v9Timer = 20;
            } else {
                --this.v9Timer;
            }
        }
        if (this.updateCooldown > 0) {
            this.sendDataToAllPlayers();
            --this.updateCooldown;
        }
        if (this.isInSpeed) {
            if (this.isAbleForSpeed()) {
                int maxSpeedLevels;
                boolean isMoving;
                SpeedsterType type = SpeedsterHeroesUtil.getSpeedsterType((EntityLivingBase)this.player);
                this.isMoving = isMoving = SpeedsterHeroesUtil.isMoving((EntityLivingBase)this.player);
                boolean isSprinting = this.player.func_70051_ag();
                float walkedDifference = this.player.field_70140_Q / 0.6f - this.player.field_70141_P / 0.6f;
                this.traveledBlocks += walkedDifference;
                if (this.player.func_110143_aJ() < this.player.func_110138_aP()) {
                    this.player.func_70691_i(0.05f);
                }
                if (SHConfig.frictionBurn && this.player.field_70122_E && walkedDifference > 1.28f && type == null && !this.player.field_71075_bZ.field_75098_d) {
                    this.player.func_70015_d(10);
                    this.player.func_71029_a((StatBase)SHAchievements.frictionBurn);
                }
                if (this.traveledBlocks > (float)SpeedsterHeroesUtil.getMetersForLevel(this.level + 1) && this.level < 30) {
                    ++this.level;
                    this.traveledBlocks = 0.0f;
                    this.speedsterPoints += SpeedsterHeroesUtil.getSpeedsterPointsForLevel(this.level);
                    if (this.player.field_70170_p.field_72995_K) {
                        this.player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"speedsterheroes.info.levelup").replace("%L", "" + EnumChatFormatting.GOLD + this.level + EnumChatFormatting.YELLOW) + EnumChatFormatting.RED + "  +" + SpeedsterHeroesUtil.getSpeedsterPointsForLevel(this.level) + " " + StatCollector.func_74838_a((String)"speedsterheroes.info.speedsterpoints")));
                        this.player.func_85030_a("random.levelup", 1.0f, 1.0f);
                    }
                }
                this.player.field_70138_W = MathHelper.func_76131_a((float)((float)this.speedLevel / 2.0f), (float)0.5f, (float)3.0f);
                if (SHConfig.abilities.get(SpeedsterAbility.wallRunning).booleanValue()) {
                    if (this.player.field_70123_F && !this.player.field_70124_G && SpeedsterAbility.wallRunning.canBeUsed(this.player, type, this.level)) {
                        this.player.field_70181_x = MathHelper.func_76131_a((float)((float)this.speedLevel / 6.0f), (float)0.5f, (float)2.0f);
                        this.isWallRunning = true;
                    } else if (this.isWallRunning) {
                        this.isWallRunning = false;
                        this.player.field_70181_x = 0.2f;
                    }
                }
                if (SHConfig.abilities.get(SpeedsterAbility.waterRunning).booleanValue() && isMoving && SpeedsterAbility.waterRunning.canBeUsed(this.player, type, this.level) && this.speedLevel >= 5 && this.player.field_70170_p.func_180495_p(this.player.func_180425_c().func_177982_a(0, -1, 0)).func_177230_c() instanceof BlockLiquid && isSprinting) {
                    this.player.field_70163_u -= this.player.field_70181_x;
                    this.player.field_70181_x = 0.0;
                    this.player.field_70143_R = 0.0f;
                    this.player.field_70122_E = true;
                }
                if (SHConfig.abilities.get(SpeedsterAbility.phasing).booleanValue()) {
                    if (!this.player.field_70170_p.field_72995_K && this.phasingActive && !this.player.field_70170_p.func_175665_u(new BlockPos(this.player.field_70165_t, this.player.field_70163_u - (double)0.1f, this.player.field_70161_v))) {
                        this.setPhasingActive(false);
                    }
                    if (!this.player.field_70170_p.field_72995_K && !SpeedsterAbility.phasing.canBeUsed(this.player, type, this.level)) {
                        this.setPhasingActive(false);
                    }
                }
                if (this.speedLevel > (maxSpeedLevels = SpeedsterHeroesUtil.getSpeedLevels(this.player))) {
                    this.setSpeedLevel(maxSpeedLevels);
                    this.applySpeedLevel(maxSpeedLevels);
                    this.sendDataToPlayer();
                }
            } else {
                this.resetSpeed();
                this.sendDataToAllPlayers();
            }
        } else if (this.isWallRunning) {
            this.isWallRunning = false;
        }
    }
}

