/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lucraft.mods.heroes.speedsterheroes.SpeedsterHeroes;
import lucraft.mods.heroes.speedsterheroes.abilities.SpeedsterAbility;
import lucraft.mods.heroes.speedsterheroes.client.models.ModelAdvancedBiped;
import lucraft.mods.heroes.speedsterheroes.entity.EntityTimeRemnant;
import lucraft.mods.heroes.speedsterheroes.entity.SpeedsterPlayerData;
import lucraft.mods.heroes.speedsterheroes.proxies.SpeedsterHeroesProxy;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.IAutoSpeedsterRecipe;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.IAutoSpeedsterRecipeAdvanced;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.lucraftcore.client.LucraftCoreKeyBindings;
import lucraft.mods.lucraftcore.client.render.IRenderFirstPersonHand;
import lucraft.mods.lucraftcore.util.IFakePlayerEntity;
import lucraft.mods.lucraftcore.util.IShiftableItemToolTip;
import lucraft.mods.lucraftcore.util.LucraftCoreClientUtil;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpeedsterArmor
extends ItemArmor
implements IRenderFirstPersonHand,
IShiftableItemToolTip,
ISpecialArmor {
    public static ArrayList<ItemSpeedsterArmor> armorToCraft = new ArrayList();
    private SpeedsterType type;
    protected String itemName;

    public ItemSpeedsterArmor(SpeedsterType type, int armorSlot) {
        super(ItemArmor.ArmorMaterial.CHAIN, 0, armorSlot);
        this.itemName = type.getName().toLowerCase() + this.getArmorSlotName(armorSlot);
        this.func_77655_b(this.itemName);
        if (type.showInCreativeTab()) {
            this.func_77637_a(SpeedsterHeroesProxy.tabSpeedsterArmor);
        } else {
            this.func_77637_a(null);
        }
        this.type = type;
        if (type instanceof IAutoSpeedsterRecipe || type instanceof IAutoSpeedsterRecipeAdvanced) {
            armorToCraft.add(this);
        }
        if (armorSlot == 0) {
            type.helmet = new ItemStack((Item)this);
        } else if (armorSlot == 1) {
            type.chestplate = new ItemStack((Item)this);
        } else if (armorSlot == 2) {
            type.legs = new ItemStack((Item)this);
        } else if (armorSlot == 3) {
            type.boots = new ItemStack((Item)this);
        }
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public String getArmorSlotName(int i) {
        switch (i) {
            case 0: {
                return "Helmet";
            }
            case 1: {
                return "Chestplate";
            }
            case 2: {
                return "Legs";
            }
        }
        return "Boots";
    }

    public SpeedsterType getSpeedsterType() {
        return this.type;
    }

    public String getSpeedsterArmorTexture(ItemStack stack, Entity entity, int slot, boolean light, boolean smallArms) {
        return "SpeedsterHeroes:textures/models/armor/" + this.type.getName().toLowerCase() + "/armor_" + (slot == 2 ? "2" : "1") + (slot == 3 && smallArms ? "_smallArms" : "") + (light ? "_lights" : "") + ".png";
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        boolean smallArms = false;
        if (entity instanceof EntityPlayer) {
            smallArms = LucraftCoreClientUtil.hasSmallArms((EntityPlayer)((EntityPlayer)entity));
        } else if (entity instanceof EntityTimeRemnant && ((EntityTimeRemnant)entity).func_70902_q() != null) {
            smallArms = LucraftCoreClientUtil.hasSmallArms((EntityPlayer)((EntityPlayer)((EntityTimeRemnant)entity).func_70902_q()));
        }
        return this.getSpeedsterArmorTexture(stack, entity, slot, false, smallArms);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getSpeedsterArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        boolean smallArms = false;
        if (entityLiving instanceof IFakePlayerEntity) {
            smallArms = false;
        } else if (entityLiving instanceof EntityPlayer) {
            smallArms = LucraftCoreClientUtil.hasSmallArms((EntityPlayer)((EntityPlayer)entityLiving));
        } else if (entityLiving instanceof EntityTimeRemnant && ((EntityTimeRemnant)entityLiving).func_70902_q() != null) {
            smallArms = LucraftCoreClientUtil.hasSmallArms((EntityPlayer)((EntityPlayer)((EntityTimeRemnant)entityLiving).func_70902_q()));
        }
        return new ModelAdvancedBiped(this.getSpeedsterType().getArmorModelScale(armorSlot), this.getSpeedsterArmorTexture(itemStack, (Entity)entityLiving, armorSlot, false, smallArms), this.getSpeedsterArmorTexture(itemStack, (Entity)entityLiving, armorSlot, true, smallArms), this.getSpeedsterType(), smallArms);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ModelBiped _default) {
        ModelBiped armorModel = null;
        if (itemStack != null && (armorModel = this.getSpeedsterArmorModel(entityLiving, itemStack, armorSlot)) != null) {
            armorModel.func_178686_a((ModelBase)_default);
            return armorModel;
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    public HashMap<ModelBiped, Object[]> getFirstPersonModels(ItemStack stack, EntityPlayer player, int armorSlot, boolean smallArms) {
        HashMap<ModelBiped, Object[]> map = new HashMap<ModelBiped, Object[]>();
        map.put(this.getSpeedsterArmorModel((EntityLivingBase)player, stack, armorSlot), new Object[]{this.getSpeedsterArmorTexture(stack, (Entity)player, armorSlot, false, smallArms), false});
        if (this.getSpeedsterType().hasGlowyThings((EntityLivingBase)player, SpeedsterPlayerData.get((EntityPlayer)player).isInSpeed)) {
            map.put(this.getSpeedsterArmorModel((EntityLivingBase)player, stack, armorSlot), new Object[]{this.getSpeedsterArmorTexture(stack, (Entity)player, armorSlot, true, smallArms), true});
        }
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getShiftableToolTip(ItemStack stack, EntityPlayer player) {
        ArrayList<String> list = new ArrayList<String>();
        String space = "   ";
        list.add("");
        list.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"speedsterheroes.info.trail") + EnumChatFormatting.GOLD + ": " + EnumChatFormatting.GRAY + this.getSpeedsterType().getTrailType().getDisplayName());
        String extraSpeedLevel = this.getSpeedsterType().getExtraSpeedLevel(this.getSpeedsterType(), player) > 0 ? "+" + this.getSpeedsterType().getExtraSpeedLevel(this.getSpeedsterType(), player) : (this.getSpeedsterType().getExtraSpeedLevel(this.getSpeedsterType(), player) == 0 ? "0" : "" + this.getSpeedsterType().getExtraSpeedLevel(this.getSpeedsterType(), player));
        list.add("");
        list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"speedsterheroes.info.extraspeedlevel") + EnumChatFormatting.DARK_RED + ": " + EnumChatFormatting.GRAY + extraSpeedLevel);
        if (this.getSpeedsterType().getAbilities().size() > 0) {
            list.add("");
            list.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"speedsterheroes.info.abilities") + EnumChatFormatting.DARK_BLUE + ":");
            for (SpeedsterAbility ab : this.getSpeedsterType().getAbilities()) {
                if (ab == null) continue;
                list.add(space + EnumChatFormatting.DARK_GRAY + "- " + (SpeedsterHeroes.proxy.hasAchievement(player, ab.getAchievement()) ? EnumChatFormatting.GREEN : EnumChatFormatting.RED) + ab.getDisplayName());
            }
        }
        return list;
    }

    public String getArmorActionsToolTipForType(ItemStack stack, EntityPlayer player, LucraftCoreKeyBindings.LucraftKeyTypes type) {
        String nothing = "/";
        switch (type) {
            case ARMOR_1: {
                return this.getSpeedsterType().hasAbility(SpeedsterAbility.phasing) ? SpeedsterAbility.phasing.getTranslationName() : nothing;
            }
            case ARMOR_2: {
                return this.getSpeedsterType().hasAbility(SpeedsterAbility.timeRemnant) ? SpeedsterAbility.timeRemnant.getTranslationName() : nothing;
            }
            case ARMOR_3: {
                return this.getSpeedsterType().hasAbility(SpeedsterAbility.slowmo) ? SpeedsterAbility.slowmo.getTranslationName() : nothing;
            }
            case ARMOR_5: {
                return StatCollector.func_74838_a((String)"speedsterheroes.info.putsuitinring");
            }
        }
        return nothing;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        if (this.getSpeedsterType().hasExtraDescription(playerIn)) {
            tooltip.add(this.getSpeedsterType().getExtraDescription(playerIn));
        }
    }

    public boolean shouldRenderShiftableToolTip(ItemStack stack, EntityPlayer player) {
        return true;
    }

    public boolean shouldRenderArmorActionsToolTip(ItemStack stack, EntityPlayer player) {
        return true;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        slot = 3 - slot;
        float reduceAmount = ItemArmor.ArmorMaterial.CHAIN.func_78044_b(slot) + (armor.func_77942_o() ? armor.func_77978_p().func_74762_e("plateAmount") * 2 : 0);
        return new ISpecialArmor.ArmorProperties(0, (double)reduceAmount / 25.0, Integer.MAX_VALUE);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)(this.getProperties((EntityLivingBase)player, (ItemStack)armor, null, (double)0.0, (int)slot).AbsorbRatio * 25.0);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        slot = 3 - slot;
        float d = (float)damage / 4.0f;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((d /= (float)(stack.func_77978_p().func_74762_e("plateAmount") + 1)) < 1.0f) {
            d = 1.0f;
        }
        stack.func_77972_a((int)d, entity);
        if (stack.field_77994_a == 0) {
            stack = null;
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.type.getIsRepairable(toRepair, repair);
    }
}

