/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.items;

import lucraft.mods.heroes.speedsterheroes.client.models.ModelJayGarrickHelm;
import lucraft.mods.heroes.speedsterheroes.client.models.ModelTheRivalEars;
import lucraft.mods.heroes.speedsterheroes.items.ItemSpeedsterArmor;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpeedsterHelmet
extends ItemSpeedsterArmor {
    public ItemSpeedsterHelmet(SpeedsterType type) {
        super(type, 0);
    }

    @Override
    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        this.onCreated(stack);
    }

    public void onCreated(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("helmetOpen", false);
            stack.func_77982_d(compound);
        }
    }

    public boolean isHelmetOpen(ItemStack stack) {
        this.onCreated(stack);
        return stack.func_77978_p().func_74767_n("helmetOpen");
    }

    public ItemStack setHelmetOpen(ItemStack stack, boolean open) {
        this.onCreated(stack);
        NBTTagCompound compound = stack.func_77978_p();
        compound.func_74757_a("helmetOpen", open);
        stack.func_77982_d(compound);
        return stack;
    }

    public static ItemStack toggleHelmet(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemSpeedsterHelmet) {
            ItemSpeedsterHelmet item = (ItemSpeedsterHelmet)stack.func_77973_b();
            if (!item.getSpeedsterType().canOpenHelmet()) {
                return stack;
            }
            item.onCreated(stack);
            return item.setHelmetOpen(stack, !item.isHelmetOpen(stack));
        }
        return stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getSpeedsterArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (this.getSpeedsterType() == SpeedsterType.jayGarrick) {
            return new ModelJayGarrickHelm(0.55f, this.getSpeedsterArmorTexture(itemStack, (Entity)entityLiving, armorSlot, false, false));
        }
        if (this.getSpeedsterType() == SpeedsterType.theRival) {
            return new ModelTheRivalEars(0.55f, this.getSpeedsterArmorTexture(itemStack, (Entity)entityLiving, armorSlot, false, false), this.getSpeedsterArmorTexture(itemStack, (Entity)entityLiving, armorSlot, true, false), this.getSpeedsterType(), false);
        }
        return super.getSpeedsterArmorModel(entityLiving, itemStack, armorSlot);
    }

    @Override
    public String getSpeedsterArmorTexture(ItemStack stack, Entity entity, int slot, boolean light, boolean smallArms) {
        String texture = "SpeedsterHeroes:textures/models/armor/" + this.getSpeedsterType().getName().toLowerCase() + "/helmet";
        if (this.isHelmetOpen(stack)) {
            texture = texture + "_open";
        }
        if (light) {
            texture = texture + "_lights";
        }
        return texture + ".png";
    }
}

