/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import lucraft.mods.heroes.speedsterheroes.SHConfig;
import lucraft.mods.heroes.speedsterheroes.SpeedsterHeroes;
import lucraft.mods.heroes.speedsterheroes.abilities.SpeedsterAbility;
import lucraft.mods.heroes.speedsterheroes.entity.EntityDimensionBreach;
import lucraft.mods.heroes.speedsterheroes.entity.SpeedsterPlayerData;
import lucraft.mods.heroes.speedsterheroes.items.ItemRing;
import lucraft.mods.heroes.speedsterheroes.items.ItemSpeedsterHelmet;
import lucraft.mods.heroes.speedsterheroes.items.SHItems;
import lucraft.mods.heroes.speedsterheroes.network.AbstractServerMessageHandler;
import lucraft.mods.heroes.speedsterheroes.network.MessageSendInfoToClient;
import lucraft.mods.heroes.speedsterheroes.network.PacketDispatcher;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.heroes.speedsterheroes.util.SpeedsterHeroesUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSendInfoToServer
implements IMessage {
    public InfoType type;
    public int info;
    public static HashMap<Integer, InfoType> ids = new HashMap();

    public MessageSendInfoToServer() {
    }

    public MessageSendInfoToServer(InfoType type) {
        this.type = type;
        this.info = 0;
    }

    public MessageSendInfoToServer(InfoType type, int i) {
        this.type = type;
        this.info = i;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = InfoType.getInfoTypeFromId(buf.readInt());
        this.info = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.info);
    }

    public static enum InfoType {
        SPEED,
        HELMET,
        LEVELING_GUI,
        BUY_ABILITY,
        BUY_EXTRASPEEDLEVEL,
        PHASING,
        SLOWMO,
        TIMEREMNANT,
        DIMENSION_BREACH,
        DIMENSION_BREACH_CANCEL,
        DIMENSION_BREACH_TELEPORT,
        TRAIL,
        RING;


        private InfoType() {
            ids.put(this.ordinal(), this);
        }

        public static InfoType getInfoTypeFromId(int id) {
            return ids.get(id);
        }
    }

    public static class Handler
    extends AbstractServerMessageHandler<MessageSendInfoToServer> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, MessageSendInfoToServer message, MessageContext ctx) {
            InfoType type = message.type;
            SpeedsterPlayerData data = SpeedsterPlayerData.get(player);
            SpeedsterType speedsterType = SpeedsterHeroesUtil.getSpeedsterType((EntityLivingBase)player);
            switch (type) {
                case HELMET: {
                    if (!SpeedsterHeroesUtil.hasHelmetOn((EntityLivingBase)player)) break;
                    ItemSpeedsterHelmet.toggleHelmet(player.func_82169_q(3));
                    break;
                }
                case SPEED: {
                    data.toggleSpeed(1);
                    break;
                }
                case LEVELING_GUI: {
                    data.sendDataToPlayer();
                    PacketDispatcher.sendTo(new MessageSendInfoToClient(MessageSendInfoToClient.InfoType.LEVELING), (EntityPlayerMP)player);
                    player.openGui((Object)SpeedsterHeroes.instance, 1, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    break;
                }
                case BUY_ABILITY: {
                    SpeedsterAbility ab = SpeedsterAbility.abilities.get(message.info);
                    if (SHConfig.abilities.containsKey(ab) && !SHConfig.abilities.get(ab).booleanValue()) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("speedsterheroes.info.abilitydisabled", new Object[0]));
                        break;
                    }
                    if (data.level < ab.getRequiredLevel(player) || data.speedsterPoints < ab.getRequiredSpeedsterPoints(player)) break;
                    data.speedsterPoints -= ab.getRequiredSpeedsterPoints(player);
                    player.func_71029_a((StatBase)ab.getAchievement());
                    data.sendDataToPlayer();
                    break;
                }
                case PHASING: {
                    if (message.info == 1) {
                        if (!SpeedsterAbility.phasing.canBeUsed(player, speedsterType, data.level)) break;
                        data.setPhasingActive(true);
                        break;
                    }
                    if (message.info != 0 || !data.phasingActive) break;
                    data.setPhasingActive(false);
                    break;
                }
                case TIMEREMNANT: {
                    if (!SHConfig.abilities.get(SpeedsterAbility.timeRemnant).booleanValue() || player.field_70170_p.field_72995_K || !SpeedsterHeroesUtil.hasArmorOn((EntityLivingBase)player) || !SpeedsterAbility.timeRemnant.canBeUsed(player, speedsterType, data.level) || !data.isInSpeed || data.speedLevel < 8 || !player.func_70051_ag()) break;
                    data.spawnSpeedMirage();
                    break;
                }
                case DIMENSION_BREACH: {
                    break;
                }
                case DIMENSION_BREACH_CANCEL: {
                    if (player.field_70154_o == null || !(player.field_70154_o instanceof EntityDimensionBreach)) break;
                    ((EntityDimensionBreach)player.field_70154_o).startDespawn();
                    break;
                }
                case DIMENSION_BREACH_TELEPORT: {
                    player.func_70078_a(null);
                    break;
                }
                case BUY_EXTRASPEEDLEVEL: {
                    if (data.extraSpeedLevels >= 5 || data.speedsterPoints < 5) break;
                    data.speedsterPoints -= 5;
                    ++data.extraSpeedLevels;
                    data.sendDataToPlayer();
                    break;
                }
                case TRAIL: {
                    data.sendDataToPlayer();
                    player.openGui((Object)SpeedsterHeroes.instance, 4, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    break;
                }
                case RING: {
                    ItemStack chest;
                    if (SpeedsterHeroesUtil.getSpeedsterType((EntityLivingBase)player) == null || !(chest = player.func_71124_b(3)).func_77942_o() || !chest.func_77978_p().func_74767_n("hasRing")) break;
                    ItemStack ring = new ItemStack(SHItems.ring);
                    ItemRing.setArmorIn(ring, player.func_71124_b(4), player.func_71124_b(3), player.func_71124_b(2), player.func_71124_b(1));
                    player.func_70062_b(1, null);
                    player.func_70062_b(2, null);
                    player.func_70062_b(3, null);
                    player.func_70062_b(4, null);
                    player.field_71071_by.func_70441_a(ring);
                    break;
                }
            }
            return null;
        }
    }
}

