/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.network;

import lucraft.mods.heroes.speedsterheroes.network.MessageChangeVelocity;
import lucraft.mods.heroes.speedsterheroes.network.MessagePlayerSyncRequest;
import lucraft.mods.heroes.speedsterheroes.network.MessageSendInfoToClient;
import lucraft.mods.heroes.speedsterheroes.network.MessageSendInfoToServer;
import lucraft.mods.heroes.speedsterheroes.network.MessageSendTrailToServer;
import lucraft.mods.heroes.speedsterheroes.network.MessageSyncPlayerData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketDispatcher {
    private static byte packetId = 0;
    private static final SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("SpeedsterHeroes");

    public static final void registerPackets() {
        PacketDispatcher.registerMessage(MessageSendInfoToServer.Handler.class, MessageSendInfoToServer.class, Side.SERVER);
        PacketDispatcher.registerMessage(MessageSendInfoToClient.Handler.class, MessageSendInfoToClient.class, Side.CLIENT);
        PacketDispatcher.registerMessage(MessageChangeVelocity.Handler.class, MessageChangeVelocity.class, Side.SERVER);
        PacketDispatcher.registerMessage(MessagePlayerSyncRequest.Handler.class, MessagePlayerSyncRequest.class, Side.SERVER);
        PacketDispatcher.registerMessage(MessageSyncPlayerData.Handler.class, MessageSyncPlayerData.class, Side.CLIENT);
        PacketDispatcher.registerMessage(MessageSendTrailToServer.Handler.class, MessageSendTrailToServer.class, Side.SERVER);
    }

    private static final void registerMessage(Class handlerClass, Class messageClass, Side side) {
        byte by = packetId;
        packetId = (byte)(by + 1);
        dispatcher.registerMessage(handlerClass, messageClass, (int)by, side);
    }

    public static final void sendTo(IMessage message, EntityPlayerMP player) {
        dispatcher.sendTo(message, player);
    }

    public static final void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        dispatcher.sendToAllAround(message, point);
    }

    public static final void sendToAll(IMessage message) {
        dispatcher.sendToAll(message);
    }

    public static final void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        PacketDispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static final void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        PacketDispatcher.sendToAllAround(message, player.field_70170_p.field_73011_w.func_177502_q(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public static final void sendToDimension(IMessage message, int dimensionId) {
        dispatcher.sendToDimension(message, dimensionId);
    }

    public static final void sendToServer(IMessage message) {
        dispatcher.sendToServer(message);
    }
}

