/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.trailtypes;

import java.util.Random;
import lucraft.mods.heroes.speedsterheroes.client.render.SpeedTrailRenderer;
import lucraft.mods.heroes.speedsterheroes.trailtypes.TrailType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;

public class TrailTypeCustom
extends TrailType {
    public String renderer;
    public boolean specialColor;
    public Random rand;

    public TrailTypeCustom(String name) {
        super(name);
        this.setTrailColor(1.0f, 1.0f, 1.0f);
        this.setMirageColor(1.0f, 1.0f, 1.0f);
        this.setMiragesColorMasks(true, true, true);
        this.renderer = "normal";
        this.specialColor = false;
        this.rand = new Random();
    }

    @Override
    public String getDisplayName() {
        return StatCollector.func_74838_a((String)"speedsterheroes.trailtype.custom.name");
    }

    @Override
    public Vec3 getTrailColor() {
        return this.specialColor ? new Vec3(this.rand.nextDouble(), this.rand.nextDouble(), this.rand.nextDouble()) : super.getTrailColor();
    }

    @Override
    public Vec3 getMirageColor() {
        return this.specialColor ? new Vec3(this.rand.nextDouble(), this.rand.nextDouble(), this.rand.nextDouble()) : super.getMirageColor();
    }

    @Override
    public SpeedTrailRenderer getSpeedTrailRenderer() {
        if (this.renderer.equalsIgnoreCase("lightnings")) {
            return TrailType.renderer_lightnings;
        }
        if (this.renderer.equalsIgnoreCase("electricity")) {
            return TrailType.renderer_electricity;
        }
        if (this.renderer.equalsIgnoreCase("particles")) {
            return TrailType.renderer_particles;
        }
        return TrailType.renderer_normal;
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        this.renderer = nbt.func_74779_i("renderer");
        this.setTrailColor(nbt.func_74760_g("1red"), nbt.func_74760_g("1green"), nbt.func_74760_g("1blue"));
        this.setMirageColor(nbt.func_74760_g("2red"), nbt.func_74760_g("2green"), nbt.func_74760_g("2blue"));
        this.specialColor = nbt.func_74767_n("specialColors");
    }

    public void saveToNBT(NBTTagCompound nbt) {
        boolean prevSpecialColor = this.specialColor;
        this.specialColor = false;
        nbt.func_74778_a("renderer", this.renderer);
        nbt.func_74776_a("1red", (float)this.trailColor.field_72450_a);
        nbt.func_74776_a("1green", (float)this.trailColor.field_72448_b);
        nbt.func_74776_a("1blue", (float)this.trailColor.field_72449_c);
        nbt.func_74776_a("2red", (float)this.mirageColor.field_72450_a);
        nbt.func_74776_a("2green", (float)this.mirageColor.field_72448_b);
        nbt.func_74776_a("2blue", (float)this.mirageColor.field_72449_c);
        this.specialColor = prevSpecialColor;
        nbt.func_74757_a("specialColors", this.specialColor);
    }
}

