/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lucraft.mods.heroes.speedsterheroes.entity.EntitySpeedMirage;
import lucraft.mods.heroes.speedsterheroes.entity.EntityTimeRemnant;
import lucraft.mods.heroes.speedsterheroes.entity.SpeedsterPlayerData;
import lucraft.mods.heroes.speedsterheroes.items.InventorySpeedsterSuit;
import lucraft.mods.heroes.speedsterheroes.items.ItemSpeedsterArmor;
import lucraft.mods.heroes.speedsterheroes.items.ItemSpeedsterHelmet;
import lucraft.mods.heroes.speedsterheroes.items.SHItems;
import lucraft.mods.heroes.speedsterheroes.proxies.SpeedsterHeroesProxy;
import lucraft.mods.heroes.speedsterheroes.render.speedlevelbars.SpeedLevelBar;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.lucraftcore.modhelpers.speedsterheroes.ISpeedsterSuitUpgrade;
import lucraft.mods.lucraftcore.util.IFakePlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class SpeedsterHeroesUtil {
    public static Random rand = new Random();
    public static final int defaultSpeedLevelWithSpeedforce = 5;
    public static final int extraSpeedLevelVelocity9 = 3;
    public static final int extraSpeedLevelTachyon = 5;
    public static final int requiredSpeedLevelForWaterWalking = 5;
    public static final int minSpeedsterLevel = 1;
    public static final int maxSpeedsterLevel = 30;
    public static final int maxExtraSpeedLevels = 5;
    public static final int extraSpeedLevelCost = 5;
    public static final String speedLevelNormal = "normal";
    public static final String speedLevelSuit = "suit";
    public static final String speedLevelVelocity9 = "velocity9";
    public static final String speedLevelTachyon = "tachyon";
    public static final String speedLevelExtra = "extra";

    public static boolean isMoving(EntityLivingBase entity) {
        return entity.field_70140_Q / 0.6f != entity.field_70141_P / 0.6f;
    }

    public static boolean isVelocity9Active(EntityLivingBase entity) {
        return entity instanceof EntityPlayer ? SpeedsterPlayerData.get((EntityPlayer)((EntityPlayer)entity)).v9Duration > 0 : entity.func_70644_a(SpeedsterHeroesProxy.velocity9);
    }

    public static int getRemainingVelocity9Duration(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return SpeedsterPlayerData.get((EntityPlayer)((EntityPlayer)entity)).v9Duration * 20;
        }
        return 0;
    }

    public static SpeedsterType getSpeedsterType(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer || entity instanceof EntityTimeRemnant) {
            return SpeedsterHeroesUtil.hasArmorOn(entity) ? SpeedsterHeroesUtil.getSpeedsterType(entity.func_71124_b(3)) : null;
        }
        if (entity instanceof EntitySpeedMirage) {
            return SpeedsterHeroesUtil.getSpeedsterType(((EntitySpeedMirage)entity).acquired);
        }
        return null;
    }

    public static SpeedsterType getSpeedsterType(ItemStack stack) {
        if (stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemSpeedsterArmor) {
            return ((ItemSpeedsterArmor)stack.func_77973_b()).getSpeedsterType();
        }
        return null;
    }

    public static int getSpeedLevels(EntityPlayer player) {
        return SpeedsterHeroesUtil.getSpeedLevelList(player).size();
    }

    public static List<SpeedLevelBar> getSpeedLevelList(EntityPlayer player) {
        int i;
        SpeedsterType type;
        ArrayList<SpeedLevelBar> list = new ArrayList<SpeedLevelBar>();
        SpeedsterPlayerData data = SpeedsterPlayerData.get(player);
        if (data.hasSpeedforce) {
            for (int i2 = 0; i2 < 5; ++i2) {
                list.add(SpeedLevelBar.baseSpeed);
            }
        }
        if ((type = SpeedsterHeroesUtil.getSpeedsterType((EntityLivingBase)player)) != null) {
            for (i = 0; i < type.getExtraSpeedLevel(type, player); ++i) {
                list.add(SpeedLevelBar.speedsterTypeLevel);
            }
        }
        for (i = 0; i < data.extraSpeedLevels; ++i) {
            list.add(SpeedLevelBar.extraSpeed);
        }
        if (SpeedsterHeroesUtil.isVelocity9Active((EntityLivingBase)player)) {
            for (i = 0; i < 3; ++i) {
                list.add(SpeedLevelBar.velocity9Speed);
            }
        }
        if (SpeedsterHeroesUtil.hasSpeedsterSuitThisUpgrade(player.func_71124_b(3), SHItems.tachyonPrototype)) {
            for (i = 0; i < 5; ++i) {
                list.add(SpeedLevelBar.tachyonPrototypeSpeed);
            }
        }
        return list;
    }

    public static boolean hasArmorOn(EntityLivingBase entity) {
        if (entity.func_71124_b(3) != null && entity.func_71124_b(3).func_77973_b() instanceof ItemSpeedsterArmor) {
            return ((ItemSpeedsterArmor)entity.func_71124_b(3).func_77973_b()).getSpeedsterType().hasArmorOn(entity);
        }
        return false;
    }

    public static boolean hasArmorOn(EntityPlayer player, SpeedsterType type) {
        return SpeedsterHeroesUtil.hasArmorOn((EntityLivingBase)player) && ((ItemSpeedsterArmor)player.func_71124_b(3).func_77973_b()).getSpeedsterType() == type;
    }

    public static boolean hasHelmetOn(EntityLivingBase entity) {
        return entity.func_71124_b(4) != null && entity.func_71124_b(4).func_77973_b() instanceof ItemSpeedsterHelmet;
    }

    public static boolean hasSpeedsterSuitThisUpgrade(ItemStack suit, Item upgrade) {
        if (suit != null && suit.func_77973_b() instanceof ItemSpeedsterArmor) {
            if (suit.func_77978_p() == null) {
                return false;
            }
            if (upgrade == SHItems.tachyonPrototype) {
                return suit.func_77978_p().func_74767_n("hasTachyonPrototype");
            }
            InventorySpeedsterSuit inv = new InventorySpeedsterSuit(suit);
            return inv.hasItem(upgrade);
        }
        return false;
    }

    public static boolean isSpeedsterSuitUpgrade(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ISpeedsterSuitUpgrade;
    }

    public static int getMetersForLevel(int level) {
        switch (level) {
            case 1: {
                return 0;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return (level - 1) * 1000;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return 10000;
            }
            case 15: {
                return 15000;
            }
            case 16: 
            case 17: 
            case 18: {
                return 20000;
            }
            case 19: 
            case 20: {
                return 25000;
            }
            case 21: {
                return 50000;
            }
            case 22: {
                return 75000;
            }
            case 23: {
                return 100000;
            }
            case 24: {
                return 125000;
            }
            case 25: {
                return 150000;
            }
            case 26: {
                return 190000;
            }
            case 27: {
                return 20000;
            }
            case 28: {
                return 250000;
            }
            case 29: {
                return 300000;
            }
            case 30: {
                return 350000;
            }
        }
        return 0;
    }

    public static int getSpeedsterPointsForLevel(int level) {
        if (level == 5 || level == 10 || level == 15 || level == 20 || level == 25) {
            return 10;
        }
        if (level == 30) {
            return 15;
        }
        return 5;
    }

    public static boolean isEntityAvailableForSpeedforce(Entity entity) {
        return entity != null && entity instanceof EntityPlayer && !(entity instanceof IFakePlayerEntity);
    }

    public static BlockPos getRandomPositionInNear(World world, BlockPos pos, int radius) {
        return SpeedsterHeroesUtil.getRandomPositionInNear(world, pos, radius, 20);
    }

    public static BlockPos getRandomPositionInNear(World world, BlockPos pos, int radius, int tries) {
        if (tries <= 0) {
            return pos;
        }
        BlockPos newPos = new BlockPos(pos.func_177958_n() + rand.nextInt(radius) - radius / 2, pos.func_177956_o() + rand.nextInt(radius) - radius / 2, pos.func_177952_p() + rand.nextInt(radius) - radius / 2);
        while (!world.func_175665_u(newPos)) {
            newPos = newPos.func_177977_b();
        }
        if (!world.func_175665_u(newPos = newPos.func_177984_a()) && !world.func_175665_u(newPos.func_177984_a()) && newPos.func_177956_o() >= pos.func_177956_o()) {
            return newPos;
        }
        return SpeedsterHeroesUtil.getRandomPositionInNear(world, newPos, radius, tries - 1);
    }

    public static int getRecommendedAmountForArmorSlot(int armorSlot) {
        return armorSlot == 0 ? 2 : (armorSlot == 1 ? 4 : (armorSlot == 2 ? 3 : 2));
    }

    public static int getRecommendedAmountForArmorSlotWithAddition(int armorSlot, SpeedsterType type) {
        float addition = (float)type.getAbilities().size() / 2.0f + (float)type.getExtraSpeedLevel(type, null) / 5.0f;
        return (armorSlot == 0 ? 1 : (armorSlot == 1 ? 3 : (armorSlot == 2 ? 2 : 1))) + Math.round(addition);
    }

    public static List<ItemStack> getOresWithAmount(String ores, int amount) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stacks : OreDictionary.getOres((String)ores)) {
            list.add(new ItemStack(stacks.func_77973_b(), amount, stacks.func_77960_j()));
        }
        return list;
    }
}

