/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.speedsterheroes.abilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityHeld;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataFloat;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.util.events.RenderModelEvent;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.speedsterheroes.helper.SHIconHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class AbilityArmVortex
extends AbilityHeld {
    public static final AbilityData<Float> DISTANCE = new AbilityDataFloat("distance").disableSaving().setSyncType(EnumSync.SELF).enableSetting("distance", "The distance the vortex extends.");

    public AbilityArmVortex(EntityLivingBase entity) {
        super(entity);
    }

    public void registerData() {
        super.registerData();
        this.dataManager.register(DISTANCE, (Object)Float.valueOf(1.0f));
    }

    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        SHIconHelper.drawIcon(mc, gui, x, y, 0, 14);
    }

    public void updateTick() {
        for (Entity en : this.getEntities(((Float)this.getDataManager().get(DISTANCE)).floatValue())) {
            Vec3d vec = en.func_174791_d().func_178788_d(new Vec3d(this.entity.field_70165_t, this.entity.field_70163_u + (double)this.entity.func_70047_e(), this.entity.field_70161_v)).func_72432_b();
            en.field_70159_w += vec.field_72450_a / 3.0;
            en.field_70181_x += vec.field_72448_b / 3.0;
            en.field_70179_y += vec.field_72449_c / 3.0;
        }
    }

    public List<Entity> getEntities(double range) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        Random rand = new Random();
        int i = 0;
        while ((double)i < range * 2.0) {
            double d = (double)i / 2.0;
            Vec3d lookVec = this.entity.func_70040_Z();
            Vec3d pos = new Vec3d(this.entity.field_70165_t + lookVec.field_72450_a * d, this.entity.field_70163_u + (double)this.entity.func_70047_e() + lookVec.field_72448_b * d, this.entity.field_70161_v + lookVec.field_72449_c * d);
            for (Entity en : this.entity.field_70170_p.func_72872_a(Entity.class, new AxisAlignedBB(pos.field_72450_a - 0.25, pos.field_72448_b - 0.25, pos.field_72449_c - 0.25, pos.field_72450_a + 0.25, pos.field_72448_b + 0.25, pos.field_72449_c + 0.25))) {
                if (list.contains(en) || en.equals((Object)this.entity)) continue;
                list.add(en);
                if (!en.func_70027_ad()) continue;
                en.func_70066_B();
            }
            if (this.entity instanceof EntityPlayer) {
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    this.entity.field_70170_p.func_175719_a((EntityPlayer)this.entity, new BlockPos(pos), facing);
                }
            }
            if (rand.nextInt(20) == 0) {
                PlayerHelper.spawnParticleForAll((World)this.entity.field_70170_p, (double)50.0, (EnumParticleTypes)EnumParticleTypes.CLOUD, (boolean)false, (float)((float)(this.entity.field_70165_t + lookVec.field_72450_a * d)), (float)((float)(this.entity.field_70163_u + (double)this.entity.func_70047_e() + lookVec.field_72448_b * d)), (float)((float)(this.entity.field_70161_v + lookVec.field_72449_c * d)), (float)((float)lookVec.field_72450_a), (float)((float)lookVec.field_72448_b), (float)((float)lookVec.field_72449_c), (float)0.2f, (int)1, (int[])new int[0]);
            }
            ++i;
        }
        return list;
    }

    @Mod.EventBusSubscriber(modid="speedsterheroes", value={Side.CLIENT})
    public static class Renderer {
        @SubscribeEvent
        public static void onSetupModel(RenderModelEvent.SetRotationAngels e) {
            if (e.getEntity() instanceof EntityLivingBase) {
                for (AbilityArmVortex ab : Ability.getAbilitiesFromClass((List)Ability.getAbilities((EntityLivingBase)((EntityLivingBase)e.getEntity())), AbilityArmVortex.class)) {
                    if (!ab.isUnlocked() || !ab.isEnabled()) continue;
                    int ticks = (int)((float)(e.getEntity().field_70173_aa * 2) + Minecraft.func_71410_x().func_184121_ak() * 2.0f);
                    e.setCanceled(true);
                    e.model.field_178723_h.field_78795_f = e.model.field_78116_c.field_78795_f - (float)Math.toRadians(90.0) + MathHelper.func_76134_b((float)ticks) / 2.5f;
                    e.model.field_178723_h.field_78796_g = e.model.field_78116_c.field_78796_g + MathHelper.func_76126_a((float)ticks) / 2.5f;
                    e.model.field_178724_i.field_78795_f = e.model.field_78116_c.field_78795_f - (float)Math.toRadians(90.0) - MathHelper.func_76126_a((float)ticks) / 2.5f;
                    e.model.field_178724_i.field_78796_g = e.model.field_78116_c.field_78796_g - MathHelper.func_76134_b((float)ticks) / 2.5f;
                    if (e.model instanceof ModelPlayer) {
                        ModelPlayer model = (ModelPlayer)e.model;
                        model.field_178732_b.field_78795_f = e.model.field_178723_h.field_78795_f;
                        model.field_178732_b.field_78796_g = e.model.field_178723_h.field_78796_g;
                        model.field_178734_a.field_78795_f = e.model.field_178724_i.field_78795_f;
                        model.field_178734_a.field_78796_g = e.model.field_178724_i.field_78796_g;
                    }
                    return;
                }
            }
        }
    }
}

