/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.speedsterheroes.abilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityAction;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.speedsterheroes.abilities.AbilitySaveBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class AbilityChangeBlocks
extends AbilityAction {
    public AbilityChangeBlocks(EntityLivingBase entity) {
        super(entity);
    }

    public boolean action() {
        BlockPos pos = AbilityChangeBlocks.getBlockPosLookingAt(this.entity);
        int range = this.entity.func_70093_af() ? 5 : 1;
        IBlockState state = this.getBlockState();
        if (state == null || this.entity instanceof EntityPlayer && !((EntityPlayer)this.entity).field_71075_bZ.field_75099_e) {
            return false;
        }
        this.changeBlock(this.entity.field_70170_p, pos, state, this.entity);
        if (range > 1) {
            for (BlockPos pos1 : AbilityChangeBlocks.getEffectedBlocks(this.entity.field_70170_p, pos, range)) {
                this.changeBlock(this.entity.field_70170_p, pos1, state, this.entity);
            }
        }
        return true;
    }

    @Nullable
    public IBlockState getBlockState() {
        for (AbilitySaveBlock saveBlock : Ability.getAbilitiesFromClass((List)Ability.getAbilities((EntityLivingBase)this.entity), AbilitySaveBlock.class)) {
            if (saveBlock.context != this.context) continue;
            return AbilitySaveBlock.getBlockState(saveBlock);
        }
        return null;
    }

    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        IBlockState state = this.getBlockState();
        if (state != null) {
            float zLevel = Minecraft.func_71410_x().func_175599_af().field_77023_b;
            mc.func_175599_af().field_77023_b = -100.5f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            mc.func_175599_af().func_175042_a(new ItemStack(state.func_177230_c()), 0, 0);
            GlStateManager.func_179121_F();
            mc.func_175599_af().field_77023_b = zLevel;
        }
    }

    public static BlockPos getBlockPosLookingAt(EntityLivingBase entity) {
        Vec3d lookVec = entity.func_70040_Z();
        double distance = 30.0;
        int i = 0;
        while ((double)i < distance * 2.0) {
            float scale = (float)i / 2.0f;
            Vec3d pos = entity.func_174791_d().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0).func_178787_e(lookVec.func_186678_a((double)scale));
            if (entity.field_70170_p.func_175625_s(new BlockPos(pos)) == null && !entity.field_70170_p.func_175623_d(new BlockPos(pos))) {
                return new BlockPos(pos);
            }
            ++i;
        }
        return new BlockPos(entity.func_174791_d().func_178787_e(lookVec.func_186678_a(distance)));
    }

    private void changeBlock(World world, BlockPos pos, IBlockState state, EntityLivingBase player) {
        IBlockState current = world.func_180495_p(pos);
        if (current.func_185887_b(world, pos) == -1.0f || this.entity instanceof EntityPlayer && !((EntityPlayer)this.entity).field_71075_bZ.field_75099_e || this.entity instanceof EntityPlayer && MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, current, (EntityPlayer)player))) {
            return;
        }
        world.func_175656_a(pos, state);
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            double brightness = rand.nextFloat();
            PlayerHelper.spawnParticleForAll((World)world, (double)50.0, (int)2511, (double)((float)pos.func_177958_n() - 0.1f + rand.nextFloat() * 1.2f), (double)((float)pos.func_177956_o() - 0.1f + rand.nextFloat() * 1.2f), (double)((float)pos.func_177952_p() - 0.1f + rand.nextFloat() * 1.2f), (double)0.0, (double)0.0, (double)0.0, (int[])new int[]{152 + (int)(brightness * 89.0), 12 + (int)(brightness * 74.0), 19 + (int)(brightness * 69.0)});
        }
    }

    private static List<BlockPos> getEffectedBlocks(World world, BlockPos center, int range) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int x = center.func_177958_n() - range; x < center.func_177958_n() + range; ++x) {
            for (int y = center.func_177956_o() - range; y < center.func_177956_o() + range; ++y) {
                for (int z = center.func_177952_p() - range; z < center.func_177952_p() + range; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!(pos.func_185332_f(center.func_177958_n(), center.func_177956_o(), center.func_177952_p()) <= (double)range) || world.func_175623_d(pos)) continue;
                    list.add(pos);
                }
            }
        }
        return list;
    }
}

