/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.speedsterheroes.abilities;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import lucraft.mods.lucraftcore.extendedinventory.capabilities.CapabilityExtendedInventory;
import lucraft.mods.lucraftcore.extendedinventory.capabilities.IExtendedInventoryCapability;
import lucraft.mods.lucraftcore.superpowers.Superpower;
import lucraft.mods.lucraftcore.superpowers.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityToggle;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataBoolean;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataInteger;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilityContainerSuperpower;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.superpowers.effects.EffectHandler;
import lucraft.mods.lucraftcore.superpowers.effects.EffectTrail;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import lucraft.mods.lucraftcore.util.attributes.LCAttributes;
import lucraft.mods.speedsterheroes.SpeedsterHeroes;
import lucraft.mods.speedsterheroes.abilities.AbilityWallRunning;
import lucraft.mods.speedsterheroes.config.SHConfig;
import lucraft.mods.speedsterheroes.helper.SHIconHelper;
import lucraft.mods.speedsterheroes.items.ItemTachyonDevice;
import lucraft.mods.speedsterheroes.triggers.SHCriteriaTriggers;
import lucraft.mods.speedsterheroes.util.SHUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbilitySuperSpeed
extends AbilityToggle {
    public static final AbilityData<Integer> BASE_SPEED_LEVELS = new AbilityDataInteger("base_speed_levels").disableSaving().setSyncType(EnumSync.SELF).enableSetting("base_speed_levels", "The base number of speed levels the ability gets.");
    public static final AbilityData<Integer> SPEED_LEVELS = new AbilityDataInteger("speed_levels").disableSaving().setSyncType(EnumSync.SELF);
    public static final AbilityData<Integer> SPEED_LEVEL = new AbilityDataInteger("speed_level").setSyncType(EnumSync.SELF);
    public static final AbilityData<Boolean> XP = new AbilityDataBoolean("gives_xp").disableSaving().setSyncType(EnumSync.SELF).enableSetting("gives_xp", "Whether or not the ability gives xp.");
    private static final UUID speedUUID = UUID.fromString("0c6583d4-c4f5-44f9-b61e-78732931e0f6");

    public AbilitySuperSpeed(EntityLivingBase entity) {
        super(entity);
    }

    public void registerData() {
        super.registerData();
        this.dataManager.register(BASE_SPEED_LEVELS, (Object)1);
        this.dataManager.register(SPEED_LEVEL, (Object)0);
        this.dataManager.register(SPEED_LEVELS, (Object)0);
        this.dataManager.register(XP, (Object)false);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        SHIconHelper.drawIcon(mc, gui, x, y, 0, 6);
    }

    public void updateTick() {
        if ((Integer)this.getDataManager().get(SPEED_LEVEL) > this.getMaxSpeedLevel()) {
            this.setSpeedLevel(this.getMaxSpeedLevel());
            this.updateAttributes();
        }
        Superpower superpower = SuperpowerHandler.getSuperpower((EntityLivingBase)this.entity);
        if (!this.entity.field_70170_p.field_72995_K && this.entity.field_70173_aa % 5 == 0 && SHUtil.isMoving(this.entity) && this.entity.field_70122_E && superpower != null && superpower.canLevelUp() && ((Boolean)this.getDataManager().get(XP)).booleanValue()) {
            int xp = SuitSet.hasSuitSetOn((EntityLivingBase)this.entity) && SuitSet.getSuitSet((EntityLivingBase)this.entity).getRegistryName().toString().contains("training") ? 3 : 1;
            ((AbilityContainerSuperpower)SuperpowerHandler.getSuperpowerCapability((EntityLivingBase)this.entity).getAbilityContainer(Ability.EnumAbilityContext.SUPERPOWER)).addXP(xp, false);
        }
        if (SHUtil.isMoving(this.entity)) {
            int progress;
            Object nbt;
            ItemStack stack;
            ItemStack device;
            if (this.entity instanceof EntityPlayer && !(device = SHUtil.getTachyonDevice((EntityPlayer)this.entity)).func_190926_b()) {
                NBTTagCompound nbt2;
                NBTTagCompound nBTTagCompound = nbt2 = device.func_77942_o() ? device.func_77978_p() : new NBTTagCompound();
                if (nbt2.func_74762_e("Charge") > 0) {
                    nbt2.func_74768_a("Charge", nbt2.func_74762_e("Charge") - 1);
                    device.func_77982_d(nbt2);
                }
            }
            float walkedDifference = this.entity.field_70140_Q / 0.6f - this.entity.field_70141_P / 0.6f;
            if (this.entity.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == SpeedsterHeroes.Items.tachyonCharge) {
                stack = this.entity.func_184586_b(EnumHand.MAIN_HAND);
                nbt = stack.func_77978_p();
                progress = nbt.func_74762_e("Progress");
                nbt.func_74768_a("Progress", (progress = (int)((float)progress + walkedDifference)) > 5000 ? 5000 : progress);
                stack.func_77982_d((NBTTagCompound)nbt);
            }
            if (this.entity.func_184586_b(EnumHand.OFF_HAND).func_77973_b() == SpeedsterHeroes.Items.tachyonCharge) {
                stack = this.entity.func_184586_b(EnumHand.OFF_HAND);
                nbt = stack.func_77978_p();
                progress = nbt.func_74762_e("Progress");
                nbt.func_74768_a("Progress", (progress = (int)((float)progress + walkedDifference)) > 5000 ? 5000 : progress);
                stack.func_77982_d((NBTTagCompound)nbt);
            }
            if (SHConfig.frictionBurn && this.entity.field_70122_E && (Integer)this.getDataManager().get(SPEED_LEVEL) > 3 && ((AbilityContainerSuperpower)SuperpowerHandler.getSuperpowerCapability((EntityLivingBase)this.entity).getAbilityContainer(Ability.EnumAbilityContext.SUPERPOWER)).getLevel() < 15 && walkedDifference > 1.6f && this.getExtraSuitSpeedLevels() == 0 && (!(this.entity instanceof EntityPlayer) || !((EntityPlayer)this.entity).field_71075_bZ.field_75098_d)) {
                this.entity.func_70015_d(10);
                if (this.entity instanceof EntityPlayerMP) {
                    SHCriteriaTriggers.FRICTION_BURN.trigger((EntityPlayerMP)this.entity);
                }
            }
            boolean isWallRunning = false;
            for (AbilityWallRunning ab2 : Ability.getAbilitiesFromClass((List)Ability.getAbilities((EntityLivingBase)this.entity), AbilityWallRunning.class)) {
                if (!ab2.isUnlocked() || !ab2.isEnabled() || !((Boolean)ab2.getDataManager().get(AbilityWallRunning.WALL_RUNNING)).booleanValue()) continue;
                isWallRunning = true;
                break;
            }
            try {
                Field isJumping = EntityLivingBase.class.getDeclaredFields()[49];
                isJumping.setAccessible(true);
                if (!(this.entity instanceof EntityPlayer && ((EntityPlayer)this.entity).field_71075_bZ.field_75100_b || isJumping.getBoolean(this.entity) || isWallRunning)) {
                    int i = 0;
                    while ((float)i < this.entity.field_70138_W) {
                        if (this.entity.field_70170_p.func_175665_u(new BlockPos(this.entity.field_70165_t, this.entity.field_70163_u - (double)(i + 1), this.entity.field_70161_v))) {
                            this.entity.field_70181_x = -1.0;
                        }
                        ++i;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            if (!enabled) {
                this.resetAttributes();
            } else {
                this.setSpeedLevel(1);
                this.updateAttributes();
            }
        }
        super.setEnabled(enabled);
    }

    public void lastTick() {
        this.resetAttributes();
    }

    public int getSpeedLevel() {
        return MathHelper.func_76125_a((int)((Integer)this.getDataManager().get(SPEED_LEVEL)), (int)1, (int)this.getMaxSpeedLevel());
    }

    public void setSpeedLevel(int speedLevel) {
        this.getDataManager().set(SPEED_LEVEL, (Object)speedLevel);
    }

    public int getMaxSpeedLevel() {
        return (Integer)this.dataManager.get(BASE_SPEED_LEVELS) + this.getExtraSuitSpeedLevels() + this.getExtraTachyonSpeedLevels() + ((AbilityContainerSuperpower)SuperpowerHandler.getSuperpowerCapability((EntityLivingBase)this.entity).getAbilityContainer(Ability.EnumAbilityContext.SUPERPOWER)).getLevel() / 6;
    }

    public int getExtraSuitSpeedLevels() {
        SuitSet suit = SuitSet.getSuitSet((EntityLivingBase)this.entity);
        if (suit != null && suit.getData() != null && suit.getData().func_74764_b("speed_levels")) {
            return suit.getData().func_74762_e("speed_levels");
        }
        return 0;
    }

    public int getExtraTachyonSpeedLevels() {
        ItemStack stack = ((IExtendedInventoryCapability)this.entity.getCapability(CapabilityExtendedInventory.EXTENDED_INVENTORY_CAP, null)).getInventory().func_70301_a(1);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemTachyonDevice) {
            return ((ItemTachyonDevice)stack.func_77973_b()).getTachyonDeviceType().getSpeedLevels();
        }
        return 0;
    }

    public void updateAttributes() {
        this.resetAttributes();
        this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(speedUUID, "speedsterheroes.speed", (double)this.getSpeedLevel(), 2));
        this.entity.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111121_a(new AttributeModifier(speedUUID, "speedsterheroes.attackspeed", (double)this.getSpeedLevel(), 2));
        this.entity.func_110148_a(LCAttributes.STEP_HEIGHT).func_111121_a(new AttributeModifier(speedUUID, "speedsterheroes.stepheight", 1.0, 0));
    }

    public void resetAttributes() {
        this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(speedUUID);
        this.entity.func_110148_a(SharedMonsterAttributes.field_188790_f).func_188479_b(speedUUID);
        this.entity.func_110148_a(LCAttributes.STEP_HEIGHT).func_188479_b(speedUUID);
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventBusSubscriber(modid="speedsterheroes", value={Side.CLIENT})
    public static class Renderer {
        public static Minecraft mc = Minecraft.func_71410_x();
        public static ResourceLocation HUD_TEXTURE = new ResourceLocation("speedsterheroes:textures/gui/hud.png");

        @SubscribeEvent
        public static void onRenderGameOverlay(RenderGameOverlayEvent e) {
            if (e.isCancelable() || e.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
                return;
            }
            AbilitySuperSpeed ability = null;
            Iterator iterator = Ability.getAbilitiesFromClass((List)Ability.getAbilities((EntityLivingBase)Renderer.mc.field_71439_g), AbilitySuperSpeed.class).iterator();
            if (iterator.hasNext()) {
                AbilitySuperSpeed abilities;
                ability = abilities = (AbilitySuperSpeed)((Object)iterator.next());
            }
            if (ability == null || !ability.isEnabled() || Renderer.mc.field_71474_y.field_74319_N || Renderer.mc.field_71474_y.field_74330_P || Renderer.mc.field_71439_g == null) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(e.getResolution().func_78326_a() - 15), (float)0.0f, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Renderer.mc.field_71446_o.func_110577_a(HUD_TEXTURE);
            int maxSpeedLevel = ability.getMaxSpeedLevel();
            int currentSpeedLevel = ability.getSpeedLevel();
            int suitLevels = ability.getExtraSuitSpeedLevels();
            int tachyonLevels = ability.getExtraTachyonSpeedLevels();
            int barHeight = 9 + (maxSpeedLevel - 1) * 7;
            int startY = e.getResolution().func_78328_b() / 2 - barHeight / 2;
            for (int i = 0; i < maxSpeedLevel; ++i) {
                Renderer.mc.field_71456_v.func_73729_b(0, startY + i * 7, 0, 0, 15, 9);
                Color color = new Color(0.7f, 0.7f, 0.7f);
                if (i >= tachyonLevels) {
                    for (EffectTrail trail : EffectHandler.getEffectsByClass((EntityPlayer)Renderer.mc.field_71439_g, EffectTrail.class)) {
                        if (i < suitLevels + tachyonLevels) {
                            color = trail.getColor((EntityPlayer)Renderer.mc.field_71439_g);
                            continue;
                        }
                        color = trail.color;
                    }
                }
                GlStateManager.func_179131_c((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)1.0f);
                Renderer.mc.field_71456_v.func_73729_b(1, startY + i * 7 + 1, 0, 27, 12, 6);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            Renderer.mc.field_71456_v.func_73729_b(-5, startY + (maxSpeedLevel - currentSpeedLevel) * 7 + 1, 15, 0, 4, 7);
            GlStateManager.func_179121_F();
        }
    }
}

