/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.speedsterheroes.abilities;

import java.util.List;
import lucraft.mods.lucraftcore.superpowers.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityToggle;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataBoolean;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataFloat;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.util.events.RenderModelEvent;
import lucraft.mods.speedsterheroes.helper.SHIconHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbilityWallRunning
extends AbilityToggle {
    public static final AbilityData<Float> SPEED = new AbilityDataFloat("speed").disableSaving().setSyncType(EnumSync.SELF).enableSetting("speed", "The minimum speed required to wall run.");
    public static final AbilityData<Boolean> WALL_RUNNING = new AbilityDataBoolean("wall_running").setSyncType(EnumSync.SELF);

    public AbilityWallRunning(EntityLivingBase entity) {
        super(entity);
    }

    public void registerData() {
        super.registerData();
        this.dataManager.register(WALL_RUNNING, (Object)false);
        this.dataManager.register(SPEED, (Object)Float.valueOf(1.0f));
    }

    public String getDisplayDescription() {
        return super.getDisplayDescription() + "\n\n" + TextFormatting.BLUE + this.getDataManager().get(SPEED) + " km/h";
    }

    @SideOnly(value=Side.CLIENT)
    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        SHIconHelper.drawIcon(mc, gui, x, y, 0, 0);
    }

    public void updateTick() {
        double speed = Math.abs(new Vec3d(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v).func_72438_d(new Vec3d(this.entity.field_70169_q, this.entity.field_70167_r, this.entity.field_70166_s))) * 72.0;
        if (this.entity.field_70123_F && speed >= (double)((Float)this.getDataManager().get(SPEED)).floatValue()) {
            this.entity.field_70181_x = 0.8;
            this.entity.field_70143_R = 0.0f;
            this.setIsWallRunning(true);
        } else if (((Boolean)this.getDataManager().get(WALL_RUNNING)).booleanValue()) {
            this.setIsWallRunning(false);
            this.entity.field_70181_x = 0.2f;
            this.entity.field_70143_R = 0.0f;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setIsWallRunning(false);
    }

    public void setIsWallRunning(boolean b) {
        if ((Boolean)this.getDataManager().get(WALL_RUNNING) != b) {
            this.getDataManager().set(WALL_RUNNING, (Object)b);
            SuperpowerHandler.syncToAll((EntityLivingBase)this.entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventBusSubscriber(modid="speedsterheroes", value={Side.CLIENT})
    public static class Renderer {
        @SubscribeEvent
        public static void onRenderModel(RenderModelEvent e) {
            if (e.getEntityLiving() instanceof EntityPlayer) {
                for (AbilityWallRunning ab : Ability.getAbilitiesFromClass((List)Ability.getAbilities((EntityLivingBase)e.getEntityLiving()), AbilityWallRunning.class)) {
                    if (ab == null || !ab.isUnlocked() || ab.getDataManager() == null || !((Boolean)ab.getDataManager().get(WALL_RUNNING)).booleanValue()) continue;
                    GlStateManager.func_179109_b((float)0.0f, (float)(-e.getEntity().field_70131_O), (float)0.0f);
                    GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
            }
        }

        @SubscribeEvent
        public static void setupModel(RenderModelEvent.SetRotationAngels e) {
            if (e.getEntity() instanceof EntityPlayer) {
                for (AbilityWallRunning ab : Ability.getAbilitiesFromClass((List)Ability.getAbilities((EntityLivingBase)((EntityLivingBase)e.getEntity())), AbilityWallRunning.class)) {
                    if (ab == null || !ab.isUnlocked() || !((Boolean)ab.getDataManager().get(WALL_RUNNING)).booleanValue()) continue;
                    e.limbSwing = (float)e.getEntity().field_70163_u;
                    e.limbSwingAmount = MathHelper.func_76134_b((float)((float)e.getEntity().field_70163_u * 4.0f));
                    break;
                }
            }
        }
    }
}

