/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.speedsterheroes.entities;

import io.netty.buffer.ByteBuf;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.speedsterheroes.util.TeleportDestination;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityDimensionBreach
extends Entity
implements IEntityAdditionalSpawnData {
    public BreachActionTypes type;
    public TeleportDestination teleportDestination = TeleportDestination.DEFAULT;
    public int progress = 20;
    public boolean starting;
    public boolean despawn;
    public Entity entityToSpawn;

    public EntityDimensionBreach(World world) {
        super(world);
        this.func_70105_a(3.0f, 3.0f);
    }

    public EntityDimensionBreach(World worldIn, double x, double y, double z, BreachActionTypes type) {
        super(worldIn);
        this.func_70107_b(x, y, z);
        this.type = type;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70173_aa < 20 && !this.despawn) {
            --this.progress;
            this.starting = true;
        }
        if (this.despawn) {
            ++this.progress;
            this.starting = false;
            if (this.progress == 20) {
                this.func_70106_y();
            }
        }
        if (this.type == BreachActionTypes.SPAWN_ENTITY) {
            if (this.field_70173_aa > 80) {
                this.startDespawn();
            }
            if (this.field_70173_aa == 25 && !this.func_130014_f_().field_72995_K && this.entityToSpawn != null) {
                this.entityToSpawn.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.func_130014_f_().func_72838_d(this.entityToSpawn);
            }
        }
        if (this.type == BreachActionTypes.PORTAL && this.func_184179_bs() == null && this.field_70173_aa > 200) {
            this.startDespawn();
        }
    }

    public void startDespawn() {
        this.despawn = true;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tagCompund) {
        this.progress = tagCompund.func_74762_e("portal_progress");
        if (tagCompund.func_74762_e("portal_type") != -1) {
            this.type = BreachActionTypes.getTypeFromId(tagCompund.func_74762_e("portal_type"));
        }
        this.teleportDestination = new TeleportDestination(tagCompund.func_74775_l("TeleportDestination"));
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("portal_progress", this.progress);
        tagCompound.func_74768_a("portal_type", this.type == null ? -1 : this.type.ordinal());
        tagCompound.func_74782_a("TeleportDestination", (NBTBase)this.teleportDestination.serializeNBT());
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        super.func_70100_b_(entityIn);
        if (!this.func_184196_w((Entity)entityIn) && this.type == BreachActionTypes.PORTAL && entityIn instanceof EntityPlayerMP && !this.despawn) {
            BlockPos pos = this.teleportDestination.getPos();
            PlayerHelper.teleportToDimension((EntityPlayer)entityIn, (int)this.teleportDestination.getDimensionId(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70014_b(nbt);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)nbt);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.func_70037_a(ByteBufUtils.readTag((ByteBuf)additionalData));
    }

    public static enum BreachActionTypes {
        NONE,
        SPAWN_ENTITY,
        PORTAL;


        public static BreachActionTypes getTypeFromId(int id) {
            for (BreachActionTypes types : BreachActionTypes.values()) {
                if (types.ordinal() != id) continue;
                return types;
            }
            return null;
        }
    }
}

