/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.speedsterheroes.entities;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityLightning
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public float damage;
    public List<Color> colors;

    public EntityLightning(World worldIn) {
        super(worldIn);
    }

    public EntityLightning(World worldIn, EntityLivingBase throwerIn, float damage, List<Color> colors) {
        super(worldIn, throwerIn);
        this.damage = damage;
        this.colors = colors;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 600) {
            this.func_70106_y();
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result == null || this.field_70128_L) {
            return;
        }
        if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
            result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.damage);
        } else if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            PlayerHelper.spawnParticleForAll((World)this.func_130014_f_(), (double)50.0, (EnumParticleTypes)EnumParticleTypes.SMOKE_NORMAL, (boolean)true, (float)((float)this.field_70165_t), (float)((float)this.field_70163_u), (float)((float)this.field_70161_v), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.01f, (int)5, (int[])new int[0]);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        return 1.0E-5f;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("Damage", this.damage);
        compound.func_74768_a("ColorAmount", this.colors.size());
        for (int i = 0; i < this.colors.size(); ++i) {
            Color color = this.colors.get(i);
            compound.func_74778_a("Color_" + i, color.getRed() + ";" + color.getGreen() + ";" + color.getBlue());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.damage = compound.func_74760_g("Damage");
        int colorAmount = compound.func_74762_e("ColorAmount");
        this.colors = new ArrayList<Color>();
        for (int i = 0; i < colorAmount; ++i) {
            String[] s = compound.func_74779_i("Color_" + i).split(";");
            this.colors.add(new Color(Float.parseFloat(s[0]), Float.parseFloat(s[1]), Float.parseFloat(s[2])));
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70014_b(nbt);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)nbt);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.func_70037_a(ByteBufUtils.readTag((ByteBuf)additionalData));
    }
}

