/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.speedsterheroes.entities;

import java.util.UUID;
import lucraft.mods.lucraftcore.util.helper.LCEntityHelper;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityMalekith
extends EntityMob {
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    public double prevChasingPosX;
    public double prevChasingPosY;
    public double prevChasingPosZ;
    public double chasingPosX;
    public double chasingPosY;
    public double chasingPosZ;
    public UUID heater;

    public EntityMalekith(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public Entity getHeaterEntity() {
        return this.heater == null ? null : LCEntityHelper.getEntityByUUID((World)this.field_70170_p, (UUID)this.heater);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAroundPos(this, 1.0, 10.0f, 2.0f));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3300000041723251);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateCape();
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        if (compound.func_74764_b("ProtectedEntity")) {
            this.heater = UUID.fromString(compound.func_74779_i("ProtectedEntity"));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.heater != null) {
            compound.func_74778_a("ProtectedEntity", this.heater.toString());
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    private void updateCape() {
        this.prevChasingPosX = this.chasingPosX;
        this.prevChasingPosY = this.chasingPosY;
        this.prevChasingPosZ = this.chasingPosZ;
        double d0 = this.field_70165_t - this.chasingPosX;
        double d1 = this.field_70163_u - this.chasingPosY;
        double d2 = this.field_70161_v - this.chasingPosZ;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.prevChasingPosX = this.chasingPosX = this.field_70165_t;
        }
        if (d2 > 10.0) {
            this.prevChasingPosZ = this.chasingPosZ = this.field_70161_v;
        }
        if (d1 > 10.0) {
            this.prevChasingPosY = this.chasingPosY = this.field_70163_u;
        }
        if (d0 < -10.0) {
            this.prevChasingPosX = this.chasingPosX = this.field_70165_t;
        }
        if (d2 < -10.0) {
            this.prevChasingPosZ = this.chasingPosZ = this.field_70161_v;
        }
        if (d1 < -10.0) {
            this.prevChasingPosY = this.chasingPosY = this.field_70163_u;
        }
        this.chasingPosX += d0 * 0.25;
        this.chasingPosZ += d2 * 0.25;
        this.chasingPosY += d1 * 0.25;
    }

    public static class EntityAIWanderAroundPos
    extends EntityAIBase {
        private final EntityMalekith entityHateMilk;
        private Entity protectedEntity;
        World world;
        private final double followSpeed;
        private final PathNavigate petPathfinder;
        private int timeToRecalcPath;
        float maxDist;
        float minDist;
        private float oldWaterCost;

        public EntityAIWanderAroundPos(EntityMalekith tameableIn, double followSpeedIn, float minDistIn, float maxDistIn) {
            this.entityHateMilk = tameableIn;
            this.world = tameableIn.field_70170_p;
            this.followSpeed = followSpeedIn;
            this.petPathfinder = tameableIn.func_70661_as();
            this.minDist = minDistIn;
            this.maxDist = maxDistIn;
            this.func_75248_a(3);
            if (!(tameableIn.func_70661_as() instanceof PathNavigateGround) && !(tameableIn.func_70661_as() instanceof PathNavigateFlying)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean func_75250_a() {
            Entity entitylivingbase = this.entityHateMilk.getHeaterEntity();
            if (entitylivingbase == null) {
                return false;
            }
            if (this.entityHateMilk.func_70068_e(entitylivingbase) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            this.protectedEntity = entitylivingbase;
            return true;
        }

        public boolean func_75253_b() {
            return !this.petPathfinder.func_75500_f() && this.entityHateMilk.func_70068_e(this.protectedEntity) > (double)(this.maxDist * this.maxDist);
        }

        public void func_75249_e() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.entityHateMilk.func_184643_a(PathNodeType.LAVA);
            this.entityHateMilk.func_184644_a(PathNodeType.LAVA, 0.0f);
        }

        public void func_75251_c() {
            this.protectedEntity = null;
            this.petPathfinder.func_75499_g();
            this.entityHateMilk.func_184644_a(PathNodeType.LAVA, this.oldWaterCost);
        }

        public void func_75246_d() {
            this.entityHateMilk.func_70671_ap().func_75651_a(this.protectedEntity, 10.0f, (float)this.entityHateMilk.func_70646_bf());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (!this.petPathfinder.func_75497_a(this.protectedEntity, this.followSpeed) && !this.entityHateMilk.func_110167_bD() && !this.entityHateMilk.func_184218_aH() && this.entityHateMilk.func_70068_e(this.protectedEntity) >= 144.0) {
                    int i = MathHelper.func_76128_c((double)this.protectedEntity.field_70165_t) - 2;
                    int j = MathHelper.func_76128_c((double)this.protectedEntity.field_70161_v) - 2;
                    int k = MathHelper.func_76128_c((double)this.protectedEntity.func_174813_aQ().field_72338_b);
                    for (int l = 0; l <= 4; ++l) {
                        for (int i1 = 0; i1 <= 4; ++i1) {
                            if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.isTeleportFriendlyBlock(i, j, k, l, i1)) continue;
                            this.entityHateMilk.func_70012_b((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.entityHateMilk.field_70177_z, this.entityHateMilk.field_70125_A);
                            this.petPathfinder.func_75499_g();
                            return;
                        }
                    }
                }
            }
        }

        protected boolean isTeleportFriendlyBlock(int x, int p_192381_2_, int y, int p_192381_4_, int p_192381_5_) {
            BlockPos blockpos = new BlockPos(x + p_192381_4_, y - 1, p_192381_2_ + p_192381_5_);
            IBlockState iblockstate = this.world.func_180495_p(blockpos);
            return iblockstate.func_193401_d((IBlockAccess)this.world, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a((Entity)this.entityHateMilk) && this.world.func_175623_d(blockpos.func_177984_a()) && this.world.func_175623_d(blockpos.func_177981_b(2));
        }
    }
}

