/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.speedsterheroes.items;

import java.util.List;
import lucraft.mods.lucraftcore.extendedinventory.IItemExtendedInventory;
import lucraft.mods.lucraftcore.extendedinventory.capabilities.CapabilityExtendedInventory;
import lucraft.mods.lucraftcore.extendedinventory.capabilities.IExtendedInventoryCapability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityGenerator;
import lucraft.mods.lucraftcore.superpowers.suitsets.ItemSuitSetArmor;
import lucraft.mods.lucraftcore.superpowers.suitsets.JsonSuitSet;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import lucraft.mods.lucraftcore.util.items.ItemBase;
import lucraft.mods.speedsterheroes.entities.EntityRingDummy;
import lucraft.mods.speedsterheroes.triggers.SHCriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemRing
extends ItemBase
implements IItemExtendedInventory {
    public ItemRing() {
        super("ring");
        this.func_77625_d(1);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        stack.func_77982_d(new NBTTagCompound());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return this.spawnSuitEntity(playerIn, playerIn.func_184586_b(hand));
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ItemRing.getArmorInRing(stack)[0].func_190926_b()) {
            return;
        }
        SuitSet set = SuitSet.getSuitSet((ItemStack)ItemRing.getArmorInRing(stack)[0]);
        tooltip.add(TextFormatting.BOLD + set.getDisplayName());
        if (set.hasExtraDescription(stack)) {
            tooltip.addAll(set.getExtraDescription(stack));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (SuitSet set : SuitSet.REGISTRY) {
            if (!(set instanceof JsonSuitSet)) continue;
            for (AbilityGenerator ability : ((JsonSuitSet)set).abilityGenerators) {
                if (!ability.loc.func_110623_a().contains("suit_ring")) continue;
                subItems.add((Object)ItemRing.setArmorIn(new ItemStack((Item)this), new ItemStack(set.getHelmet()), new ItemStack(set.getChestplate()), new ItemStack(set.getLegs()), new ItemStack(set.getBoots())));
            }
        }
    }

    public static ItemStack setArmorIn(ItemStack ring, ItemStack helmet, ItemStack chestplate, ItemStack legs, ItemStack boots) {
        if (!ring.func_77942_o()) {
            ring.func_77982_d(new NBTTagCompound());
        }
        ItemStack[] armor = new ItemStack[]{helmet, chestplate, legs, boots};
        NBTTagList nbtList = new NBTTagList();
        SuitSet type = null;
        for (int i = 0; i < 4; ++i) {
            ItemStack s = armor[i];
            if (s.func_190926_b()) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("Slot", i);
            s.func_77955_b(nbt);
            nbtList.func_74742_a((NBTBase)nbt);
            if (!(s.func_77973_b() instanceof ItemSuitSetArmor)) continue;
            type = ((ItemSuitSetArmor)s.func_77973_b()).getSuitSet();
        }
        ring.func_77978_p().func_74782_a("ItemInventory", (NBTBase)nbtList);
        ring.func_77978_p().func_74778_a("SpeedsterType", type.getUnlocalizedName());
        return ring;
    }

    public static ItemStack[] getArmorInRing(ItemStack ring) {
        if (!ring.func_77942_o()) {
            ring.func_77982_d(new NBTTagCompound());
        }
        NBTTagList items = ring.func_77978_p().func_150295_c("ItemInventory", 10);
        ItemStack[] armor = new ItemStack[4];
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot < 0 || slot >= 4) continue;
            armor[slot] = new ItemStack(item);
        }
        return armor;
    }

    public IItemExtendedInventory.ExtendedInventoryItemType getEIItemType(ItemStack stack) {
        return IItemExtendedInventory.ExtendedInventoryItemType.WRIST;
    }

    public void onPressedButton(ItemStack itemstack, EntityPlayer player, boolean pressed) {
        this.spawnSuitEntity(player, itemstack);
        if (itemstack.func_190916_E() == 0) {
            ((IExtendedInventoryCapability)player.getCapability(CapabilityExtendedInventory.EXTENDED_INVENTORY_CAP, null)).getInventory().func_70299_a(2, ItemStack.field_190927_a);
        }
    }

    public ActionResult<ItemStack> spawnSuitEntity(EntityPlayer playerIn, ItemStack stack) {
        World worldIn = playerIn.field_70170_p;
        ItemStack[] armor = ItemRing.getArmorInRing(stack);
        boolean hasStuffInIt = false;
        for (ItemStack stacks : armor) {
            if (stacks.func_190926_b()) continue;
            hasStuffInIt = true;
        }
        if (hasStuffInIt) {
            if (!worldIn.field_72995_K) {
                EntityRingDummy dummy = new EntityRingDummy(worldIn);
                Vec3d look = playerIn.func_70040_Z();
                dummy.func_70107_b(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v);
                dummy.dirX = (float)look.field_72450_a;
                dummy.dirZ = (float)look.field_72449_c;
                dummy.field_70125_A = playerIn.field_70125_A;
                dummy.field_70177_z = playerIn.field_70177_z;
                dummy.func_184201_a(EntityEquipmentSlot.HEAD, armor[0]);
                dummy.func_184201_a(EntityEquipmentSlot.CHEST, armor[1]);
                dummy.func_184201_a(EntityEquipmentSlot.LEGS, armor[2]);
                dummy.func_184201_a(EntityEquipmentSlot.FEET, armor[3]);
                worldIn.func_72838_d((Entity)dummy);
                stack.func_190918_g(1);
                SHCriteriaTriggers.USE_RING.trigger((EntityPlayerMP)playerIn);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }
}

