/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.speedsterheroes.network;

import io.netty.buffer.ByteBuf;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.network.AbstractServerMessageHandler;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.speedsterheroes.entities.EntityDimensionBreach;
import lucraft.mods.speedsterheroes.util.WaypointDataUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSendInfoToServer
implements IMessage {
    public InfoType type;
    public int info;

    public MessageSendInfoToServer() {
    }

    public MessageSendInfoToServer(InfoType type) {
        this.type = type;
        this.info = 0;
    }

    public MessageSendInfoToServer(InfoType type, int i) {
        this.type = type;
        this.info = i;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = InfoType.values()[buf.readInt()];
        this.info = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.info);
    }

    public static enum InfoType {
        DIMENSION_BREACH_CANCEL,
        DIMENSION_BREACH_TELEPORT,
        CHOSEN_WAYPOINT,
        DELETE_WAYPOINT;

    }

    public static class Handler
    extends AbstractServerMessageHandler<MessageSendInfoToServer> {
        public IMessage handleServerMessage(EntityPlayer player, MessageSendInfoToServer message, MessageContext ctx) {
            LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(() -> {
                InfoType type = message.type;
                switch (type) {
                    case DIMENSION_BREACH_CANCEL: {
                        if (player.func_184187_bx() == null || !(player.func_184187_bx() instanceof EntityDimensionBreach)) break;
                        ((EntityDimensionBreach)player.func_184187_bx()).startDespawn();
                        break;
                    }
                    case DIMENSION_BREACH_TELEPORT: {
                        player.func_184210_p();
                        if (player.field_70170_p.field_72995_K || !(player instanceof EntityPlayerMP)) break;
                        MinecraftServer server = ((EntityPlayerMP)player).field_70170_p.func_73046_m();
                        WorldServer worldServer = server.func_71218_a(message.info);
                        BlockPos spawn = worldServer.func_175694_M();
                        if (worldServer.field_73011_w.getDimension() == 1) {
                            spawn = worldServer.func_180504_m();
                        }
                        while (!worldServer.func_175623_d(spawn)) {
                            spawn = spawn.func_177984_a();
                        }
                        PlayerHelper.teleportToDimension((EntityPlayer)player, (int)message.info, (double)spawn.func_177958_n(), (double)spawn.func_177956_o(), (double)spawn.func_177952_p());
                        break;
                    }
                    case CHOSEN_WAYPOINT: {
                        WaypointDataUtil.chooseWaypoint(player, message.info);
                        break;
                    }
                    case DELETE_WAYPOINT: {
                        WaypointDataUtil.deleteWaypoint(player, message.info);
                        break;
                    }
                }
            });
            return null;
        }
    }
}

