/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.speedsterheroes.network;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.network.AbstractServerMessageHandler;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageTurnIntoBubble
implements IMessage {
    public int type;
    public int entityId;
    public BlockPos pos;

    public MessageTurnIntoBubble() {
    }

    public MessageTurnIntoBubble(int entityId) {
        this.type = 0;
        this.entityId = entityId;
    }

    public MessageTurnIntoBubble(BlockPos pos) {
        this.type = 1;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readInt();
        if (this.type == 0) {
            this.entityId = buf.readInt();
        } else {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type);
        if (this.type == 0) {
            buf.writeInt(this.entityId);
        } else {
            buf.writeInt(this.pos.func_177958_n());
            buf.writeInt(this.pos.func_177956_o());
            buf.writeInt(this.pos.func_177952_p());
        }
    }

    public static class Handler
    extends AbstractServerMessageHandler<MessageTurnIntoBubble> {
        public IMessage handleServerMessage(EntityPlayer player, MessageTurnIntoBubble message, MessageContext ctx) {
            LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(() -> {
                AxisAlignedBB box = null;
                if (message.type == 0) {
                    Entity entity = player.field_70170_p.func_73045_a(message.entityId);
                    if (entity != null && !(entity instanceof EntityPlayer) && !MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent(player, entity))) {
                        entity.func_70106_y();
                        box = entity.func_174813_aQ();
                    }
                } else {
                    IBlockState state = player.field_70170_p.func_180495_p(message.pos);
                    if (state == null || state.func_185887_b(player.field_70170_p, message.pos) == -1.0f || !player.field_71075_bZ.field_75099_e || MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(player.field_70170_p, message.pos, state, player))) {
                        return;
                    }
                    box = state.func_185900_c((IBlockAccess)player.field_70170_p, message.pos);
                    box = new AxisAlignedBB((double)message.pos.func_177958_n() + box.field_72340_a, (double)message.pos.func_177956_o() + box.field_72338_b, (double)message.pos.func_177952_p() + box.field_72339_c, (double)message.pos.func_177958_n() + box.field_72336_d, (double)message.pos.func_177956_o() + box.field_72337_e, (double)message.pos.func_177952_p() + box.field_72334_f);
                    player.field_70170_p.func_175698_g(message.pos);
                }
                if (box != null) {
                    Random random = new Random();
                    for (int i = 0; i < 20; ++i) {
                        double x = box.field_72340_a + (box.field_72336_d - box.field_72340_a) * (double)random.nextFloat();
                        double y = box.field_72338_b + (box.field_72337_e - box.field_72338_b) * (double)random.nextFloat();
                        double z = box.field_72339_c + (box.field_72334_f - box.field_72339_c) * (double)random.nextFloat();
                        PlayerHelper.spawnParticleForAll((World)player.field_70170_p, (double)50.0, (int)2011, (double)x, (double)y, (double)z, (double)0.0, (double)0.0, (double)0.1f, (int[])new int[0]);
                    }
                }
            });
            return null;
        }
    }
}

