/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.speedsterheroes.network;

import lucraft.mods.speedsterheroes.network.MessageChangeBlocks;
import lucraft.mods.speedsterheroes.network.MessageNewWaypoint;
import lucraft.mods.speedsterheroes.network.MessageSendInfoToServer;
import lucraft.mods.speedsterheroes.network.MessageTurnIntoBubble;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class SHPacketDispatcher {
    private static byte packetId = 0;
    private static final SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("speedsterheroes");

    public static final void registerPackets() {
        SHPacketDispatcher.registerMessage(MessageSendInfoToServer.Handler.class, MessageSendInfoToServer.class, Side.SERVER);
        SHPacketDispatcher.registerMessage(MessageNewWaypoint.Handler.class, MessageNewWaypoint.class, Side.SERVER);
        SHPacketDispatcher.registerMessage(MessageChangeBlocks.Handler.class, MessageChangeBlocks.class, Side.SERVER);
        SHPacketDispatcher.registerMessage(MessageTurnIntoBubble.Handler.class, MessageTurnIntoBubble.class, Side.SERVER);
    }

    private static final void registerMessage(Class handlerClass, Class messageClass, Side side) {
        byte by = packetId;
        packetId = (byte)(by + 1);
        dispatcher.registerMessage(handlerClass, messageClass, (int)by, side);
    }

    public static final void sendTo(IMessage message, EntityPlayerMP player) {
        dispatcher.sendTo(message, player);
    }

    public static final void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        dispatcher.sendToAllAround(message, point);
    }

    public static final void sendToAll(IMessage message) {
        dispatcher.sendToAll(message);
    }

    public static final void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        SHPacketDispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static final void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        SHPacketDispatcher.sendToAllAround(message, player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public static final void sendToDimension(IMessage message, int dimensionId) {
        dispatcher.sendToDimension(message, dimensionId);
    }

    public static final void sendToServer(IMessage message) {
        dispatcher.sendToServer(message);
    }
}

