/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.speedsterheroes.util;

import lucraft.mods.lucraftcore.superpowers.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpowers.capabilities.ISuperpowerCapability;
import lucraft.mods.speedsterheroes.network.MessageNewWaypoint;
import lucraft.mods.speedsterheroes.network.MessageSendInfoToServer;
import lucraft.mods.speedsterheroes.network.SHPacketDispatcher;
import lucraft.mods.speedsterheroes.util.TeleportDestination;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;

public class WaypointDataUtil {
    public static NBTTagList getWaypointDataList(EntityPlayer player) {
        ISuperpowerCapability capability = SuperpowerHandler.getSuperpowerCapability((EntityLivingBase)player);
        if (capability != null) {
            NBTTagCompound data = capability.getData();
            return data.func_74764_b("waypoints") ? (NBTTagList)data.func_74781_a("waypoints") : new NBTTagList();
        }
        return new NBTTagList();
    }

    public static void deleteWaypoint(EntityPlayer player, int deletingIndex) {
        ISuperpowerCapability capability = SuperpowerHandler.getSuperpowerCapability((EntityLivingBase)player);
        if (capability != null) {
            NBTTagCompound data = capability.getData();
            try {
                NBTTagList list = WaypointDataUtil.getWaypointDataList(player);
                deletingIndex = MathHelper.func_76125_a((int)deletingIndex, (int)0, (int)(list.func_74745_c() - 1));
                list.func_74744_a(deletingIndex);
                int index = data.func_74762_e("chosenWaypointIndex");
                if (index == deletingIndex) {
                    data.func_74768_a("chosenWaypointIndex", -1);
                } else if (index > list.func_74745_c()) {
                    data.func_74768_a("chosenWaypointIndex", index - 1);
                }
                data.func_74782_a("waypoints", (NBTBase)list);
                capability.getData();
                if (!player.field_70170_p.field_72995_K) {
                    SuperpowerHandler.syncToPlayer((EntityLivingBase)player);
                } else {
                    SHPacketDispatcher.sendToServer(new MessageSendInfoToServer(MessageSendInfoToServer.InfoType.DELETE_WAYPOINT, deletingIndex));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void chooseWaypoint(EntityPlayer player, int index) {
        ISuperpowerCapability capability = SuperpowerHandler.getSuperpowerCapability((EntityLivingBase)player);
        if (capability == null) {
            return;
        }
        NBTTagCompound data = capability.getData();
        data.func_74768_a("chosenWaypointIndex", index);
        if (!player.field_70170_p.field_72995_K) {
            SuperpowerHandler.syncToPlayer((EntityLivingBase)player);
        } else {
            SHPacketDispatcher.sendToServer(new MessageSendInfoToServer(MessageSendInfoToServer.InfoType.CHOSEN_WAYPOINT, index));
        }
    }

    public static int getChosenWaypointIndex(EntityPlayer player) {
        ISuperpowerCapability capability = SuperpowerHandler.getSuperpowerCapability((EntityLivingBase)player);
        if (capability != null) {
            return capability.getData().func_74762_e("chosenWaypointIndex");
        }
        return -1;
    }

    public static TeleportDestination getTeleportDestination(EntityPlayer player, int index) {
        NBTTagList waypointList = WaypointDataUtil.getWaypointDataList(player);
        NBTBase nbt = waypointList.func_179238_g(index);
        if (nbt instanceof NBTTagCompound) {
            return new TeleportDestination((NBTTagCompound)nbt);
        }
        return TeleportDestination.DEFAULT;
    }

    public static void addNewWaypoint(EntityPlayer player, TeleportDestination destination) {
        if (!player.field_70170_p.field_72995_K) {
            ISuperpowerCapability capability = SuperpowerHandler.getSuperpowerCapability((EntityLivingBase)player);
            if (capability != null) {
                NBTTagCompound data = capability.getData();
                NBTTagList list = WaypointDataUtil.getWaypointDataList(player);
                list.func_74742_a((NBTBase)destination.serializeNBT());
                data.func_74782_a("waypoints", (NBTBase)list);
                SuperpowerHandler.syncToPlayer((EntityLivingBase)player);
            }
        } else {
            SHPacketDispatcher.sendToServer(new MessageNewWaypoint(destination));
        }
    }
}

