/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.speedsterheroes.worldgen;

import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import lucraft.mods.lucraftcore.infinity.EntityItemIndestructible;
import lucraft.mods.lucraftcore.util.commands.CommandLocateExt;
import lucraft.mods.speedsterheroes.SpeedsterHeroes;
import lucraft.mods.speedsterheroes.config.SHConfig;
import lucraft.mods.speedsterheroes.entities.EntityHateMilk;
import lucraft.mods.speedsterheroes.entities.EntityHeater;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="speedsterheroes")
public class WorldGenHeater
extends WorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (SHConfig.generateHeater && world.field_73011_w.func_186058_p() == DimensionType.NETHER) {
            int x = chunkX * 16;
            int z = chunkZ * 16;
            BlockPos pos = WorldGenHeater.getPos(world);
            if (x <= pos.func_177958_n() && pos.func_177958_n() <= x + 16 && z <= pos.func_177952_p() && pos.func_177952_p() <= z + 16) {
                int y;
                for (y = 30 + random.nextInt(40); !world.func_180495_p(new BlockPos(x, y, z)).func_185913_b() && world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != Blocks.field_150353_l && y > 0; --y) {
                }
                this.func_180709_b(world, random, new BlockPos(pos.func_177958_n() - 3, y, pos.func_177952_p() - 3));
            }
        }
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        MinecraftServer minecraftserver = worldIn.func_73046_m();
        TemplateManager templatemanager = worldIn.func_72860_G().func_186340_h();
        Template template = templatemanager.func_186237_a(minecraftserver, new ResourceLocation("speedsterheroes", "heater"));
        PlacementSettings placementsettings = new PlacementSettings().func_186218_a((ChunkPos)null).func_186225_a((Block)null);
        if (template == null) {
            return false;
        }
        template.func_186253_b(worldIn, position, placementsettings);
        Map map = template.func_186258_a(position, placementsettings);
        EntityHeater item = null;
        EntityHateMilk hateMilk = null;
        for (Map.Entry entry : map.entrySet()) {
            String s = (String)entry.getValue();
            if (s.equalsIgnoreCase("Heater")) {
                worldIn.func_175698_g((BlockPos)entry.getKey());
                item = new EntityHeater(worldIn, (float)((BlockPos)entry.getKey()).func_177958_n() + 0.5f, ((BlockPos)entry.getKey()).func_177956_o(), (float)((BlockPos)entry.getKey()).func_177952_p() + 0.5f, new ItemStack(SpeedsterHeroes.Items.heater));
                continue;
            }
            if (!s.equalsIgnoreCase("HateMilk")) continue;
            worldIn.func_175698_g((BlockPos)entry.getKey());
            hateMilk = new EntityHateMilk(worldIn);
            hateMilk.func_70107_b(((BlockPos)entry.getKey()).func_177958_n(), ((BlockPos)entry.getKey()).func_177956_o(), ((BlockPos)entry.getKey()).func_177952_p());
        }
        if (!worldIn.field_72995_K) {
            if (item != null) {
                worldIn.func_72838_d(item);
            }
            if (hateMilk != null) {
                hateMilk.heater = item == null ? null : item.getPersistentID();
                worldIn.func_72838_d(hateMilk);
            }
        }
        return true;
    }

    public static BlockPos getPos(World world) {
        if (world.field_73011_w.func_186058_p() != DimensionType.NETHER) {
            return null;
        }
        Random rand = new Random(world.func_72905_C());
        return new BlockPos(rand.nextInt(10000) - 5000, 64, rand.nextInt(10000) - 5000);
    }

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent.EntityInteractSpecific e) {
        if (e.getTarget() instanceof EntityItemIndestructible && ((EntityItemIndestructible)e.getTarget()).getItem().func_77973_b() == SpeedsterHeroes.Items.heater) {
            BlockPos pos = e.getTarget().func_180425_c();
            Iterator iterator = e.getWorld().func_72872_a(EntityHateMilk.class, new AxisAlignedBB((double)(pos.func_177958_n() - 50), (double)(pos.func_177956_o() - 50), (double)(pos.func_177952_p() - 50), (double)(pos.func_177958_n() + 50), (double)(pos.func_177956_o() + 50), (double)(pos.func_177952_p() + 50))).iterator();
            if (iterator.hasNext()) {
                EntityHateMilk hateMilk = (EntityHateMilk)((Object)iterator.next());
                e.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("speedsterheroes.info.canttake", new Object[0]), true);
                e.setCanceled(true);
                return;
            }
        }
    }

    static {
        CommandLocateExt.ENTRIES.put("Heater", (w, p) -> SHConfig.generateHeater ? WorldGenHeater.getPos(w) : null);
    }
}

