/*
 * Decompiled with CFR 0.152.
 */
package streams.tfc;

import com.bioxx.tfc.Blocks.Terrain.BlockCollapsible;
import com.bioxx.tfc.Chunkdata.ChunkData;
import com.bioxx.tfc.Core.TFC_Climate;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Core.TFC_Time;
import com.bioxx.tfc.Entities.Mobs.EntityBear;
import com.bioxx.tfc.Entities.Mobs.EntityChickenTFC;
import com.bioxx.tfc.Entities.Mobs.EntityCowTFC;
import com.bioxx.tfc.Entities.Mobs.EntityDeer;
import com.bioxx.tfc.Entities.Mobs.EntityHorseTFC;
import com.bioxx.tfc.Entities.Mobs.EntityPheasantTFC;
import com.bioxx.tfc.Entities.Mobs.EntityPigTFC;
import com.bioxx.tfc.Entities.Mobs.EntitySheepTFC;
import com.bioxx.tfc.Entities.Mobs.EntityWolfTFC;
import com.bioxx.tfc.WorldGen.DataLayer;
import com.bioxx.tfc.WorldGen.MapGen.MapGenRiverRavine;
import com.bioxx.tfc.WorldGen.SpawnerAnimalsTFC;
import com.bioxx.tfc.WorldGen.TFCBiome;
import com.bioxx.tfc.api.TFCBlocks;
import com.bioxx.tfc.api.TFCOptions;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import streams.tfc.MapGenCavesTFC;
import streams.tfc.MapGenRavineTFC;
import streams.world.gen.structure.RiverGenerator;

public class TFCChunkProviderGenerate
extends ChunkProviderGenerate {
    private Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves field_73212_b;
    public NoiseGeneratorOctaves field_73213_c;
    private World worldObj;
    private double[] noiseArray;
    private double[] stoneNoise = new double[256];
    private BiomeGenBase[] biomesForGeneration;
    private DataLayer[] rockLayer1;
    private DataLayer[] rockLayer2;
    private DataLayer[] rockLayer3;
    private DataLayer[] evtLayer;
    private DataLayer[] rainfallLayer;
    private DataLayer[] stabilityLayer;
    private DataLayer[] drainageLayer;
    private Block[] idsTop;
    private Block[] idsBig;
    private byte[] metaBig;
    private double[] noise3;
    private double[] noise1;
    private double[] noise2;
    private double[] noise6;
    private float[] parabolicField;
    private int[] seaLevelOffsetMap = new int[256];
    private int[] chunkHeightMap = new int[256];
    private MapGenCavesTFC caveGen = new MapGenCavesTFC();
    private MapGenRavineTFC surfaceRavineGen = new MapGenRavineTFC(125, 30);
    private MapGenRavineTFC ravineGen = new MapGenRavineTFC(20, 50);
    private MapGenRiverRavine riverRavineGen = new MapGenRiverRavine();

    public TFCChunkProviderGenerate(World par1World, long par2, boolean par4) {
        super(par1World, par2, par4);
        this.worldObj = par1World;
        this.rand = new Random(par2);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.field_73214_a = new NoiseGeneratorOctaves(this.rand, 2);
        this.field_73212_b = new NoiseGeneratorOctaves(this.rand, 1);
        this.field_73213_c = new NoiseGeneratorOctaves(this.rand, 8);
        this.idsTop = new Block[32768];
        this.idsBig = new Block[65536];
        this.metaBig = new byte[65536];
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        Arrays.fill(this.idsTop, null);
        Arrays.fill(this.idsBig, null);
        Arrays.fill(this.metaBig, (byte)0);
        this.generateTerrainHigh(chunkX, chunkZ, this.idsTop);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16 - 1, chunkZ * 16 - 1, 18, 18);
        if (TFC_Climate.getCacheManager((World)this.worldObj) != null) {
            this.rockLayer1 = TFC_Climate.getCacheManager((World)this.worldObj).loadRockLayerGeneratorData(this.rockLayer1, chunkX * 16, chunkZ * 16, 16, 16, 0);
            this.rockLayer2 = TFC_Climate.getCacheManager((World)this.worldObj).loadRockLayerGeneratorData(this.rockLayer2, chunkX * 16, chunkZ * 16, 16, 16, 1);
            this.rockLayer3 = TFC_Climate.getCacheManager((World)this.worldObj).loadRockLayerGeneratorData(this.rockLayer3, chunkX * 16, chunkZ * 16, 16, 16, 2);
            this.evtLayer = TFC_Climate.getCacheManager((World)this.worldObj).loadEVTLayerGeneratorData(this.evtLayer, chunkX * 16, chunkZ * 16, 16, 16);
            this.rainfallLayer = TFC_Climate.getCacheManager((World)this.worldObj).loadRainfallLayerGeneratorData(this.rainfallLayer, chunkX * 16, chunkZ * 16, 16, 16);
            this.stabilityLayer = TFC_Climate.getCacheManager((World)this.worldObj).loadStabilityLayerGeneratorData(this.stabilityLayer, chunkX * 16, chunkZ * 16, 16, 16);
            this.drainageLayer = TFC_Climate.getCacheManager((World)this.worldObj).loadDrainageLayerGeneratorData(this.drainageLayer, chunkX * 16, chunkZ * 16, 16, 16);
        }
        this.seaLevelOffsetMap = new int[256];
        this.replaceBlocksForBiomeHigh(chunkX, chunkZ, this.idsTop, this.rand, this.idsBig, this.metaBig);
        if (this != ((WorldServer)this.worldObj).field_73059_b.field_73246_d) {
            return new Chunk(this.worldObj, this.idsBig, this.metaBig, chunkX, chunkZ);
        }
        RiverGenerator.surfaceWaterGenerator().generate(this.worldObj.field_73011_w, chunkX, chunkZ, this.idsBig, this.metaBig);
        this.replaceBlocksForBiomeLow(chunkX, chunkZ, this.rand, this.idsBig, this.metaBig);
        this.caveGen.generate((IChunkProvider)this, this.worldObj, chunkX, chunkZ, this.idsBig, this.metaBig);
        this.surfaceRavineGen.generate((IChunkProvider)this, this.worldObj, chunkX, chunkZ, this.idsBig, this.metaBig);
        this.ravineGen.generate((IChunkProvider)this, this.worldObj, chunkX, chunkZ, this.idsBig, this.metaBig);
        this.riverRavineGen.generate((IChunkProvider)this, this.worldObj, chunkX, chunkZ, this.idsBig, this.metaBig);
        Chunk chunk = new Chunk(this.worldObj, this.idsBig, this.metaBig, chunkX, chunkZ);
        byte[] abyte1 = chunk.func_76605_m();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                abyte1[x * z] = (byte)this.getBiome((int)x, (int)z).field_76756_M;
            }
        }
        chunk.func_76616_a(abyte1);
        ChunkData data = new ChunkData(chunk).createNew(this.worldObj, chunkX, chunkZ);
        data.heightmap = this.seaLevelOffsetMap;
        data.rainfallMap = this.rainfallLayer;
        TFC_Core.getCDM((World)this.worldObj).addData(chunk, data);
        chunk.func_76603_b();
        return chunk;
    }

    private BiomeGenBase getBiome(int x, int z) {
        return this.biomesForGeneration[z + 1 + (x + 1) * 18];
    }

    public void func_73153_a(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
        int z;
        int x;
        BlockCollapsible.fallInstantly = true;
        int xCoord = chunkX * 16;
        int zCoord = chunkZ * 16;
        TFCBiome biome = null;
        if (this.worldObj.func_72807_a(xCoord + 16, zCoord + 16) instanceof TFCBiome) {
            biome = (TFCBiome)this.worldObj.func_72807_a(xCoord + 16, zCoord + 16);
        }
        this.rand.setSeed(this.worldObj.func_72905_C());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * var7 + (long)chunkZ * var9 ^ this.worldObj.func_72905_C());
        boolean var11 = false;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(chunkProvider, this.worldObj, this.rand, chunkX, chunkZ, var11));
        TFC_Core.getCDM((World)this.worldObj).setFishPop(chunkX, chunkZ, 60.0f);
        int waterRand = 4;
        if (TFC_Climate.getStability((World)this.worldObj, (int)xCoord, (int)zCoord) == 1) {
            waterRand = 6;
        }
        if (!var11 && this.rand.nextInt(waterRand) == 0) {
            x = xCoord + this.rand.nextInt(16) + 8;
            z = zCoord + this.rand.nextInt(16) + 8;
            int n = 144 - this.rand.nextInt(45);
        }
        if (biome != null) {
            biome.func_76728_a(this.worldObj, this.rand, xCoord, zCoord);
            SpawnerAnimalsTFC.performWorldGenSpawning((World)this.worldObj, (TFCBiome)biome, (int)(xCoord + 8), (int)(zCoord + 8), (int)16, (int)16, (Random)this.rand);
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                int y = this.worldObj.func_72874_g(xCoord + x, zCoord + z);
                this.worldObj.func_72884_u(x + xCoord, y - 1, z + zCoord);
                if (!this.canSnowAt(this.worldObj, x + xCoord, y, z + zCoord)) continue;
                this.worldObj.func_147465_d(x + xCoord, y, z + zCoord, TFCBlocks.snow, 0, 2);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(chunkProvider, this.worldObj, this.rand, chunkX, chunkZ, var11));
        BlockCollapsible.fallInstantly = false;
    }

    public static List<BiomeGenBase.SpawnListEntry> getCreatureSpawnsByChunk(World world, TFCBiome biome, int x, int z) {
        int mountainousAreaModifier;
        ArrayList<BiomeGenBase.SpawnListEntry> spawnableCreatureList = new ArrayList<BiomeGenBase.SpawnListEntry>();
        spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityChickenTFC.class, 24, 0, 0));
        float temp = TFC_Climate.getBioTemperatureHeight((World)world, (int)x, (int)world.func_72825_h(x, z), (int)z);
        float rain = TFC_Climate.getRainfall((World)world, (int)x, (int)150, (int)z);
        float evt = 0.0f;
        if (TFC_Climate.getCacheManager((World)world) != null && TFC_Climate.getCacheManager((World)world).getEVTLayerAt(x, z) != null) {
            evt = TFC_Climate.getCacheManager((World)world).getEVTLayerAt((int)x, (int)z).floatdata1;
        }
        boolean isMountainous = biome == TFCBiome.MOUNTAINS || biome == TFCBiome.HIGH_HILLS;
        int n = mountainousAreaModifier = isMountainous ? -1 : 0;
        if (isMountainous) {
            if (temp < 25.0f && temp > -10.0f) {
                spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntitySheepTFC.class, 2, 2, 4));
                if (rain > 250.0f && (double)evt < 0.75) {
                    spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityWolfTFC.class, 2, 1, 3));
                    spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityBear.class, 1, 1, 1));
                }
            }
        } else if (temp > 0.0f && rain > 100.0f && rain <= 500.0f) {
            if (temp > 20.0f) {
                spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityPigTFC.class, 1, 1, 2));
            }
            if (temp < 30.0f) {
                spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityCowTFC.class, 2, 2, 4));
                spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityHorseTFC.class, 2, 2, 3));
            }
        }
        if (temp > 0.0f && temp < 21.0f && rain > 250.0f) {
            spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityPigTFC.class, 2 + mountainousAreaModifier, 2 + mountainousAreaModifier, 3 + mountainousAreaModifier));
            spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityWolfTFC.class, 1, 1, 2 + mountainousAreaModifier));
            spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityBear.class, 1, 1, 1));
            spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityDeer.class, 2 + mountainousAreaModifier, 1, 3 + mountainousAreaModifier));
            spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityPheasantTFC.class, 3 + mountainousAreaModifier, 1, 3));
        }
        if (temp > -20.0f && temp <= 0.0f) {
            if (rain > 250.0f) {
                spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityPigTFC.class, 1 + mountainousAreaModifier, 1, 2));
                spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityWolfTFC.class, 2 + mountainousAreaModifier, 1, 2 + mountainousAreaModifier));
                spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityBear.class, 2 + mountainousAreaModifier, 1, 1));
                spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityDeer.class, 1 + mountainousAreaModifier, 2, 3));
                spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityPheasantTFC.class, 1 + mountainousAreaModifier, 1, 2));
                spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntitySheepTFC.class, 2, 2, 4));
            } else if (rain > 100.0f) {
                spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityWolfTFC.class, 1 + mountainousAreaModifier, 1, 1));
                spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityDeer.class, 1 + mountainousAreaModifier, 1, 1));
            }
        }
        if (temp >= 23.0f && temp < 44.0f && rain > 1500.0f) {
            spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityPigTFC.class, 2 + mountainousAreaModifier, 2 + mountainousAreaModifier, 4 + mountainousAreaModifier));
            spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityChickenTFC.class, 3 + mountainousAreaModifier, 1, 4 + mountainousAreaModifier));
        }
        if (TFC_Climate.isSwamp((World)world, (int)x, (int)150, (int)z)) {
            spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityPigTFC.class, 1, 1, 2));
            spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityPheasantTFC.class, 1 + mountainousAreaModifier, 1, 1));
        }
        return spawnableCreatureList;
    }

    public boolean canSnowAt(World world, int x, int y, int z) {
        float var5 = TFC_Climate.getHeightAdjustedTemp((World)world, (int)x, (int)y, (int)z);
        if (var5 >= 0.0f) {
            return false;
        }
        if (y >= 0 && y < 256 && world.func_72972_b(EnumSkyBlock.Block, x, y, z) < 10 && TFC_Time.getTotalMonths() > 1L) {
            Block var6 = world.func_147439_a(x, y - 1, z);
            Block var7 = world.func_147439_a(x, y, z);
            if (var7.isAir((IBlockAccess)world, x, y, z) && TFCBlocks.snow.func_149742_c(world, x, y, z) && !var6.isAir((IBlockAccess)world, x, y - 1, z) && var6.func_149688_o().func_76230_c()) {
                return true;
            }
        }
        return false;
    }

    public void generateTerrainHigh(int chunkX, int chunkZ, Block[] idsTop) {
        int subDivXZ = 4;
        int subDivY = 16;
        int seaLevel = 16;
        int xSize = subDivXZ + 1;
        int ySize = 17;
        int zSize = subDivXZ + 1;
        int arrayYHeight = 128;
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, xSize + 5, zSize + 5);
        this.noiseArray = this.initializeNoiseFieldHigh(this.noiseArray, chunkX * subDivXZ, 0, chunkZ * subDivXZ, xSize, ySize, zSize);
        for (int x = 0; x < subDivXZ; ++x) {
            for (int z = 0; z < subDivXZ; ++z) {
                for (int y = 0; y < subDivY; ++y) {
                    double yLerp = 0.125;
                    double noiseDL = this.noiseArray[((x + 0) * zSize + z + 0) * ySize + y + 0];
                    double noiseUL = this.noiseArray[((x + 0) * zSize + z + 1) * ySize + y + 0];
                    double noiseDR = this.noiseArray[((x + 1) * zSize + z + 0) * ySize + y + 0];
                    double noiseUR = this.noiseArray[((x + 1) * zSize + z + 1) * ySize + y + 0];
                    double noiseDLA = (this.noiseArray[((x + 0) * zSize + z + 0) * ySize + y + 1] - noiseDL) * yLerp;
                    double noiseULA = (this.noiseArray[((x + 0) * zSize + z + 1) * ySize + y + 1] - noiseUL) * yLerp;
                    double noiseDRA = (this.noiseArray[((x + 1) * zSize + z + 0) * ySize + y + 1] - noiseDR) * yLerp;
                    double noiseURA = (this.noiseArray[((x + 1) * zSize + z + 1) * ySize + y + 1] - noiseUR) * yLerp;
                    for (int var31 = 0; var31 < 8; ++var31) {
                        double xLerp = 0.25;
                        double var34 = noiseDL;
                        double var36 = noiseUL;
                        double var38 = (noiseDR - noiseDL) * xLerp;
                        double var40 = (noiseUR - noiseUL) * xLerp;
                        for (int var42 = 0; var42 < 4; ++var42) {
                            int index = var42 + x * 4 << 11 | 0 + z * 4 << 7 | y * 8 + var31;
                            index -= arrayYHeight;
                            double zLerp = 0.25;
                            double var49 = (var36 - var34) * zLerp;
                            double var47 = var34 - var49;
                            for (int var51 = 0; var51 < 4; ++var51) {
                                double d;
                                var47 += var49;
                                idsTop[index += arrayYHeight] = d > 0.0 ? Blocks.field_150348_b : (y * 8 + var31 < seaLevel ? TFCBlocks.saltWaterStationary : Blocks.field_150350_a);
                            }
                            var34 += var38;
                            var36 += var40;
                        }
                        noiseDL += noiseDLA;
                        noiseUL += noiseULA;
                        noiseDR += noiseDRA;
                        noiseUR += noiseURA;
                    }
                }
            }
        }
    }

    private double[] initializeNoiseFieldHigh(double[] outArray, int xPos, int yPos, int zPos, int xSize, int ySize, int zSize) {
        if (outArray == null) {
            outArray = new double[xSize * ySize * zSize];
        }
        if (this.parabolicField == null) {
            this.parabolicField = new float[25];
            for (int counter1 = -2; counter1 <= 2; ++counter1) {
                for (int counter2 = -2; counter2 <= 2; ++counter2) {
                    float parabolaHeight;
                    this.parabolicField[counter1 + 2 + (counter2 + 2) * 5] = parabolaHeight = 10.0f / MathHelper.func_76129_c((float)((float)(counter1 * counter1 + counter2 * counter2) + 0.2f));
                }
            }
        }
        double double1 = 1000.0;
        double double2 = 1000.0;
        this.noise6 = this.field_73212_b.func_76305_a(this.noise6, xPos, zPos, xSize, zSize, 200.0, 200.0, 0.5);
        this.noise3 = this.noiseGen3.func_76304_a(this.noise3, xPos, yPos, zPos, xSize, ySize, zSize, double1 / 80.0, double2 / 160.0, double1 / 80.0);
        this.noise1 = this.noiseGen1.func_76304_a(this.noise1, xPos, yPos, zPos, xSize, ySize, zSize, double1, double2, double1);
        this.noise2 = this.noiseGen2.func_76304_a(this.noise2, xPos, yPos, zPos, xSize, ySize, zSize, double1, double2, double1);
        int index1 = 0;
        int index2 = 0;
        for (int x = 0; x < xSize; ++x) {
            for (int z = 0; z < zSize; ++z) {
                float variationBlended = 0.0f;
                float rootBlended = 0.0f;
                float totalBlendedHeight = 0.0f;
                int radius = 2;
                BiomeGenBase baseBiome = this.biomesForGeneration[x + 2 + (z + 2) * (xSize + 5)];
                for (int xR = -radius; xR <= radius; ++xR) {
                    for (int zR = -radius; zR <= radius; ++zR) {
                        BiomeGenBase blendBiome = this.biomesForGeneration[x + xR + 2 + (z + zR + 2) * (xSize + 5)];
                        float blendedHeight = this.parabolicField[xR + 2 + (zR + 2) * 5] / 2.0f;
                        if (blendBiome.field_76748_D > baseBiome.field_76748_D) {
                            blendedHeight *= 0.5f;
                        }
                        variationBlended += blendBiome.field_76749_E * blendedHeight;
                        rootBlended += blendBiome.field_76748_D * blendedHeight;
                        totalBlendedHeight += blendedHeight;
                    }
                }
                variationBlended /= totalBlendedHeight;
                rootBlended /= totalBlendedHeight;
                variationBlended = variationBlended * 0.9f + 0.1f;
                rootBlended = (rootBlended * 4.0f - 1.0f) / 8.0f;
                double scaledNoise6Value = this.noise6[index2] / 8000.0;
                if (scaledNoise6Value < 0.0) {
                    scaledNoise6Value = -scaledNoise6Value * 0.3;
                }
                if ((scaledNoise6Value = scaledNoise6Value * 3.0 - 2.0) < 0.0) {
                    if ((scaledNoise6Value /= 2.0) < -1.0) {
                        scaledNoise6Value = -1.0;
                    }
                    scaledNoise6Value /= 2.8;
                } else {
                    if (scaledNoise6Value > 1.0) {
                        scaledNoise6Value = 1.0;
                    }
                    scaledNoise6Value /= 8.0;
                }
                ++index2;
                for (int y = 0; y < ySize; ++y) {
                    double rootBlendedCopy = rootBlended;
                    rootBlendedCopy += scaledNoise6Value * 0.2;
                    rootBlendedCopy = rootBlendedCopy * (double)ySize / 16.0;
                    double var28 = (double)ySize / 2.0 + rootBlendedCopy * 4.0;
                    double output = 0.0;
                    double var32 = ((double)y - var28) * 12.0 * 256.0 / 256.0 / (2.7 + (double)variationBlended);
                    if (var32 < 0.0) {
                        var32 *= 4.0;
                    }
                    double var34 = this.noise1[index1] / 512.0;
                    double var36 = this.noise2[index1] / 512.0;
                    double var38 = (this.noise3[index1] / 10.0 + 1.0) / 2.0;
                    output = var38 < 0.0 ? var34 : (var38 > 1.0 ? var36 : var34 + (var36 - var34) * var38);
                    output -= var32;
                    if (y > ySize - 4) {
                        double var40 = (float)(y - (ySize - 4)) / 3.0f;
                        output = output * (1.0 - var40) + -10.0 * var40;
                    }
                    outArray[index1] = output;
                    ++index1;
                }
            }
        }
        return outArray;
    }

    private void replaceBlocksForBiomeHigh(int chunkX, int chunkZ, Block[] idsTop, Random rand, Block[] idsBig, byte[] metaBig) {
        int seaLevel = 16;
        int worldHeight = 256;
        int indexOffset = 128;
        double var6 = 0.03125;
        this.stoneNoise = this.noiseGen4.func_76304_a(this.stoneNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, var6 * 4.0, var6 * 1.0, var6 * 4.0);
        boolean[] cliffMap = new boolean[256];
        for (int xCoord = 0; xCoord < 16; ++xCoord) {
            for (int zCoord = 0; zCoord < 16; ++zCoord) {
                int arrayIndex = xCoord + zCoord * 16;
                int arrayIndexDL = zCoord + xCoord * 16;
                int arrayIndex2 = xCoord + 1 + zCoord + 16;
                TFCBiome biome = (TFCBiome)this.getBiome(xCoord, zCoord);
                DataLayer rock1 = this.rockLayer1[arrayIndexDL] == null ? DataLayer.GRANITE : this.rockLayer1[arrayIndexDL];
                DataLayer rock2 = this.rockLayer2[arrayIndexDL] == null ? DataLayer.GRANITE : this.rockLayer2[arrayIndexDL];
                DataLayer rock3 = this.rockLayer3[arrayIndexDL] == null ? DataLayer.GRANITE : this.rockLayer3[arrayIndexDL];
                float rain = this.rainfallLayer[arrayIndexDL] == null ? DataLayer.RAIN_125.floatdata1 : this.rainfallLayer[arrayIndexDL].floatdata1;
                DataLayer drainage = this.drainageLayer[arrayIndexDL] == null ? DataLayer.DRAINAGE_NORMAL : this.drainageLayer[arrayIndexDL];
                int var12 = (int)(this.stoneNoise[arrayIndex2] / 3.0 + 6.0);
                int var13 = -1;
                Block surfaceBlock = TFC_Core.getTypeForGrassWithRain((int)rock1.data1, (float)rain);
                Block subSurfaceBlock = TFC_Core.getTypeForDirtFromGrass((Block)surfaceBlock);
                float bioTemp = TFC_Climate.getBioTemperature((World)this.worldObj, (int)(chunkX * 16 + xCoord), (int)(chunkZ * 16 + zCoord));
                int h = 0;
                if ((TFC_Core.isBeachBiome((int)this.getBiome((int)(xCoord - 1), (int)zCoord).field_76756_M) || TFC_Core.isBeachBiome((int)this.getBiome((int)(xCoord + 1), (int)zCoord).field_76756_M) || TFC_Core.isBeachBiome((int)this.getBiome((int)xCoord, (int)(zCoord + 1)).field_76756_M) || TFC_Core.isBeachBiome((int)this.getBiome((int)xCoord, (int)(zCoord - 1)).field_76756_M)) && !TFC_Core.isBeachBiome((int)this.getBiome((int)xCoord, (int)zCoord).field_76756_M)) {
                    cliffMap[arrayIndex] = true;
                }
                for (int height = 127; height >= 0; --height) {
                    int indexBig = arrayIndex * worldHeight + height + indexOffset;
                    int index = arrayIndex * 128 + height;
                    float temp = TFC_Climate.adjustHeightToTemp((int)height, (float)bioTemp);
                    if (TFC_Core.isBeachBiome((int)biome.field_76756_M) && height > seaLevel + h && idsTop[index] == Blocks.field_150348_b) {
                        idsTop[index] = Blocks.field_150350_a;
                        if (h == 0) {
                            h = (height - 16) / 4;
                        }
                    }
                    if (idsBig[indexBig] == null) {
                        idsBig[indexBig] = idsTop[index];
                        if (indexBig + 1 < idsBig.length && TFC_Core.isSoilOrGravel((Block)idsBig[indexBig + 1]) && idsBig[indexBig] == Blocks.field_150350_a) {
                            int upCount = 1;
                            while (TFC_Core.isSoilOrGravel((Block)idsBig[indexBig + upCount])) {
                                idsBig[indexBig + upCount] = Blocks.field_150350_a;
                                ++upCount;
                            }
                        }
                    }
                    if (idsBig[indexBig] == Blocks.field_150348_b) {
                        if (this.seaLevelOffsetMap[arrayIndex] == 0 && height - 16 >= 0) {
                            this.seaLevelOffsetMap[arrayIndex] = height - 16;
                        }
                        if (this.chunkHeightMap[arrayIndex] == 0) {
                            this.chunkHeightMap[arrayIndex] = height + indexOffset;
                        }
                        this.convertStone(indexOffset + height, arrayIndex, indexBig, idsBig, metaBig, rock1, rock2, rock3);
                        if (rain < 125.0f && temp < 1.5f) {
                            surfaceBlock = TFC_Core.getTypeForSand((int)rock1.data1);
                            subSurfaceBlock = TFC_Core.getTypeForSand((int)rock1.data1);
                        } else if (rain < 125.0f && biome.field_76749_E < 0.5f && temp > 20.0f) {
                            surfaceBlock = TFC_Core.getTypeForSand((int)rock1.data1);
                            subSurfaceBlock = TFC_Core.getTypeForSand((int)rock1.data1);
                        }
                        if (biome == TFCBiome.BEACH || biome == TFCBiome.OCEAN || biome == TFCBiome.DEEP_OCEAN) {
                            subSurfaceBlock = surfaceBlock = TFC_Core.getTypeForSand((int)rock1.data1);
                        } else if (biome == TFCBiome.GRAVEL_BEACH) {
                            subSurfaceBlock = surfaceBlock = TFC_Core.getTypeForGravel((int)rock1.data1);
                        }
                        if (var13 == -1) {
                            int arrayIndexx = xCoord > 0 ? xCoord - 1 + zCoord * 16 : -1;
                            int arrayIndexX = xCoord < 15 ? xCoord + 1 + zCoord * 16 : -1;
                            int arrayIndexz = zCoord > 0 ? xCoord + (zCoord - 1) * 16 : -1;
                            int arrayIndexZ = zCoord < 15 ? xCoord + (zCoord + 1) * 16 : -1;
                            int var12Temp = var12;
                            for (int counter = 1; counter < var12Temp / 3; ++counter) {
                                if (arrayIndexx >= 0 && this.seaLevelOffsetMap[arrayIndex] - 3 * counter > this.seaLevelOffsetMap[arrayIndexx]) {
                                    int n = arrayIndex;
                                    this.seaLevelOffsetMap[n] = this.seaLevelOffsetMap[n] - 1;
                                    --var12;
                                    indexBig = arrayIndex * worldHeight + --height + indexOffset;
                                    index = arrayIndex * 128 + height;
                                    continue;
                                }
                                if (arrayIndexX >= 0 && this.seaLevelOffsetMap[arrayIndex] - 3 * counter > this.seaLevelOffsetMap[arrayIndexX]) {
                                    int n = arrayIndex;
                                    this.seaLevelOffsetMap[n] = this.seaLevelOffsetMap[n] - 1;
                                    --var12;
                                    indexBig = arrayIndex * worldHeight + --height + indexOffset;
                                    index = arrayIndex * 128 + height;
                                    continue;
                                }
                                if (arrayIndexz >= 0 && this.seaLevelOffsetMap[arrayIndex] - 3 * counter > this.seaLevelOffsetMap[arrayIndexz]) {
                                    int n = arrayIndex;
                                    this.seaLevelOffsetMap[n] = this.seaLevelOffsetMap[n] - 1;
                                    --var12;
                                    indexBig = arrayIndex * worldHeight + --height + indexOffset;
                                    index = arrayIndex * 128 + height;
                                    continue;
                                }
                                if (arrayIndexZ < 0 || this.seaLevelOffsetMap[arrayIndex] - 3 * counter <= this.seaLevelOffsetMap[arrayIndexZ]) continue;
                                int n = arrayIndex;
                                this.seaLevelOffsetMap[n] = this.seaLevelOffsetMap[n] - 1;
                                --var12;
                                indexBig = arrayIndex * worldHeight + --height + indexOffset;
                                index = arrayIndex * 128 + height;
                            }
                            var13 = (int)((double)var12 * (1.0 - Math.max(Math.min((double)(height - 16) / 80.0, 1.0), 0.0)));
                            for (int c = 1; c < 3; ++c) {
                                if (indexBig + c >= idsBig.length || idsBig[indexBig + c] == surfaceBlock || idsBig[indexBig + c] == subSurfaceBlock || idsBig[indexBig + c] == TFCBlocks.saltWaterStationary || idsBig[indexBig + c] == TFCBlocks.freshWaterStationary || idsBig[indexBig + c] == TFCBlocks.hotWater) continue;
                                idsBig[indexBig + c] = Blocks.field_150350_a;
                                if (indexBig + c + 1 >= idsBig.length || idsBig[indexBig + c + 1] != TFCBlocks.saltWaterStationary) continue;
                                idsBig[indexBig + c] = subSurfaceBlock;
                                metaBig[indexBig + c] = (byte)TFC_Core.getSoilMeta((int)rock1.data1);
                            }
                            int dirtH = Math.max(8 - (height + 96 - 144) / 16, 0);
                            if (var13 > 0 && height >= seaLevel - 1 && index + 1 < idsTop.length && idsTop[index + 1] != TFCBlocks.saltWaterStationary && dirtH > 0) {
                                idsBig[indexBig] = surfaceBlock;
                                metaBig[indexBig] = (byte)TFC_Core.getSoilMeta((int)rock1.data1);
                                for (int c = 1; c < dirtH && !TFC_Core.isMountainBiome((int)biome.field_76756_M) && biome != TFCBiome.HIGH_HILLS && biome != TFCBiome.HIGH_HILLS_EDGE && !cliffMap[arrayIndex]; ++c) {
                                    int offsetHeight = height - c;
                                    int newIndexBig = arrayIndex * worldHeight + offsetHeight + indexOffset;
                                    idsBig[newIndexBig] = subSurfaceBlock;
                                    metaBig[newIndexBig] = (byte)TFC_Core.getSoilMeta((int)rock1.data1);
                                    if (c <= 1 + (5 - drainage.data1)) continue;
                                    idsBig[newIndexBig] = TFC_Core.getTypeForGravel((int)rock1.data1);
                                    metaBig[newIndexBig] = (byte)TFC_Core.getSoilMeta((int)rock1.data1);
                                }
                            }
                        }
                        if ((height <= seaLevel - 2 || height >= seaLevel || idsTop[index + 1] != TFCBlocks.saltWaterStationary) && (height >= seaLevel || idsTop[index + 1] != TFCBlocks.saltWaterStationary)) continue;
                        if (biome != TFCBiome.SWAMPLAND) {
                            if (idsBig[indexBig] == TFC_Core.getTypeForSand((int)rock1.data1) || rand.nextInt(5) == 0) continue;
                            idsBig[indexBig] = TFC_Core.getTypeForGravel((int)rock1.data1);
                            metaBig[indexBig] = (byte)TFC_Core.getSoilMeta((int)rock1.data1);
                            continue;
                        }
                        if (idsBig[indexBig] == TFC_Core.getTypeForGravel((int)rock1.data1)) continue;
                        idsBig[indexBig] = TFC_Core.getTypeForDirt((int)rock1.data1);
                        metaBig[indexBig] = (byte)TFC_Core.getSoilMeta((int)rock1.data1);
                        continue;
                    }
                    if (idsTop[index] != TFCBlocks.saltWaterStationary || biome == TFCBiome.OCEAN || biome == TFCBiome.DEEP_OCEAN || biome == TFCBiome.BEACH || biome == TFCBiome.GRAVEL_BEACH) continue;
                    idsBig[indexBig] = TFCBlocks.freshWaterStationary;
                }
            }
        }
    }

    private void replaceBlocksForBiomeLow(int par1, int par2, Random rand, Block[] idsBig, byte[] metaBig) {
        for (int xCoord = 0; xCoord < 16; ++xCoord) {
            for (int zCoord = 0; zCoord < 16; ++zCoord) {
                int arrayIndex = xCoord + zCoord * 16;
                int arrayIndexDL = zCoord + xCoord * 16;
                DataLayer rock1 = this.rockLayer1[arrayIndexDL];
                DataLayer rock2 = this.rockLayer2[arrayIndexDL];
                DataLayer rock3 = this.rockLayer3[arrayIndexDL];
                DataLayer stability = this.stabilityLayer[arrayIndexDL];
                TFCBiome biome = (TFCBiome)this.getBiome(xCoord, zCoord);
                for (int height = 127; height >= 0; --height) {
                    int indexBig = arrayIndex * 256 + height;
                    metaBig[indexBig] = 0;
                    if (height <= 1 + this.seaLevelOffsetMap[arrayIndex] / 3 + this.rand.nextInt(3)) {
                        idsBig[indexBig] = Blocks.field_150357_h;
                    } else if (idsBig[indexBig] == null) {
                        this.convertStone(height, arrayIndex, indexBig, idsBig, metaBig, rock1, rock2, rock3);
                        if ((TFC_Core.isBeachBiome((int)biome.field_76756_M) || TFC_Core.isOceanicBiome((int)biome.field_76756_M)) && idsBig[indexBig + 1] == TFCBlocks.saltWaterStationary) {
                            idsBig[indexBig] = TFC_Core.getTypeForSand((int)rock1.data1);
                            metaBig[indexBig] = (byte)TFC_Core.getSoilMeta((int)rock1.data1);
                            idsBig[indexBig - 1] = TFC_Core.getTypeForSand((int)rock1.data1);
                            metaBig[indexBig - 1] = (byte)TFC_Core.getSoilMeta((int)rock1.data1);
                        }
                    }
                    if (height > 6 || stability.data1 != 1 || idsBig[indexBig] != Blocks.field_150350_a) continue;
                    idsBig[indexBig] = TFCBlocks.lava;
                    metaBig[indexBig] = 0;
                    if (idsBig[indexBig + 1] == TFCBlocks.lava || !rand.nextBoolean()) continue;
                    idsBig[indexBig + 1] = TFCBlocks.lava;
                    metaBig[indexBig + 1] = 0;
                }
            }
        }
    }

    public void convertStone(int height, int indexArray, int indexBig, Block[] idsBig, byte[] metaBig, DataLayer rock1, DataLayer rock2, DataLayer rock3) {
        if (idsBig[indexBig] != null && idsBig[indexBig] != Blocks.field_150348_b) {
            return;
        }
        if (height <= TFCOptions.rockLayer3Height + this.seaLevelOffsetMap[indexArray]) {
            idsBig[indexBig] = rock3.block;
            metaBig[indexBig] = (byte)rock3.data2;
        } else if (height <= TFCOptions.rockLayer2Height + this.seaLevelOffsetMap[indexArray] && height > 55 + this.seaLevelOffsetMap[indexArray] && rock2 != null) {
            idsBig[indexBig] = rock2.block;
            metaBig[indexBig] = (byte)rock2.data2;
        } else {
            idsBig[indexBig] = rock1.block;
            metaBig[indexBig] = (byte)rock1.data2;
        }
    }

    public boolean func_73156_b() {
        return true;
    }
}

