/*
 * Decompiled with CFR 0.152.
 */
package joshuastone.joshxmas;

import java.util.Random;
import joshuastone.joshxmas.XMasSoundHandler;
import joshuastone.joshxmas.blocks.BlockMistletoeWild;
import joshuastone.joshxmas.blocks.XMasBlocks;
import joshuastone.joshxmas.items.XMasItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class XMasEventHandler {
    public static final XMasEventHandler instance = new XMasEventHandler();

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> e) {
        XMasSoundHandler.registerSounds(e);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> e) {
        XMasBlocks.registerBlocks(e);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> e) {
        XMasBlocks.registerItemBlocks(e);
        XMasItems.registerItems(e);
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation loc = event.getName();
        if (loc == LootTableList.field_186423_e) {
            LootPool pool = event.getTable().getPool("main");
            LootCondition[] cond1 = new LootCondition[]{};
            LootFunction[] func1 = new LootFunction[]{new SetCount(cond1, new RandomValueRange(1.0f, 3.0f))};
            this.addLootEntry(pool, (Item)XMasItems.ginger, 20, 1, func1, cond1);
            this.addLootEntry(pool, (Item)XMasItems.peppermintSeeds, 20, 1, func1, cond1);
        } else if (loc == LootTableList.field_186422_d) {
            LootPool pool = event.getTable().getPool("main");
            LootPool poolB = event.getTable().getPool("pool1");
            LootCondition[] cond0 = new LootCondition[]{};
            LootFunction[] func0 = new LootFunction[]{};
            LootCondition[] cond1 = new LootCondition[]{};
            LootFunction[] func1 = new LootFunction[]{new SetCount(cond1, new RandomValueRange(1.0f, 3.0f))};
            this.addLootEntry(poolB, (Item)XMasItems.ginger, 20, 1, func1, cond1);
            this.addLootEntry(poolB, (Item)XMasItems.peppermintSeeds, 20, 1, func1, cond1);
            this.addLootEntry(pool, (Item)XMasItems.recordDeckTheHalls, 15, 1, func0, cond0);
            this.addLootEntry(pool, (Item)XMasItems.recordJingleBells, 15, 1, func0, cond0);
            this.addLootEntry(pool, (Item)XMasItems.recordSilentNight, 15, 1, func0, cond0);
            this.addLootEntry(pool, (Item)XMasItems.recordWeWish, 15, 1, func0, cond0);
        } else if (loc == LootTableList.field_186424_f) {
            LootPool poolB = event.getTable().getPool("pool1");
            LootCondition[] cond1 = new LootCondition[]{};
            LootFunction[] func1 = new LootFunction[]{new SetCount(cond1, new RandomValueRange(1.0f, 3.0f))};
            this.addLootEntry(poolB, (Item)XMasItems.ginger, 15, 1, func1, cond1);
            this.addLootEntry(poolB, (Item)XMasItems.peppermintSeeds, 15, 1, func1, cond1);
        } else if (loc == LootTableList.field_186431_m) {
            LootPool pool = event.getTable().getPool("main");
            LootPool poolB = event.getTable().getPool("pool1");
            LootCondition[] cond0 = new LootCondition[]{};
            LootFunction[] func0 = new LootFunction[]{};
            LootCondition[] cond1 = new LootCondition[]{};
            LootFunction[] func1 = new LootFunction[]{new SetCount(cond1, new RandomValueRange(1.0f, 3.0f))};
            this.addLootEntry(pool, (Item)XMasItems.ginger, 15, 1, func1, cond1);
            this.addLootEntry(pool, (Item)XMasItems.peppermintSeeds, 15, 1, func1, cond1);
            this.addLootEntry(poolB, (Item)XMasItems.recordDeckTheHalls, 1, 1, func0, cond0);
            this.addLootEntry(poolB, (Item)XMasItems.recordJingleBells, 1, 1, func0, cond0);
            this.addLootEntry(poolB, (Item)XMasItems.recordSilentNight, 1, 1, func0, cond0);
            this.addLootEntry(poolB, (Item)XMasItems.recordWeWish, 1, 1, func0, cond0);
        } else if (loc == LootTableList.field_186428_j || loc == LootTableList.field_186427_i) {
            LootPool pool = event.getTable().getPool("main");
            LootCondition[] cond1 = new LootCondition[]{};
            LootFunction[] func1 = new LootFunction[]{new SetCount(cond1, new RandomValueRange(1.0f, 3.0f))};
            this.addLootEntry(pool, (Item)XMasItems.ginger, 15, 1, func1, cond1);
            this.addLootEntry(pool, (Item)XMasItems.peppermintSeeds, 15, 1, func1, cond1);
        }
    }

    protected void addLootEntry(LootPool pool, Item item, int weight, int quality, LootFunction[] func, LootCondition[] cond) {
        LootEntryItem entry = new LootEntryItem(item, weight, quality, func, cond, item.getRegistryName().func_110623_a());
        pool.addEntry((LootEntry)entry);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDecorate(DecorateBiomeEvent.Post event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        BlockPos chunkPos = event.getPos();
        if (this.isMistletoeChunk(world, (int)Math.floor(chunkPos.func_177958_n() / 16), (int)Math.floor(chunkPos.func_177952_p() / 16))) {
            for (int x = 0; x < 16; ++x) {
                boolean flag = false;
                block1: for (int z = 0; z < 16; ++z) {
                    if (!this.isMistletoeColumn(world, x + chunkPos.func_177958_n(), z + chunkPos.func_177952_p())) continue;
                    for (int y = world.func_72800_K() - 1; y > 1; --y) {
                        BlockPos pos = new BlockPos(x + chunkPos.func_177958_n(), y, z + chunkPos.func_177952_p());
                        if (!world.func_175623_d(pos) || !XMasBlocks.mistletoeWild.func_176198_a(world, pos, EnumFacing.DOWN) || !(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockBush) && !world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76222_j()) continue;
                        world.func_175656_a(pos, XMasBlocks.mistletoeWild.func_176223_P().func_177226_a((IProperty)BlockMistletoeWild.AGE, (Comparable)Integer.valueOf(event.getRand().nextInt(3))));
                        continue block1;
                    }
                }
            }
        }
    }

    protected boolean isMistletoeChunk(World world, int chunkX, int chunkZ) {
        Random rand = new Random(world.func_72905_C() + (long)(chunkX * chunkX * 4987142) + (long)(chunkX * 5947611) + (long)(chunkZ * chunkZ) * 4392871L + (long)(chunkZ * 389711) ^ 0x3AD8025FL);
        return rand.nextInt(31) == 0;
    }

    protected boolean isMistletoeColumn(World world, int x, int z) {
        BlockPos pos = new BlockPos(x, world.func_72800_K() - 1, z);
        Biome biome = world.func_180494_b(pos);
        if (biome.func_150561_m() != Biome.TempCategory.MEDIUM && biome.func_150561_m() != Biome.TempCategory.COLD || biome.func_76736_e()) {
            return false;
        }
        Random rand = new Random(world.func_72905_C() + (long)(x * x * 4987142) + (long)(x * 5947611) + (long)(z * z) * 4392871L + (long)(z * 389711) ^ 0x3AD8025FL);
        return rand.nextInt(63) < 2;
    }
}

