/*
 * Decompiled with CFR 0.152.
 */
package joshuastone.joshxmas.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import joshuastone.joshxmas.blocks.BlockMistletoe;
import joshuastone.joshxmas.items.XMasItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMistletoeWild
extends BlockMistletoe
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)2);
    protected static final AxisAlignedBB HIT_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public BlockMistletoeWild() {
        this.func_149663_c("mistletoe_wild");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149649_H();
        this.func_149675_a(true);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.getItemForState(state));
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getItemForState(state);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getItemForState(state));
    }

    protected Item getItemForState(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 2 ? XMasItems.mistletoeBerries : XMasItems.mistletoeWild;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return HIT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    @Override
    protected boolean canPlaceOn(IBlockState state) {
        Block block = state.func_177230_c();
        return block instanceof BlockLeaves || block instanceof BlockLog && (state.func_177229_b((IProperty)BlockLog.field_176299_a) == BlockLog.EnumAxis.X || state.func_177229_b((IProperty)BlockLog.field_176299_a) == BlockLog.EnumAxis.Z);
    }

    protected int getMaxAge() {
        return 2;
    }

    protected int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected boolean isMaxAge(IBlockState state) {
        return this.getAge(state) >= this.getMaxAge();
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List list = super.getDrops(world, pos, state, fortune);
        int age = this.getAge(state);
        if (age >= this.getMaxAge()) {
            Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
            for (int i = 0; i < 3 + fortune; ++i) {
                if (i != 0 && rand.nextInt(2 * this.getMaxAge()) > age) continue;
                list.add(new ItemStack((Item)XMasItems.mistletoeBerries));
            }
        }
        return list;
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        int min = 2;
        int max = 5;
        return worldIn.field_73012_v.nextInt(max - min + 1) + min;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return !this.isMaxAge(state);
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.glowMistletoe(worldIn, pos, state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!this.isMaxAge(state) && worldIn.func_175671_l(pos) >= 6 && rand.nextInt(10) < 5) {
            this.glowMistletoe(worldIn, pos, state);
        }
    }

    protected void glowMistletoe(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.isMaxAge(state)) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE) + 1)));
        }
    }
}

