/*
 * Decompiled with CFR 0.152.
 */
package joshuastone.joshxmas.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import joshuastone.joshxmas.items.XMasItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWreath
extends Block {
    public static final PropertyEnum SIDE = PropertyEnum.func_177709_a((String)"side", EnumSide.class);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);
    protected ItemBlock itemBlock = (ItemBlock)new ItemBlock((Block)this).func_77656_e(0).func_77625_d(16);

    public ItemBlock getItemBlock() {
        return this.itemBlock;
    }

    public BlockWreath() {
        super(Material.field_151585_k);
        this.func_149663_c("wreath");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SIDE, (Comparable)((Object)EnumSide.byMetadata(0))));
        this.func_149672_a(SoundType.field_185850_c);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_181623_g() {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumSide side = (EnumSide)((Object)state.func_177229_b((IProperty)SIDE));
        return side == EnumSide.SOUTH ? SOUTH_AABB : (side == EnumSide.WEST ? WEST_AABB : (side == EnumSide.NORTH ? NORTH_AABB : EAST_AABB));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)XMasItems.wreath, 1, 0);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Item)XMasItems.wreath);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return XMasItems.wreath;
    }

    public boolean canPlaceOn(IBlockState state) {
        if (state.func_185917_h() && state.func_185904_a().func_76230_c()) {
            return true;
        }
        Block block = state.func_177230_c();
        return block instanceof BlockStairs || block instanceof BlockSlab && state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        switch (side) {
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                return this.canPlaceOn(world.func_180495_p(pos.func_177972_a(side.func_176734_d())));
            }
        }
        return false;
    }

    protected EnumSide getSideFromFacing(EnumFacing facing) {
        return facing == EnumFacing.EAST ? EnumSide.EAST : (facing == EnumFacing.NORTH ? EnumSide.NORTH : (facing == EnumFacing.WEST ? EnumSide.WEST : EnumSide.SOUTH));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumSide side = this.getSideFromFacing(facing.func_176734_d());
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)SIDE, (Comparable)((Object)side));
        return state;
    }

    protected IBlockState getBlockBehind(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumSide side = (EnumSide)((Object)state.func_177229_b((IProperty)SIDE));
        return world.func_180495_p(side == EnumSide.EAST ? pos.func_177974_f() : (side == EnumSide.NORTH ? pos.func_177978_c() : (side == EnumSide.WEST ? pos.func_177976_e() : pos.func_177968_d())));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos updatedBlock) {
        if (!world.field_72995_K && !this.canPlaceOn(this.getBlockBehind(state, (IBlockAccess)world, pos))) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SIDE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SIDE, (Comparable)((Object)EnumSide.byMetadata(meta < 4 ? meta : meta - 4)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumSide)((Object)state.func_177229_b((IProperty)SIDE))).getMetadata();
    }

    public static enum EnumSide implements IStringSerializable
    {
        SOUTH(0, "south"),
        WEST(1, "west"),
        NORTH(2, "north"),
        EAST(3, "east");

        private int meta;
        private String name;
        private static final EnumSide[] META_LOOKUP;

        private EnumSide(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public int getMetadata() {
            return this.meta;
        }

        public static EnumSide byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumSide[EnumSide.values().length];
            EnumSide[] enumSideArray = EnumSide.values();
            int n = enumSideArray.length;
            for (int i = 0; i < n; ++i) {
                EnumSide type;
                EnumSide.META_LOOKUP[type.getMetadata()] = type = enumSideArray[i];
            }
        }
    }
}

