/*
 * Decompiled with CFR 0.152.
 */
package joshuastone.joshxmas.blocks;

import javax.annotation.Nullable;
import joshuastone.joshxmas.ChristmasMod;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockXMasLights
extends Block {
    public static final PropertyEnum CONNECT = PropertyEnum.func_177709_a((String)"connect", EnumConnect.class);
    public static final PropertyEnum SIDE = PropertyEnum.func_177709_a((String)"side", EnumSide.class);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);
    protected ItemBlock itemBlock = (ItemBlock)new ItemBlock((Block)this).func_77656_e(0);
    protected String color;

    public ItemBlock getItemBlock() {
        return this.itemBlock;
    }

    public String getColor() {
        return this.color;
    }

    public String getName() {
        return "christmas_lights_" + this.color;
    }

    public BlockXMasLights(String color) {
        super(Material.field_151594_q);
        this.color = color;
        this.func_149663_c(this.getName());
        this.func_149647_a(ChristmasMod.TAB_XMAS);
        this.func_149715_a(0.75f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)CONNECT, (Comparable)((Object)EnumConnect.NONE)).func_177226_a((IProperty)SIDE, (Comparable)((Object)EnumSide.byMetadata(0))));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_181623_g() {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    private boolean canPlaceOn(IBlockState state) {
        if (state.func_185917_h() && state.func_185904_a().func_76230_c()) {
            return true;
        }
        Block block = state.func_177230_c();
        return block instanceof BlockGlass || block instanceof BlockStainedGlass || block instanceof BlockPane || block instanceof BlockStairs || block instanceof BlockSlab && state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP || block instanceof BlockFence;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        switch (side) {
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                return this.canPlaceOn(world.func_180495_p(pos.func_177972_a(side.func_176734_d())));
            }
        }
        return false;
    }

    protected EnumSide getSideFromFacing(EnumFacing facing) {
        return facing == EnumFacing.EAST ? EnumSide.EAST : (facing == EnumFacing.NORTH ? EnumSide.NORTH : (facing == EnumFacing.WEST ? EnumSide.WEST : EnumSide.SOUTH));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)SIDE, (Comparable)((Object)this.getSideFromFacing(facing.func_176734_d())));
        return state;
    }

    protected IBlockState getBlockBehind(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumSide side = (EnumSide)((Object)state.func_177229_b((IProperty)SIDE));
        return world.func_180495_p(side == EnumSide.EAST ? pos.func_177974_f() : (side == EnumSide.NORTH ? pos.func_177978_c() : (side == EnumSide.WEST ? pos.func_177976_e() : pos.func_177968_d())));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos updatedBlock) {
        if (!world.field_72995_K && !this.canPlaceOn(this.getBlockBehind(state, (IBlockAccess)world, pos))) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    protected EnumConnect getConnect(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumSide side = (EnumSide)((Object)state.func_177229_b((IProperty)SIDE));
        BlockPos testPos = pos.func_177978_c();
        if (side == EnumSide.WEST) {
            testPos = pos.func_177974_f();
        } else if (side == EnumSide.NORTH) {
            testPos = pos.func_177968_d();
        } else if (side == EnumSide.EAST) {
            testPos = pos.func_177976_e();
        }
        IBlockState testState = world.func_180495_p(testPos);
        EnumConnect connect = EnumConnect.NONE;
        if (testState.func_177230_c() == this) {
            EnumSide testSide = EnumSide.byMetadata(this.func_176201_c(testState));
            switch (side) {
                case SOUTH: {
                    if (testSide == EnumSide.EAST) {
                        connect = EnumConnect.LEFT;
                        break;
                    }
                    if (testSide != EnumSide.WEST) break;
                    connect = EnumConnect.RIGHT;
                    break;
                }
                case WEST: {
                    if (testSide == EnumSide.SOUTH) {
                        connect = EnumConnect.LEFT;
                        break;
                    }
                    if (testSide != EnumSide.NORTH) break;
                    connect = EnumConnect.RIGHT;
                    break;
                }
                case NORTH: {
                    if (testSide == EnumSide.WEST) {
                        connect = EnumConnect.LEFT;
                        break;
                    }
                    if (testSide != EnumSide.EAST) break;
                    connect = EnumConnect.RIGHT;
                    break;
                }
                case EAST: {
                    if (testSide == EnumSide.NORTH) {
                        connect = EnumConnect.LEFT;
                        break;
                    }
                    if (testSide != EnumSide.SOUTH) break;
                    connect = EnumConnect.RIGHT;
                }
            }
        }
        return connect;
    }

    protected boolean renderLightsNorth(EnumSide side, EnumConnect connect) {
        return side == EnumSide.NORTH || side == EnumSide.EAST && connect == EnumConnect.LEFT || side == EnumSide.WEST && connect == EnumConnect.RIGHT;
    }

    protected boolean renderLightsSouth(EnumSide side, EnumConnect connect) {
        return side == EnumSide.SOUTH || side == EnumSide.EAST && connect == EnumConnect.RIGHT || side == EnumSide.WEST && connect == EnumConnect.LEFT;
    }

    protected boolean renderLightsEast(EnumSide side, EnumConnect connect) {
        return side == EnumSide.EAST || side == EnumSide.NORTH && connect == EnumConnect.LEFT || side == EnumSide.SOUTH && connect == EnumConnect.RIGHT;
    }

    protected boolean renderLightsWest(EnumSide side, EnumConnect connect) {
        return side == EnumSide.WEST || side == EnumSide.NORTH && connect == EnumConnect.RIGHT || side == EnumSide.SOUTH && connect == EnumConnect.LEFT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_185899_b(world, pos);
        EnumSide side = (EnumSide)((Object)state.func_177229_b((IProperty)SIDE));
        EnumConnect connect = (EnumConnect)((Object)state.func_177229_b((IProperty)CONNECT));
        int i = 0;
        AxisAlignedBB hitbox = field_185505_j;
        if (this.renderLightsNorth(side, connect)) {
            hitbox = NORTH_AABB;
            ++i;
        }
        if (this.renderLightsSouth(side, connect)) {
            hitbox = SOUTH_AABB;
            ++i;
        }
        if (this.renderLightsEast(side, connect)) {
            hitbox = EAST_AABB;
            ++i;
        }
        if (this.renderLightsWest(side, connect)) {
            hitbox = WEST_AABB;
            ++i;
        }
        return i == 1 ? hitbox : field_185505_j;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECT, SIDE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SIDE, (Comparable)((Object)EnumSide.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumSide)((Object)state.func_177229_b((IProperty)SIDE))).getMetadata();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)CONNECT, (Comparable)((Object)this.getConnect(state, world, pos)));
    }

    public static enum EnumSide implements IStringSerializable
    {
        SOUTH(0, "south"),
        WEST(1, "west"),
        NORTH(2, "north"),
        EAST(3, "east");

        private int meta;
        private String name;
        private static final EnumSide[] META_LOOKUP;

        private EnumSide(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public int getMetadata() {
            return this.meta;
        }

        public static EnumSide byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumSide[EnumSide.values().length];
            EnumSide[] enumSideArray = EnumSide.values();
            int n = enumSideArray.length;
            for (int i = 0; i < n; ++i) {
                EnumSide type;
                EnumSide.META_LOOKUP[type.getMetadata()] = type = enumSideArray[i];
            }
        }
    }

    public static enum EnumConnect implements IStringSerializable
    {
        NONE("none"),
        LEFT("left"),
        RIGHT("right");

        private String name;

        private EnumConnect(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

