/*
 * Decompiled with CFR 0.152.
 */
package joshuastone.joshxmas.blocks.presents;

import javax.annotation.Nullable;
import joshuastone.joshxmas.ChristmasMod;
import joshuastone.joshxmas.blocks.presents.tileentity.TileEntityPresentChest;
import joshuastone.joshxmas.blocks.presents.tileentity.TileEntityPresentChestBlue;
import joshuastone.joshxmas.blocks.presents.tileentity.TileEntityPresentChestGreen;
import joshuastone.joshxmas.blocks.presents.tileentity.TileEntityPresentChestPurple;
import joshuastone.joshxmas.blocks.presents.tileentity.TileEntityPresentChestRed;
import joshuastone.joshxmas.blocks.presents.tileentity.TileEntityPresentChestWhite;
import joshuastone.joshxmas.blocks.presents.tileentity.TileEntityPresentChestYellow;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;

public class BlockPresentChest
extends BlockChest {
    public final Color color;

    public BlockPresentChest(Color color) {
        super(null);
        this.color = color;
        this.func_149663_c("present_chest_" + this.color.getName());
        this.func_149647_a(ChristmasMod.TAB_XMAS);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return this.color == Color.RED ? new TileEntityPresentChestRed() : (this.color == Color.YELLOW ? new TileEntityPresentChestYellow() : (this.color == Color.GREEN ? new TileEntityPresentChestGreen() : (this.color == Color.BLUE ? new TileEntityPresentChestBlue() : (this.color == Color.PURPLE ? new TileEntityPresentChestPurple() : new TileEntityPresentChestWhite()))));
    }

    private boolean isBelowSolidBlock(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177984_a()).isSideSolid((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN);
    }

    private boolean isOcelotSittingOnChest(World worldIn, BlockPos pos) {
        for (Entity entity : worldIn.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)))) {
            EntityOcelot entityocelot = (EntityOcelot)entity;
            if (!entityocelot.func_70906_o()) continue;
            return true;
        }
        return false;
    }

    private boolean isBlocked(World worldIn, BlockPos pos) {
        return this.isBelowSolidBlock(worldIn, pos) || this.isOcelotSittingOnChest(worldIn, pos);
    }

    @Nullable
    public ILockableContainer func_189418_a(World p_189418_1_, BlockPos p_189418_2_, boolean p_189418_3_) {
        TileEntity tileentity = p_189418_1_.func_175625_s(p_189418_2_);
        if (!(tileentity instanceof TileEntityPresentChest)) {
            return null;
        }
        TileEntityPresentChest ilockablecontainer = (TileEntityPresentChest)tileentity;
        if (!p_189418_3_ && this.isBlocked(p_189418_1_, p_189418_2_)) {
            return null;
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = p_189418_2_.func_177972_a(enumfacing);
            Block block = p_189418_1_.func_180495_p(blockpos).func_177230_c();
            if (block != this) continue;
            if (this.isBlocked(p_189418_1_, blockpos)) {
                return null;
            }
            TileEntity tileentity1 = p_189418_1_.func_175625_s(blockpos);
            if (!(tileentity1 instanceof TileEntityPresentChest)) continue;
            if (enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH) {
                ilockablecontainer = new InventoryLargeChest("container.presentChestDouble", (ILockableContainer)ilockablecontainer, (ILockableContainer)((TileEntityPresentChest)tileentity1));
                continue;
            }
            ilockablecontainer = new InventoryLargeChest("container.presentChestDouble", (ILockableContainer)((TileEntityPresentChest)tileentity1), (ILockableContainer)ilockablecontainer);
        }
        return ilockablecontainer;
    }

    public static enum Color {
        RED,
        YELLOW,
        GREEN,
        BLUE,
        PURPLE,
        WHITE;


        public String getName() {
            return this == RED ? "red" : (this == YELLOW ? "yellow" : (this == GREEN ? "green" : (this == BLUE ? "blue" : (this == PURPLE ? "purple" : "white"))));
        }
    }
}

