/*
 * Decompiled with CFR 0.152.
 */
package com.criobite.joshxmas;

import com.criobite.joshxmas.XMasGenFeatures;
import com.criobite.joshxmas.XMasLoot;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.IModInfo;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public abstract class XMasForgeEvents {
    private static IModInfo _modInfo = null;
    private static boolean versionNotified = false;

    private static IModInfo getModInfo() {
        if (_modInfo == null) {
            _modInfo = ((ModContainer)ModList.get().getModContainerById("joshxmas").get()).getModInfo();
        }
        return _modInfo;
    }

    @SubscribeEvent
    public static void entityJoinWorld(EntityJoinWorldEvent e) {
        if (!versionNotified && FMLEnvironment.dist == Dist.CLIENT && !e.getWorld().field_72995_K && e.getEntity() != null && e.getEntity() instanceof PlayerEntity && XMasForgeEvents.isVersionOutdated()) {
            PlayerEntity player = (PlayerEntity)e.getEntity();
            player.func_145747_a((ITextComponent)XMasForgeEvents.getVersionMessage().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), Util.field_240973_b_);
            versionNotified = true;
        }
    }

    @SubscribeEvent
    public static void joinWorld(WorldEvent.Load e) {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER && XMasForgeEvents.isVersionOutdated()) {
            System.out.println(XMasForgeEvents.getVersionMessage().func_150261_e());
        }
    }

    private static boolean isVersionOutdated() {
        return VersionChecker.getResult((IModInfo)XMasForgeEvents.getModInfo()).status == VersionChecker.Status.OUTDATED;
    }

    private static TranslationTextComponent getVersionMessage() {
        return new TranslationTextComponent("update.joshxmas", new Object[]{new StringTextComponent(VersionChecker.getResult((IModInfo)XMasForgeEvents.getModInfo()).target.toString())});
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void modifyBiomes(BiomeLoadingEvent e) {
        Biome.Climate climate = e.getClimate();
        if (climate.field_242461_c < 0.8f && climate.field_242463_e < 0.9f && e.getCategory() != Biome.Category.OCEAN && e.getCategory() != Biome.Category.THEEND && e.getCategory() != Biome.Category.NETHER && !e.equals(Biomes.field_185440_P)) {
            e.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> XMasGenFeatures.PATCH_WILD_MISTLETOE);
        }
    }

    @SubscribeEvent
    public static void lootTablesLoad(LootTableLoadEvent e) {
        XMasLoot.modifyLootTable(e.getName(), e.getTable());
    }

    @SubscribeEvent
    public static void wandererTrades(WandererTradesEvent e) {
        XMasLoot.modifyWandererTrades(e.getGenericTrades(), e.getRareTrades());
    }
}

